/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperNodes;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperNodesFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyErrChainExceptions;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTextIOWrapper})
public final class TextIOWrapperBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TextIOWrapperBuiltinsFactory.getFactories();
    }

    static void encoderSetState(VirtualFrame frame, Node inliningTarget, PTextIO self, PTextIO.CookieType cookie, TextIOWrapperNodes.EncoderResetNode encoderResetNode) {
        encoderResetNode.execute(frame, inliningTarget, self, cookie.startPos == 0L && cookie.decFlags == 0);
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends InitCheckPythonUnaryBuiltinNode {
        ReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached(value="create(Repr)") LookupAndCallUnaryNode repr, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached IONodes.ToTruffleStringNode toString, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isValueError, @Cached PRaiseNode.Lazy raiseNode) {
            if (!PythonContext.get(inliningTarget).reprEnter(self)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.REENTRANT_CALL_INSIDE_P_REPR, self);
            }
            try {
                Object nameobj = PNone.NO_VALUE;
                try {
                    nameobj = lookup.execute((Frame)frame, inliningTarget, self, IONodes.T_NAME);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonErrorType.ValueError, isValueError);
                }
                Object modeobj = lookup.execute((Frame)frame, inliningTarget, self, IONodes.T_MODE);
                if (nameobj instanceof PNone) {
                    if (modeobj == PNone.NO_VALUE) {
                        TruffleString truffleString = simpleTruffleStringFormatNode.format("<_io.TextIOWrapper encoding='%s'>", self.getEncoding());
                        return truffleString;
                    }
                    TruffleString truffleString = simpleTruffleStringFormatNode.format("<_io.TextIOWrapper mode='%s' encoding='%s'>", toString.execute(inliningTarget, modeobj), self.getEncoding());
                    return truffleString;
                }
                Object name = repr.executeObject(frame, nameobj);
                if (modeobj == PNone.NO_VALUE) {
                    TruffleString truffleString = simpleTruffleStringFormatNode.format("<_io.TextIOWrapper name=%s encoding='%s'>", toString.execute(inliningTarget, name), self.getEncoding());
                    return truffleString;
                }
                TruffleString truffleString = simpleTruffleStringFormatNode.format("<_io.TextIOWrapper name=%s mode='%s' encoding='%s'>", toString.execute(inliningTarget, name), toString.execute(inliningTarget, modeobj), self.getEncoding());
                return truffleString;
            }
            finally {
                PythonContext.get(inliningTarget).reprLeave(self);
            }
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IternextNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IternextNode() {
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)"})
        static TruffleString doit(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.ReadlineNode readlineNode, @Cached PRaiseNode.Lazy raiseNode) {
            self.setTelling(false);
            TruffleString line = readlineNode.execute(frame, self, -1);
            if (line.isEmpty()) {
                self.clearSnapshot();
                self.setTelling(self.isSeekable());
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            return line;
        }
    }

    @Builtin(name="_CHUNK_SIZE", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class ChunkSizeNode
    extends PythonBuiltinNode {
        ChunkSizeNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isDetached()", "isNoValue(none)"})
        static Object none(PTextIO self, PNone none) {
            return self.getChunkSize();
        }

        @Specialization(guards={"self.isOK()", "!self.isDetached()", "!isNoValue(arg)", "!isDeleteMarker(arg)"})
        static Object chunkSize(VirtualFrame frame, PTextIO self, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            int size = asSizeNode.executeExact((Frame)frame, inliningTarget, arg, PythonErrorType.ValueError);
            if (size <= 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.A_STRICTLY_POSITIVE_INTEGER_IS_REQUIRED);
            }
            self.setChunkSize(size);
            return 0;
        }

        @Specialization(guards={"self.isOK()", "!self.isDetached()"})
        static Object noDelete(PTextIO self, DescriptorDeleteMarker marker, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.CANNOT_DELETE);
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PTextIO self, Object arg, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }

        @Specialization(guards={"self.isOK()", "self.isDetached()"})
        static Object attachError(PTextIO self, Object arg, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.DETACHED_BUFFER);
        }
    }

    @Builtin(name="errors", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ErrorsNode
    extends InitCheckPythonUnaryBuiltinNode {
        ErrorsNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static TruffleString doit(PTextIO self) {
            return self.getErrors();
        }
    }

    @Builtin(name="newlines", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NewlinesNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        NewlinesNode() {
        }

        @Specialization(guards={"checkAttached(self)", "!self.hasDecoder()"})
        static Object none(VirtualFrame frame, PTextIO self) {
            return PNone.NONE;
        }

        @Specialization(guards={"checkAttached(self)", "self.hasDecoder()"})
        static Object doit(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_NEWLINES);
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object closed(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr lookupAttr) {
            return lookupAttr.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_CLOSED);
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        NameNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object name(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_NAME);
        }
    }

    @Builtin(name="_finalizing", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class FinalizingNode
    extends PythonUnaryBuiltinNode {
        FinalizingNode() {
        }

        @Specialization
        static Object finalizing(PTextIO self) {
            return self.isFinalizing();
        }
    }

    @Builtin(name="write_through", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class WriteThroughNode
    extends PythonUnaryBuiltinNode {
        WriteThroughNode() {
        }

        @Specialization
        static Object writeThrough(PTextIO self) {
            return self.isWriteThrough();
        }
    }

    @Builtin(name="line_buffering", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class LineBufferingNode
    extends PythonUnaryBuiltinNode {
        LineBufferingNode() {
        }

        @Specialization
        static Object lineBuffering(PTextIO self) {
            return self.isLineBuffering();
        }
    }

    @Builtin(name="buffer", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class BufferNode
    extends PythonUnaryBuiltinNode {
        BufferNode() {
        }

        @Specialization
        static Object buffer(PTextIO self) {
            return self.getBuffer();
        }
    }

    @Builtin(name="encoding", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EncodingNode
    extends PythonUnaryBuiltinNode {
        EncodingNode() {
        }

        @Specialization
        static TruffleString doit(PTextIO self) {
            return self.getEncoding();
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, parameterNames={"$self", "pos"})
    @ArgumentClinic(name="pos", defaultValue="PNone.NONE", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends AttachedCheckPythonBinaryClinicBuiltinNode {
        TruncateNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.TruncateNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object truncate(VirtualFrame frame, PTextIO self, Object pos, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached PyObjectCallMethodObjArgs callMethodTruncate) {
            callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            return callMethodTruncate.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_TRUNCATE, pos);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        TellNode() {
        }

        @Specialization(guards={"!self.isSeekable() || !self.isTelling()"})
        static Object error(VirtualFrame frame, PTextIO self, @Cached PRaiseNode raiseNode) {
            if (!self.isSeekable()) {
                throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.UNDERLYING_STREAM_IS_NOT_SEEKABLE);
            }
            throw raiseNode.raise(PythonErrorType.OSError, ErrorMessages.TELLING_POSITION_DISABLED_BY_NEXT_CALL);
        }

        protected static boolean hasDecoderAndSnapshot(PTextIO self) {
            return self.hasDecoder() && self.hasSnapshotNextInput();
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.isSeekable()", "self.isTelling()", "!hasDecoderAndSnapshot(self)"})
        static Object getPos(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodTell) {
            writeFlushNode.execute(frame, inliningTarget, self);
            callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            return callMethodTell.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_TELL, new Object[0]);
        }

        protected static boolean hasUsedDecodedChar(PTextIO self) {
            return self.getDecodedCharsUsed() > 0;
        }

        private static PTextIO.CookieType getCookie(VirtualFrame frame, Node inliningTarget, PTextIO self, TextIOWrapperNodes.WriteFlushNode writeFlushNode, PyObjectCallMethodObjArgs callMethodFlush, PyObjectCallMethodObjArgs callMethodTell, PyLongAsLongNode asLongNode) {
            Object posobj = TellNode.getPos(frame, self, inliningTarget, writeFlushNode, callMethodFlush, callMethodTell);
            PTextIO.CookieType cookie = new PTextIO.CookieType();
            cookie.startPos = asLongNode.execute((Frame)frame, inliningTarget, posobj);
            cookie.decFlags = self.getSnapshotDecFlags();
            cookie.startPos -= (long)self.getSnapshotNextInput().length;
            return cookie;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.isSeekable()", "self.isTelling()", "hasDecoderAndSnapshot(self)", "!hasUsedDecodedChar(self)"})
        static Object didntMove(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodTell, @Cached.Exclusive @Cached PyLongAsLongNode asLongNode) {
            PTextIO.CookieType cookie = TellNode.getCookie(frame, inliningTarget, self, writeFlushNode, callMethodFlush, callMethodTell, asLongNode);
            return PTextIO.CookieType.build(cookie);
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.isSeekable()", "self.isTelling()", "hasDecoderAndSnapshot(self)", "hasUsedDecodedChar(self)"})
        static Object tell(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached TextIOWrapperNodes.DecoderSetStateNode decoderSetStateNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached IONodes.ToTruffleStringNode toString, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodTell, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodDecode, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodGetState, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodSetState, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached PyLongAsLongNode asLongNode, @Cached PyObjectSizeNode sizeNode, @CachedLibrary(limit="2") InteropLibrary isString, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PTextIO.CookieType cookie = TellNode.getCookie(frame, inliningTarget, self, writeFlushNode, callMethodFlush, callMethodTell, asLongNode);
            byte[] snapshotNextInput = self.getSnapshotNextInput();
            int nextInputLength = self.getSnapshotNextInput().length;
            int decodedCharsUsed = self.getDecodedCharsUsed();
            Object savedState = callMethodGetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_GETSTATE, new Object[0]);
            int skipBytes = (int)(self.getB2cratio() * (double)decodedCharsUsed);
            int skipBack = 1;
            assert (skipBack <= nextInputLength);
            while (skipBytes > 0) {
                decoderSetStateNode.execute(frame, inliningTarget, self, cookie, factory);
                PBytes in = factory.createBytes(snapshotNextInput, skipBytes);
                int charsDecoded = TellNode.decoderDecode(frame, inliningTarget, self, in, callMethodDecode, toString, codePointLengthNode);
                if (charsDecoded <= decodedCharsUsed) {
                    Object[] state = TellNode.decoderGetstate(frame, inliningTarget, self, savedState, getObjectArrayNode, callMethodGetState, callMethodSetState, raiseNode);
                    int decFlags = asSizeNode.executeExact((Frame)frame, inliningTarget, state[1]);
                    int decBufferLen = sizeNode.execute((Frame)frame, inliningTarget, state[0]);
                    if (decBufferLen == 0) {
                        cookie.decFlags = decFlags;
                        decodedCharsUsed -= charsDecoded;
                        break;
                    }
                    skipBytes -= decBufferLen;
                    skipBack = 1;
                    continue;
                }
                skipBytes -= skipBack;
                skipBack *= 2;
            }
            if (skipBytes <= 0) {
                skipBytes = 0;
                decoderSetStateNode.execute(frame, inliningTarget, self, cookie, factory);
            }
            cookie.startPos += (long)skipBytes;
            cookie.charsToSkip = decodedCharsUsed;
            if (decodedCharsUsed == 0) {
                callMethodSetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_SETSTATE, savedState);
                cookie.charsToSkip = decodedCharsUsed;
                return PTextIO.CookieType.build(cookie);
            }
            int charsDecoded = 0;
            byte[] input = PythonUtils.arrayCopyOfRange(snapshotNextInput, skipBytes, nextInputLength);
            while (input.length > 0) {
                PBytes start = factory.createBytes(input, 1);
                int n = TellNode.decoderDecode(frame, inliningTarget, self, start, callMethodDecode, toString, codePointLengthNode);
                ++cookie.bytesToFeed;
                Object[] state = TellNode.decoderGetstate(frame, inliningTarget, self, savedState, getObjectArrayNode, callMethodGetState, callMethodSetState, raiseNode);
                int decFlags = asSizeNode.executeExact((Frame)frame, inliningTarget, state[1]);
                int decBufferLen = sizeNode.execute((Frame)frame, inliningTarget, state[0]);
                if (decBufferLen == 0 && (charsDecoded += n) <= decodedCharsUsed) {
                    cookie.startPos += (long)cookie.bytesToFeed;
                    decodedCharsUsed -= charsDecoded;
                    cookie.decFlags = decFlags;
                    cookie.bytesToFeed = 0;
                    charsDecoded = 0;
                }
                if (charsDecoded >= decodedCharsUsed) break;
                input = PythonUtils.arrayCopyOfRange(input, 1, input.length);
            }
            if (input.length == 0) {
                Object decoded = callMethodDecode.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_DECODE, StringLiterals.T_EMPTY_STRING, true);
                if (!isString.isString(decoded)) {
                    TellNode.fail(frame, inliningTarget, self, savedState, callMethodSetState);
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DECODER_SHOULD_RETURN_A_STRING_RESULT_NOT_P, decoded);
                }
                cookie.needEOF = 1;
                if ((charsDecoded += sizeNode.execute((Frame)frame, inliningTarget, decoded)) < decodedCharsUsed) {
                    TellNode.fail(frame, inliningTarget, self, savedState, callMethodSetState);
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OSError, ErrorMessages.CAN_T_RECONSTRUCT_LOGICAL_FILE_POSITION);
                }
            }
            callMethodSetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_SETSTATE, savedState);
            cookie.charsToSkip = decodedCharsUsed;
            return PTextIO.CookieType.build(cookie);
        }

        static void fail(VirtualFrame frame, Node inliningTarget, PTextIO self, Object savedState, PyObjectCallMethodObjArgs callMethodSetState) {
            callMethodSetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_SETSTATE, savedState);
        }

        static Object[] decoderGetstate(VirtualFrame frame, Node inliningTarget, PTextIO self, Object saved_state, SequenceNodes.GetObjectArrayNode getArray, PyObjectCallMethodObjArgs callMethodGetState, PyObjectCallMethodObjArgs callMethodSetState, PRaiseNode.Lazy raiseNode) {
            Object state = callMethodGetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_GETSTATE, new Object[0]);
            if (!(state instanceof PTuple)) {
                TellNode.fail(frame, inliningTarget, self, saved_state, callMethodSetState);
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE);
            }
            Object[] array = getArray.execute(inliningTarget, state);
            if (array.length < 2) {
                TellNode.fail(frame, inliningTarget, self, saved_state, callMethodSetState);
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE);
            }
            if (!(array[0] instanceof PBytes)) {
                TellNode.fail(frame, inliningTarget, self, saved_state, callMethodSetState);
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE_THE_FIRST, array[0]);
            }
            return array;
        }

        static int decoderDecode(VirtualFrame frame, Node inliningTarget, PTextIO self, PBytes start, PyObjectCallMethodObjArgs callMethodDecode, IONodes.ToTruffleStringNode toString, TruffleString.CodePointLengthNode codePointLengthNode) {
            Object decoded = callMethodDecode.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_DECODE, start);
            return codePointLengthNode.execute((AbstractTruffleString)toString.execute(inliningTarget, decoded), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "cookie", "whence"})
    @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object seek(VirtualFrame frame, PTextIO self, Object c, int whence, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile overflow, @Cached CastToJavaLongLossyNode toLong, @Cached PyNumberIndexNode indexNode, @Cached TextIOWrapperNodes.DecoderSetStateNode decoderSetStateNode, @Cached TextIOWrapperNodes.DecoderResetNode decoderResetNode, @Cached TextIOWrapperNodes.EncoderResetNode encoderResetNode, @Cached TextIOWrapperNodes.CheckClosedNode checkClosedNode, @Cached TextIOWrapperNodes.DecodeNode decodeNode, @Cached PyObjectCallMethodObjArgs callMethodTell, @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached PyObjectCallMethodObjArgs callMethodSeek, @Cached PyObjectCallMethodObjArgs callMethodRead, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PTextIO.CookieType cookie;
            checkClosedNode.execute(frame, self);
            if (!self.isSeekable()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.UNDERLYING_STREAM_IS_NOT_SEEKABLE);
            }
            Object cookieObj = c;
            switch (whence) {
                case 1: {
                    if (!eqNode.compare((Frame)frame, inliningTarget, cookieObj, 0)) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.CAN_T_DO_NONZERO_CUR_RELATIVE_SEEKS);
                    }
                    cookieObj = callMethodTell.execute((Frame)frame, inliningTarget, self, IONodes.T_TELL, new Object[0]);
                    break;
                }
                case 2: {
                    if (!eqNode.compare((Frame)frame, inliningTarget, cookieObj, 0)) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.CAN_T_DO_NONZERO_END_RELATIVE_SEEKS);
                    }
                    callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
                    self.clearDecodedChars();
                    self.clearSnapshot();
                    if (self.hasDecoder()) {
                        decoderResetNode.execute(frame, inliningTarget, self);
                    }
                    Object res = callMethodSeek.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_SEEK, 0, 2);
                    if (self.hasEncoder()) {
                        encoderResetNode.execute(frame, inliningTarget, self, eqNode.compare((Frame)frame, inliningTarget, res, 0));
                    }
                    return res;
                }
                case 0: {
                    break;
                }
                default: {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.INVALID_WHENCE_D_SHOULD_BE_D_D_OR_D, whence, 0, 1, 2);
                }
            }
            Object cookieLong = indexNode.execute((Frame)frame, inliningTarget, cookieObj);
            if (cookieLong instanceof PInt) {
                if (((PInt)cookieLong).isNegative()) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SEEK_POSITION_D, cookieLong);
                }
                cookie = PTextIO.CookieType.parse((PInt)cookieLong, inliningTarget, overflow, raiseNode);
            } else {
                long l = toLong.execute(inliningTarget, cookieLong);
                if (l < 0L) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SEEK_POSITION_D, cookieLong);
                }
                cookie = PTextIO.CookieType.parse(l, inliningTarget, overflow, raiseNode);
            }
            callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            callMethodSeek.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_SEEK, cookie.startPos);
            self.clearDecodedChars();
            self.clearSnapshot();
            decoderSetStateNode.execute(frame, inliningTarget, self, cookie, factory);
            if (cookie.charsToSkip != 0) {
                Object inputChunk = callMethodRead.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READ, cookie.bytesToFeed);
                if (!(inputChunk instanceof PBytes)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNDERLYING_READ_SHOULD_HAVE_RETURNED_A_BYTES_OBJECT_NOT_S, inputChunk);
                }
                self.setSnapshotDecFlags(cookie.decFlags);
                self.setSnapshotNextInput(bufferLib.getCopiedByteArray(inputChunk));
                TruffleString decoded = decodeNode.execute(frame, self.getDecoder(), inputChunk, cookie.needEOF != 0);
                int decodedLen = self.setDecodedChars(decoded, codePointLengthNode);
                if (decodedLen < cookie.charsToSkip) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OSError, ErrorMessages.CAN_T_RESTORE_LOGICAL_FILE_POSITION);
                }
                self.incDecodedCharsUsed(cookie.charsToSkip);
            } else {
                self.setSnapshotDecFlags(cookie.decFlags);
                self.setSnapshotNextInput(PythonUtils.EMPTY_BYTE_ARRAY);
            }
            if (self.hasEncoder()) {
                TextIOWrapperBuiltins.encoderSetState(frame, inliningTarget, self, cookie, encoderResetNode);
            }
            return cookieObj;
        }

        protected static boolean checkAttached(PTextIO self) {
            return self.isOK() && !self.isDetached();
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PTextIO self, Object o1, Object o2, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }

        @Specialization(guards={"self.isOK()", "self.isDetached()"})
        static Object attachError(PTextIO self, Object o1, Object o2, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.DETACHED_BUFFER);
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAttyNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        IsAttyNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object isatty(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_ISATTY, new Object[0]);
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class WritableNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        protected WritableNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object writable(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_WRITABLE, new Object[0]);
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object readable(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READABLE, new Object[0]);
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        SeekableNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object seekable(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_SEEKABLE, new Object[0]);
        }
    }

    @Builtin(name="fileno", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FilenoNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        FilenoNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object fileno(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_FILENO, new Object[0]);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization(guards={"checkAttached(self)"})
        static Object close(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached ClosedNode closedNode, @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached PyObjectCallMethodObjArgs callMethodDeallocWarn, @Cached PyObjectCallMethodObjArgs callMethodClose, @Cached PyObjectIsTrueNode isTrueNode, @Cached PyErrChainExceptions chainExceptions) {
            Object res = closedNode.execute(frame, self);
            if (isTrueNode.execute((Frame)frame, inliningTarget, res)) {
                return PNone.NONE;
            }
            if (self.isFinalizing()) {
                callMethodDeallocWarn.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T__DEALLOC_WARN, new Object[0]);
            }
            try {
                callMethodFlush.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            }
            catch (PException e) {
                try {
                    callMethodClose.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_CLOSE, new Object[0]);
                    throw e;
                }
                catch (PException ee) {
                    throw chainExceptions.execute(inliningTarget, ee, e);
                }
            }
            return callMethodClose.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_CLOSE, new Object[0]);
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)"})
        static Object flush(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            self.setTelling(self.isSeekable());
            writeFlushNode.execute(frame, inliningTarget, self);
            return callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_FLUSH, new Object[0]);
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)"})
        static TruffleString readline(VirtualFrame frame, PTextIO self, int limit, @Cached TextIOWrapperNodes.ReadlineNode readlineNode) {
            return readlineNode.execute(frame, self, limit);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.hasDecoder()", "n < 0"})
        static TruffleString readAll(VirtualFrame frame, PTextIO self, int n, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.DecodeNode decodeNode, @Cached.Exclusive @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.ConcatNode concatNode) {
            writeFlushNode.execute(frame, inliningTarget, self);
            Object bytes = callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READ, new Object[0]);
            TruffleString decoded = decodeNode.execute(frame, self.getDecoder(), bytes, true);
            TruffleString result = self.consumeAllDecodedChars(substringNode, !decoded.isEmpty());
            result = concatNode.execute((AbstractTruffleString)result, (AbstractTruffleString)decoded, PythonUtils.TS_ENCODING, false);
            self.clearDecodedChars();
            self.clearSnapshot();
            return result;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.hasDecoder()", "n >= 0"})
        static TruffleString read(VirtualFrame frame, PTextIO self, int n, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.ReadChunkNode readChunkNode, @Cached.Exclusive @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            boolean res;
            writeFlushNode.execute(frame, inliningTarget, self);
            TruffleString result = self.consumeDecodedChars(n, substringNode, false);
            TruffleStringBuilder chunks = null;
            for (int remaining = n - codePointLengthNode.execute((AbstractTruffleString)result, PythonUtils.TS_ENCODING); remaining > 0 && (res = readChunkNode.execute(frame, inliningTarget, self, remaining)); remaining -= codePointLengthNode.execute((AbstractTruffleString)result, PythonUtils.TS_ENCODING)) {
                if (!result.isEmpty()) {
                    if (chunks == null) {
                        chunks = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                    }
                    appendStringNode.execute(chunks, (AbstractTruffleString)result);
                }
                result = self.consumeDecodedChars(remaining, substringNode, chunks != null);
            }
            if (chunks != null) {
                appendStringNode.execute(chunks, (AbstractTruffleString)result);
                return toStringNode.execute(chunks);
            }
            return result;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "!self.hasDecoder()"})
        static Object noDecoder(VirtualFrame frame, PTextIO self, int n, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.NOT_READABLE);
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=1, parameterNames={"$self", "str"})
    @ArgumentClinic(name="str", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "!self.hasEncoder()"})
        static Object write(VirtualFrame frame, PTextIO self, TruffleString data, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.NOT_WRITABLE);
        }

        @Specialization(guards={"checkAttached(self)", "isOpen(frame, self)", "self.hasEncoder()"})
        static Object write(VirtualFrame frame, PTextIO self, TruffleString data, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.WriteFlushNode writeFlushNode, @Cached TextIOWrapperNodes.DecoderResetNode decoderResetNode, @Cached PyObjectCallMethodObjArgs callMethodEncode, @Cached PyObjectCallMethodObjArgs callMethodFlush, @Cached StringNodes.StringReplaceNode replaceNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode.Lazy raiseNode) {
            Object b;
            boolean haslf = false;
            boolean needflush = false;
            TruffleString text = data;
            if ((self.isWriteTranslate() && self.hasWriteNewline() || self.isLineBuffering()) && indexOfCodePointNode.execute((AbstractTruffleString)text, 10, 0, codePointLengthNode.execute((AbstractTruffleString)text, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0) {
                haslf = true;
            }
            if (haslf && self.isWriteTranslate() && self.hasWriteNewline()) {
                text = replaceNode.execute(text, StringLiterals.T_NEWLINE, self.getWriteNewline(), -1);
            }
            if (self.isLineBuffering() && (haslf || indexOfCodePointNode.execute((AbstractTruffleString)text, 13, 0, codePointLengthNode.execute((AbstractTruffleString)text, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0)) {
                needflush = true;
            }
            if ((b = callMethodEncode.execute((Frame)frame, inliningTarget, self.getEncoder(), IONodes.T_ENCODE, text)) != text && !(b instanceof PBytes)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ENCODER_SHOULD_RETURN_A_BYTES_OBJECT_NOT_P, b);
            }
            byte[] encodedText = bufferLib.getInternalOrCopiedByteArray(b);
            int bytesLen = bufferLib.getBufferLength(b);
            if (self.getPendingBytesCount() + bytesLen > self.getChunkSize()) {
                writeFlushNode.execute(frame, inliningTarget, self);
            }
            self.appendPendingBytes(encodedText, bytesLen);
            if (self.getPendingBytesCount() >= self.getChunkSize() || needflush || self.isWriteThrough()) {
                writeFlushNode.execute(frame, inliningTarget, self);
            }
            if (needflush) {
                callMethodFlush.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_FLUSH, new Object[0]);
            }
            self.clearDecodedChars();
            self.clearSnapshot();
            if (self.hasDecoder()) {
                decoderResetNode.execute(frame, inliningTarget, self);
            }
            return codePointLengthNode.execute((AbstractTruffleString)data, PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="reconfigure", minNumOfPositionalArgs=1, keywordOnlyNames={"encoding", "errors", "newline", "line_buffering", "write_through"})
    @GenerateNodeFactory
    static abstract class ReconfigureNode
    extends PythonBuiltinNode {
        ReconfigureNode() {
        }

        protected static boolean isValid(PTextIO self, Object encodingObj, Object errorsObj, Object newlineObj) {
            if (self.hasDecodedChars()) {
                return PGuards.isPNone(encodingObj) && PGuards.isPNone(errorsObj) && PGuards.isNoValue(newlineObj);
            }
            return true;
        }

        @Specialization(guards={"isValid(self, encodingObj, errorsObj, newlineObj)"})
        static Object reconfigure(VirtualFrame frame, PTextIO self, Object encodingObj, Object errorsObj, Object newlineObj, Object lineBufferingObj, Object writeThroughObj, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy lazyRaiseNode, @Cached IONodes.ToTruffleStringNode toStringNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectIsTrueNode isTrueNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.EqualNode equalNode, @Cached TextIOWrapperNodes.ChangeEncodingNode changeEncodingNode) {
            TruffleString newline = null;
            if (!PGuards.isPNone(newlineObj)) {
                newline = toStringNode.execute(inliningTarget, newlineObj);
                TextIOWrapperNodes.validateNewline(newline, inliningTarget, lazyRaiseNode, codePointLengthNode, codePointAtIndexNode);
            }
            boolean lineBuffering = PGuards.isPNone(lineBufferingObj) ? self.isLineBuffering() : isTrueNode.execute((Frame)frame, inliningTarget, lineBufferingObj);
            boolean writeThrough = PGuards.isPNone(writeThroughObj) ? self.isWriteThrough() : isTrueNode.execute((Frame)frame, inliningTarget, writeThroughObj);
            callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            self.setB2cratio(0.0);
            if (!PGuards.isNoValue(newlineObj)) {
                TextIOWrapperNodes.setNewline(self, newline, equalNode);
            }
            changeEncodingNode.execute(frame, inliningTarget, self, encodingObj, errorsObj, !PGuards.isNoValue(newlineObj));
            self.setLineBuffering(lineBuffering);
            self.setWriteThrough(writeThrough);
            return PNone.NONE;
        }

        @Specialization(guards={"!isValid(self, encodingObj, errorsObj, newlineObj)"})
        static Object error(VirtualFrame frame, PTextIO self, Object encodingObj, Object errorsObj, Object newlineObj, Object lineBufferingObj, Object writeThroughObj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.NOT_POSSIBLE_TO_SET_THE_ENCODING_OR);
        }
    }

    @Builtin(name="detach", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DetachNode
    extends PythonUnaryBuiltinNode {
        DetachNode() {
        }

        @Specialization
        static Object detach(VirtualFrame frame, PTextIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            callMethod.execute((Frame)frame, inliningTarget, self, IONodes.T_FLUSH, new Object[0]);
            Object buffer = self.getBuffer();
            self.setBuffer(null);
            self.setDetached(true);
            return buffer;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, parameterNames={"$self", "buffer", "encoding", "errors", "newline", "line_buffering", "write_through"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true), @ArgumentClinic(name="newline", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="line_buffering", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true), @ArgumentClinic(name="write_through", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TextIOWrapperBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object init(VirtualFrame frame, PTextIO self, Object buffer, Object encodingArg, TruffleString errors, Object newlineArg, boolean lineBuffering, boolean writeThrough, @Cached TextIOWrapperNodes.TextIOWrapperInitNode initNode) {
            initNode.execute((Frame)frame, this, self, buffer, encodingArg, errors, newlineArg, lineBuffering, writeThrough);
            return PNone.NONE;
        }
    }

    static abstract class ClosedCheckPythonBinaryClinicBuiltinNode
    extends AttachedCheckPythonBinaryClinicBuiltinNode {
        @Node.Child
        private TextIOWrapperNodes.CheckClosedNode checkClosedNode = TextIOWrapperNodesFactory.CheckClosedNodeGen.create();

        ClosedCheckPythonBinaryClinicBuiltinNode() {
        }

        protected boolean isOpen(VirtualFrame frame, PTextIO self) {
            this.checkClosedNode.execute(frame, self);
            return true;
        }
    }

    static abstract class AttachedCheckPythonBinaryClinicBuiltinNode
    extends InitCheckPythonBinaryClinicBuiltinNode {
        AttachedCheckPythonBinaryClinicBuiltinNode() {
        }

        protected static boolean checkAttached(PTextIO self) {
            return self.isOK() && !self.isDetached();
        }

        @Specialization(guards={"self.isOK()", "self.isDetached()"})
        static Object attachError(PTextIO self, Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.DETACHED_BUFFER);
        }
    }

    static abstract class InitCheckPythonBinaryClinicBuiltinNode
    extends PythonBinaryClinicBuiltinNode {
        InitCheckPythonBinaryClinicBuiltinNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract TextIOWrapper init checks");
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PTextIO self, Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class ClosedCheckPythonUnaryBuiltinNode
    extends AttachedCheckPythonUnaryBuiltinNode {
        @Node.Child
        private TextIOWrapperNodes.CheckClosedNode checkClosedNode = TextIOWrapperNodesFactory.CheckClosedNodeGen.create();

        ClosedCheckPythonUnaryBuiltinNode() {
        }

        protected boolean isOpen(VirtualFrame frame, PTextIO self) {
            this.checkClosedNode.execute(frame, self);
            return true;
        }
    }

    static abstract class AttachedCheckPythonUnaryBuiltinNode
    extends InitCheckPythonUnaryBuiltinNode {
        AttachedCheckPythonUnaryBuiltinNode() {
        }

        protected static boolean checkAttached(PTextIO self) {
            return self.isOK() && !self.isDetached();
        }

        @Specialization(guards={"self.isOK()", "self.isDetached()"})
        static Object attachError(PTextIO self, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.DETACHED_BUFFER);
        }
    }

    static abstract class InitCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        InitCheckPythonUnaryBuiltinNode() {
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PTextIO self, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }
}

