/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PPairwise;
import com.oracle.graal.python.builtins.objects.itertools.PairwiseBuiltinsFactory;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PPairwise})
public final class PairwiseBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PairwiseBuiltinsFactory.getFactories();
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getIterable() != null"})
        static Object next(VirtualFrame frame, PPairwise self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, @Cached PythonObjectFactory factory) {
            Object item;
            Object old = self.getOld();
            if (self.getOld() == null) {
                old = nextNode.execute(frame, self.getIterable(), PNone.NO_VALUE);
                self.setOld(old);
            }
            try {
                item = nextNode.execute(frame, self.getIterable(), PNone.NO_VALUE);
                self.setOld(item);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, isStopIterationProfile);
                self.setIterable(null);
                self.setOld(null);
                throw e;
            }
            return factory.createTuple(new Object[]{old, item});
        }

        @Specialization(guards={"self.getIterable() == null"})
        static Object next(PPairwise self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PPairwise self) {
            return self;
        }
    }
}

