/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.DeleteDictNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
public abstract class DeleteDictNode
extends PNodeWithContext {
    public abstract void execute(PythonObject var1);

    @Specialization
    static void doPythonObject(PythonObject object, @Bind(value="this") Node inliningTarget, @Cached HiddenAttr.ReadNode readHiddenAttrNode, @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory) {
        HashingStorage storage;
        assert (!PGuards.isPythonClass(object));
        PDict oldDict = (PDict)readHiddenAttrNode.execute(inliningTarget, object, HiddenAttr.DICT, null);
        if (oldDict != null && (storage = oldDict.getDictStorage()) instanceof DynamicObjectStorage && ((DynamicObjectStorage)storage).getStore() == object) {
            oldDict.setDictStorage(copyNode.execute(inliningTarget, storage));
        }
        PDict newDict = factory.createDict();
        object.setDict(inliningTarget, writeHiddenAttrNode, newDict);
    }

    @NeverDefault
    public static DeleteDictNode create() {
        return DeleteDictNodeGen.create();
    }

    public static DeleteDictNode getUncached() {
        return DeleteDictNodeGen.getUncached();
    }
}

