/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.object.GetForeignObjectClassNodeGen;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;

@GenerateCached
@GenerateUncached
@GenerateInline(value=false)
public abstract class GetForeignObjectClassNode
extends PNodeWithContext {
    public static GetForeignObjectClassNode getUncached() {
        return GetForeignObjectClassNodeGen.getUncached();
    }

    public abstract PythonManagedClass execute(Object var1);

    @Specialization(guards={"isSingleContext()", "traits == cachedTraits"}, limit="getCallSiteInlineCacheMaxDepth()")
    PythonManagedClass cached(Object object, @CachedLibrary(value="object") InteropLibrary interop, @Bind(value="getTraits(object, interop)") int traits, @Cached(value="traits") int cachedTraits) {
        assert (IsForeignObjectNode.executeUncached(object));
        return this.classForTraits(cachedTraits);
    }

    @Specialization(replaces={"cached"}, limit="getCallSiteInlineCacheMaxDepth()")
    PythonManagedClass uncached(Object object, @CachedLibrary(value="object") InteropLibrary interop) {
        assert (IsForeignObjectNode.executeUncached(object));
        return this.classForTraits(GetForeignObjectClassNode.getTraits(object, interop));
    }

    protected static int getTraits(Object object, InteropLibrary interop) {
        return (interop.hasArrayElements(object) ? Trait.ARRAY.bit : 0) + (interop.isBoolean(object) ? Trait.BOOLEAN.bit : 0) + (interop.isException(object) ? Trait.EXCEPTION.bit : 0) + (interop.isExecutable(object) ? Trait.EXECUTABLE.bit : 0) + (interop.hasHashEntries(object) ? Trait.HASH.bit : 0) + (interop.isInstantiable(object) ? Trait.INSTANTIABLE.bit : 0) + (interop.hasIterator(object) ? Trait.ITERABLE.bit : 0) + (interop.isIterator(object) ? Trait.ITERATOR.bit : 0) + (interop.isMetaObject(object) ? Trait.META_OBJECT.bit : 0) + (interop.isNull(object) ? Trait.NULL.bit : 0) + (interop.isNumber(object) ? Trait.NUMBER.bit : 0) + (interop.isString(object) ? Trait.STRING.bit : 0);
    }

    private PythonManagedClass classForTraits(int traits) {
        PythonManagedClass pythonClass = this.getContext().polyglotForeignClasses[traits];
        if (pythonClass == null) {
            if (GetForeignObjectClassNode.isSingleContext(this)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            pythonClass = this.resolvePolyglotForeignClassAndSetInCache(traits);
        }
        return pythonClass;
    }

    @CompilerDirectives.TruffleBoundary
    private PythonManagedClass resolvePolyglotForeignClassAndSetInCache(int traits) {
        PythonManagedClass pythonClass;
        this.getContext().polyglotForeignClasses[traits] = pythonClass = this.resolvePolyglotForeignClass(traits);
        return pythonClass;
    }

    @CompilerDirectives.TruffleBoundary
    private PythonManagedClass resolvePolyglotForeignClass(int traits) {
        PythonBuiltinClass pbc;
        Object e;
        PythonBuiltinClass base = this.getContext().lookupType(PythonBuiltinClassType.ForeignObject);
        if (traits == 0) {
            return base;
        }
        if ((Trait.ARRAY.isSet(traits) || Trait.HASH.isSet(traits)) && Trait.ITERABLE.isSet(traits)) {
            return this.classForTraits(traits - Trait.ITERABLE.bit);
        }
        boolean singleTrait = Integer.bitCount(traits) == 1;
        ArrayList<PythonManagedClass> traitsList = new ArrayList<PythonManagedClass>();
        StringBuilder nameBuilder = new StringBuilder("Foreign");
        for (Trait trait : Trait.VALUES) {
            if (!trait.isSet(traits)) continue;
            assert (trait != Trait.ITERABLE || !Trait.ARRAY.isSet(traits));
            if (singleTrait) {
                if (trait.type != null) {
                    traitsList.add(this.getContext().lookupType(trait.type));
                }
            } else {
                traitsList.add(this.classForTraits(trait.bit));
            }
            if (trait == Trait.META_OBJECT) {
                if (Trait.INSTANTIABLE.isSet(traits)) {
                    nameBuilder.append("Class");
                    continue;
                }
                nameBuilder.append("AbstractClass");
                continue;
            }
            if (trait == Trait.INSTANTIABLE && Trait.META_OBJECT.isSet(traits)) continue;
            nameBuilder.append(trait.name);
        }
        TruffleString name = PythonUtils.toTruffleStringUncached(nameBuilder.toString());
        if (singleTrait && traitsList.size() == 1 && (e = traitsList.get(0)) instanceof PythonBuiltinClass && (pbc = (PythonBuiltinClass)e).getType().getName().equals((Object)name)) {
            return pbc;
        }
        traitsList.add(base);
        PythonAbstractClass[] bases = traitsList.toArray(PythonAbstractClass.EMPTY_ARRAY);
        PythonModule polyglotModule = this.getContext().lookupBuiltinModule(BuiltinNames.T_POLYGLOT);
        PythonClass pythonClass = this.getContext().factory().createPythonClassAndFixupSlots(this.getLanguage(), (Object)PythonBuiltinClassType.PythonClass, name, base, bases);
        pythonClass.setAttribute(SpecialAttributeNames.T___MODULE__, BuiltinNames.T_POLYGLOT);
        assert (polyglotModule.getAttribute(name) == PNone.NO_VALUE) : name;
        polyglotModule.setAttribute(name, pythonClass);
        return pythonClass;
    }

    public void defineSingleTraitClasses() {
        PythonModule polyglotModule = this.getContext().lookupBuiltinModule(BuiltinNames.T_POLYGLOT);
        for (Trait trait : Trait.VALUES) {
            PythonManagedClass traitClass = this.classForTraits(trait.bit);
            assert (polyglotModule.getAttribute(traitClass.getName()) == traitClass) : traitClass.getName();
        }
    }

    public static enum Trait {
        NULL("None", PythonBuiltinClassType.PNone),
        BOOLEAN("Boolean", PythonBuiltinClassType.ForeignBoolean),
        NUMBER("Number", PythonBuiltinClassType.ForeignNumber),
        STRING("String", PythonBuiltinClassType.PString),
        EXCEPTION("Exception", PythonBuiltinClassType.PBaseException),
        META_OBJECT("AbstractClass", PythonBuiltinClassType.ForeignAbstractClass),
        EXECUTABLE("Executable", PythonBuiltinClassType.ForeignExecutable),
        INSTANTIABLE("Instantiable", PythonBuiltinClassType.ForeignInstantiable),
        HASH("Dict", PythonBuiltinClassType.PDict),
        ARRAY("List", PythonBuiltinClassType.PList),
        ITERATOR("Iterator", PythonBuiltinClassType.PIterator),
        ITERABLE("Iterable", PythonBuiltinClassType.ForeignIterable);

        public static final Trait[] VALUES;
        public static final int COMBINATIONS;
        final String name;
        final int bit;
        final PythonBuiltinClassType type;

        private Trait(String name, PythonBuiltinClassType type) {
            this.name = name;
            this.bit = 1 << this.ordinal();
            this.type = type;
        }

        boolean isSet(int traits) {
            return (traits & this.bit) != 0;
        }

        static {
            VALUES = Trait.values();
            COMBINATIONS = 1 << VALUES.length;
        }
    }
}

