/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.tokenizer;

import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public class Tokenizer {
    private static final int EOF = -1;
    private static final int ALTTABSIZE = 1;
    private static final int MAXINDENT = 100;
    private static final int MAXLEVEL = 200;
    private static final int UTF8_BOM = 65279;
    private static final int TABSIZE = 8;
    private static final byte[] TYPE_COMMENT_PREFIX = "# type: ".getBytes(StandardCharsets.US_ASCII);
    private static final int[] IGNORE_BYTES = Tokenizer.charsToCodePoints("ignore".toCharArray());
    private final ErrorCallback errorCallback;
    private final boolean execInput;
    private final int[] codePointsInput;
    private int nextCharIndex = 0;
    private final boolean interactive;
    private int tokenStart = 0;
    private StatusCode done = StatusCode.OK;
    private final int tabSize = 8;
    private int currentIndentIndex = 0;
    private final int[] indentationStack = new int[100];
    private boolean atBeginningOfLine = true;
    private int pendingIndents = 0;
    private int currentLineNumber = 1;
    private int firstLineNumber = 0;
    private int parensNestingLevel = 0;
    private final int[] parensStack = new int[200];
    private final int[] parensLineNumberStack = new int[200];
    private final int[] parensColumnsStack = new int[200];
    private final int[] altIndentationStack = new int[100];
    private boolean inContinuationLine = false;
    private int lineStartIndex = 0;
    private int multiLineStartIndex = 0;
    private final boolean lookForTypeComments;
    private final boolean asyncHacks;
    private boolean insideAsyncDef = false;
    private int indentationOfAsyncDef = 0;
    private boolean asyncDefFollowedByNewline = false;
    private boolean readNewline = false;
    public boolean reportIncompleteSourceIfInteractive = true;
    private final int srcStartLine;
    private final int srcStartColumn;
    private static final byte[] CODINGS_BYTES = new byte[]{99, 111, 100, 105, 110, 103};
    private static final byte[] BOM_BYTES = new byte[]{-17, -69, -65};
    private static final int LABEL_NEXTLINE = 0;
    private static final int LABEL_AGAIN = 1;
    private static final int LABEL_LETTER_QUOTE = 2;
    private static final int LABEL_FRACTION = 3;
    private static final int LABEL_EXPONENT = 4;
    private static final int LABEL_IMAGINARY = 5;

    private static boolean isPotentialIdentifierStart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c >= 128;
    }

    private static boolean isPotentialIdentifierChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c >= 128;
    }

    private Tokenizer(ErrorCallback errorCallback, int[] codePointsInput, EnumSet<Flag> flags, SourceRange inputSourceRange) {
        this.errorCallback = errorCallback;
        this.codePointsInput = codePointsInput;
        this.execInput = flags.contains((Object)Flag.EXEC_INPUT);
        this.interactive = flags.contains((Object)Flag.INTERACTIVE);
        this.lookForTypeComments = flags.contains((Object)Flag.TYPE_COMMENT);
        this.asyncHacks = flags.contains((Object)Flag.ASYNC_HACKS);
        if (inputSourceRange != null) {
            this.srcStartLine = inputSourceRange.startLine - 1;
            this.srcStartColumn = inputSourceRange.startColumn - 1;
        } else {
            this.srcStartLine = 0;
            this.srcStartColumn = 0;
        }
    }

    private Tokenizer(Tokenizer t) {
        this.errorCallback = t.errorCallback;
        this.execInput = t.execInput;
        this.codePointsInput = t.codePointsInput;
        this.nextCharIndex = t.nextCharIndex;
        this.interactive = t.interactive;
        this.tokenStart = t.tokenStart;
        this.done = t.done;
        this.currentIndentIndex = t.currentIndentIndex;
        System.arraycopy(t.indentationStack, 0, this.indentationStack, 0, this.indentationStack.length);
        this.atBeginningOfLine = t.atBeginningOfLine;
        this.pendingIndents = t.pendingIndents;
        this.currentLineNumber = t.currentLineNumber;
        this.firstLineNumber = t.firstLineNumber;
        this.parensNestingLevel = t.parensNestingLevel;
        System.arraycopy(t.parensStack, 0, this.parensStack, 0, this.parensStack.length);
        System.arraycopy(t.parensLineNumberStack, 0, this.parensLineNumberStack, 0, this.parensLineNumberStack.length);
        System.arraycopy(t.parensColumnsStack, 0, this.parensColumnsStack, 0, this.parensColumnsStack.length);
        System.arraycopy(t.altIndentationStack, 0, this.altIndentationStack, 0, this.altIndentationStack.length);
        this.inContinuationLine = t.inContinuationLine;
        this.lineStartIndex = t.lineStartIndex;
        this.multiLineStartIndex = t.multiLineStartIndex;
        this.lookForTypeComments = t.lookForTypeComments;
        this.asyncHacks = t.asyncHacks;
        this.insideAsyncDef = t.insideAsyncDef;
        this.indentationOfAsyncDef = t.indentationOfAsyncDef;
        this.asyncDefFollowedByNewline = t.asyncDefFollowedByNewline;
        this.readNewline = t.readNewline;
        this.reportIncompleteSourceIfInteractive = t.reportIncompleteSourceIfInteractive;
        this.srcStartLine = t.srcStartLine;
        this.srcStartColumn = t.srcStartColumn;
    }

    private static String getNormalName(String s) {
        if (s.startsWith("utf-8")) {
            return "utf-8";
        }
        if (s.startsWith("latin-1") || s.startsWith("iso-8859-1") || s.startsWith("iso-latin-1")) {
            return "iso-8859-1";
        }
        return s;
    }

    private static String getCodingSpec(byte[] byteInput, int lineStart) {
        byte cp;
        int i;
        for (i = lineStart; i < byteInput.length - 6; ++i) {
            cp = byteInput[i];
            if (cp == 10) {
                return null;
            }
            if (cp == 35) break;
            if (cp == 32 || cp == 9 || cp == 12) continue;
            return null;
        }
        while (i < byteInput.length - 6) {
            cp = byteInput[i];
            if (cp == 10) {
                return null;
            }
            if (Arrays.equals(byteInput, i, i + 6, CODINGS_BYTES, 0, 6)) {
                int t = i + 6;
                cp = byteInput[t];
                if (cp == 10) {
                    return null;
                }
                if (cp == 58 || cp == 61) {
                    while ((cp = byteInput[++t]) == 32 || cp == 9) {
                    }
                    int begin = t;
                    while (Character.isLetterOrDigit(cp) || cp == 45 || cp == 95 || cp == 46) {
                        cp = byteInput[++t];
                    }
                    if (begin < t) {
                        String r = new String(Arrays.copyOfRange(byteInput, begin, t), StandardCharsets.UTF_8);
                        return Tokenizer.getNormalName(r);
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Charset checkCodingSpec(byte[] byteInput, int lineStart) {
        String spec = Tokenizer.getCodingSpec(byteInput, lineStart);
        if (spec == null) {
            byte cp;
            for (int i = lineStart; i < byteInput.length && (cp = byteInput[i]) != 35 && cp != 10 && cp != 13; ++i) {
                if (cp == 32 || cp == 9 || cp == 12) continue;
                return StandardCharsets.UTF_8;
            }
            return null;
        }
        return Charset.forName(spec);
    }

    private static boolean checkBOM(byte[] byteInput) {
        return byteInput.length >= 3 && Arrays.equals(byteInput, 0, 3, BOM_BYTES, 0, 3);
    }

    private static int getSourceStart(byte[] byteInput) {
        return Tokenizer.checkBOM(byteInput) ? 3 : 0;
    }

    private static Charset detectEncoding(int sourceStart, byte[] code) {
        int offset = sourceStart;
        Charset fileEncoding = Tokenizer.checkCodingSpec(code, offset);
        if (fileEncoding == null) {
            while (offset < code.length && code[offset] != 10) {
                ++offset;
            }
            if (++offset < code.length) {
                fileEncoding = Tokenizer.checkCodingSpec(code, offset);
            }
        }
        if (fileEncoding == null) {
            fileEncoding = StandardCharsets.UTF_8;
        }
        return fileEncoding;
    }

    public static Tokenizer fromBytes(ErrorCallback errorCallback, byte[] code, EnumSet<Flag> flags) {
        int sourceStart = Tokenizer.getSourceStart(code);
        Charset fileEncoding = Tokenizer.detectEncoding(sourceStart, code);
        int[] codePointsInput = Tokenizer.charsToCodePoints(fileEncoding.decode(ByteBuffer.wrap(code, sourceStart, code.length)).array());
        return new Tokenizer(errorCallback, codePointsInput, flags, null);
    }

    private static int[] charsToCodePoints(char[] chars) {
        int charIndex;
        int cpIndex = 0;
        boolean hasUTF8Bom = chars.length > 0 && Character.codePointAt(chars, 0) == 65279;
        int charIndex2 = 0;
        while (charIndex2 < chars.length) {
            int cp = Character.codePointAt(chars, charIndex2);
            charIndex2 += Character.charCount(cp);
            ++cpIndex;
        }
        if (hasUTF8Bom) {
            --cpIndex;
        }
        int[] codePoints = new int[cpIndex];
        cpIndex = 0;
        int n = charIndex = hasUTF8Bom ? Character.charCount(65279) : 0;
        while (charIndex < chars.length) {
            int cp;
            codePoints[cpIndex] = cp = Character.codePointAt(chars, charIndex);
            charIndex += Character.charCount(cp);
            ++cpIndex;
        }
        return codePoints;
    }

    public static Tokenizer fromString(ErrorCallback errorCallback, String code, EnumSet<Flag> flags, SourceRange inputSourceRange) {
        return new Tokenizer(errorCallback, Tokenizer.charsToCodePoints(code.toCharArray()), flags, inputSourceRange);
    }

    int nextChar() {
        if (this.readNewline) {
            this.readNewline = false;
            if (this.nextCharIndex < this.codePointsInput.length) {
                ++this.currentLineNumber;
            }
            this.lineStartIndex = this.nextCharIndex;
        }
        if (this.nextCharIndex < this.codePointsInput.length) {
            int c = this.codePointsInput[this.nextCharIndex];
            if (c == 13) {
                if (this.nextCharIndex + 1 < this.codePointsInput.length && this.codePointsInput[this.nextCharIndex + 1] == 10) {
                    ++this.nextCharIndex;
                }
                c = 10;
            }
            ++this.nextCharIndex;
            if (c == 10) {
                this.readNewline = true;
            }
            return c;
        }
        if (this.nextCharIndex == this.codePointsInput.length && this.execInput && (this.codePointsInput.length == 0 || this.codePointsInput[this.nextCharIndex - 1] != 10)) {
            ++this.nextCharIndex;
            this.readNewline = true;
            return 10;
        }
        if (this.interactive) {
            if (this.reportIncompleteSourceIfInteractive) {
                this.errorCallback.reportIncompleteSource(this.currentLineNumber);
            } else {
                this.done = StatusCode.INTERACTIVE_STOP;
            }
            return -1;
        }
        this.done = StatusCode.EOF;
        return -1;
    }

    void oneBack() {
        if (this.nextCharIndex > 0 && this.done != StatusCode.EOF) {
            --this.nextCharIndex;
            if (this.nextCharIndex < this.codePointsInput.length && this.codePointsInput[this.nextCharIndex] == 10 && this.nextCharIndex > 0 && this.codePointsInput[this.nextCharIndex - 1] == 13) {
                --this.nextCharIndex;
            }
            this.readNewline = false;
        }
    }

    Token syntaxError(int colOffset, int endColOffset, String message) {
        this.done = StatusCode.SYNTAX_ERROR;
        return this.createToken(60, message);
    }

    Token syntaxError(String message) {
        return this.syntaxError(-1, -1, message);
    }

    Token indentError() {
        this.done = StatusCode.TABS_SPACES_INCONSISTENT;
        return this.createToken(60);
    }

    private void parserWarn(String warning) {
        this.errorCallback.onWarning(ErrorCallback.WarningType.Syntax, this.getCurrentTokenRange(false), warning);
    }

    private boolean lookahead(int ... test) {
        int end = this.nextCharIndex + test.length;
        if (end + 1 < this.codePointsInput.length) {
            return Arrays.equals(this.codePointsInput, this.nextCharIndex, end, test, 0, test.length) && !Tokenizer.isPotentialIdentifierChar(this.codePointsInput[end]);
        }
        return false;
    }

    private Token verifyEndOfNumber(int c, String kind) {
        boolean r = false;
        if (c == 97) {
            r = this.lookahead(110, 100);
        } else if (c == 101) {
            r = this.lookahead(108, 115, 101);
        } else if (c == 102) {
            r = this.lookahead(111, 114);
        } else if (c == 105) {
            int c2 = this.nextChar();
            if (c2 == 102 || c2 == 110 || c2 == 115) {
                r = true;
            }
            this.oneBack();
        } else if (c == 111) {
            r = this.lookahead(114);
        } else if (c == 110) {
            r = this.lookahead(111, 116);
        }
        if (r) {
            this.oneBack();
            this.parserWarn(String.format("invalid %s literal", kind));
            this.nextChar();
        } else if (c < 128 && Tokenizer.isPotentialIdentifierChar(c)) {
            this.oneBack();
            return this.syntaxError(String.format("invalid %s literal", kind));
        }
        return null;
    }

    private static String verifyIdentifier(String tokenString) {
        int len;
        int invalid = len = tokenString.codePointCount(0, tokenString.length());
        int cp = tokenString.codePointAt(0);
        if (cp != 95 && !UCharacter.hasBinaryProperty((int)cp, (int)33)) {
            invalid = 0;
        }
        for (int i = 1; i < invalid; i += Character.charCount(cp)) {
            cp = tokenString.codePointAt(i);
            if (UCharacter.hasBinaryProperty((int)cp, (int)32)) continue;
            invalid = i;
            break;
        }
        if (invalid < len) {
            int codePoint = tokenString.codePointAt(invalid);
            String printString = new String(new int[]{codePoint}, 0, 1);
            return String.format("invalid character '%s' (U+%04X)", printString, codePoint);
        }
        return null;
    }

    private int readDecimalTail() {
        int c;
        block2: {
            while (true) {
                if (Character.isDigit(c = this.nextChar())) {
                    continue;
                }
                if (c != 95) break block2;
                c = this.nextChar();
                if (!Character.isDigit(c)) break;
            }
            this.oneBack();
            return 0;
        }
        return c;
    }

    private int continuationLine() {
        int c = this.nextChar();
        if (c != 10) {
            this.done = StatusCode.LINE_CONTINUATION_ERROR;
            return -1;
        }
        c = this.nextChar();
        if (c == -1) {
            this.done = StatusCode.EOF;
            return -1;
        }
        this.oneBack();
        return c;
    }

    /*
     * Unable to fully structure code
     */
    public Token next() {
        c = 0;
        blankline = false;
        nonascii = false;
        target = 0;
        block18: while (true) {
            switch (target) {
                case 0: {
                    blankline = false;
                    if (this.atBeginningOfLine) {
                        col = 0;
                        altcol = 0;
                        this.atBeginningOfLine = false;
                        contLineCol = 0;
                        block19: while (true) {
                            c = this.nextChar();
                            switch (c) {
                                case 32: {
                                    ++col;
                                    ++altcol;
                                    continue block19;
                                }
                                case 9: {
                                    col = (col / 8 + 1) * 8;
                                    altcol = (altcol / 1 + 1) * 1;
                                    continue block19;
                                }
                                case 12: {
                                    altcol = 0;
                                    col = 0;
                                    continue block19;
                                }
                                case 92: {
                                    v0 = contLineCol = contLineCol != 0 ? contLineCol : col;
                                    c = this.continuationLine();
                                    if (c == -1) ** break;
                                    continue block19;
                                    return this.createToken(60);
                                }
                            }
                            break;
                        }
                        this.oneBack();
                        if (c == 35 || c == 10) {
                            if (col == 0 && c == 10 && this.interactive) {
                                blankline = false;
                            } else if (this.interactive && this.currentLineNumber == 1) {
                                blankline = false;
                                altcol = 0;
                                col = 0;
                            } else {
                                blankline = true;
                            }
                        }
                        if (!blankline && this.parensNestingLevel == 0) {
                            col = contLineCol != 0 ? contLineCol : col;
                            v1 = altcol = contLineCol != 0 ? contLineCol : altcol;
                            if (col == this.indentationStack[this.currentIndentIndex]) {
                                if (altcol != this.altIndentationStack[this.currentIndentIndex]) {
                                    return this.indentError();
                                }
                            } else if (col > this.indentationStack[this.currentIndentIndex]) {
                                if (this.currentIndentIndex + 1 >= 100) {
                                    this.done = StatusCode.TOO_DEEP_INDENTATION;
                                    return this.createToken(60);
                                }
                                if (altcol <= this.altIndentationStack[this.currentIndentIndex]) {
                                    return this.indentError();
                                }
                                ++this.pendingIndents;
                                this.indentationStack[++this.currentIndentIndex] = col;
                                this.altIndentationStack[this.currentIndentIndex] = altcol;
                            } else {
                                if (!Tokenizer.$assertionsDisabled && col >= this.indentationStack[this.currentIndentIndex]) {
                                    throw new AssertionError();
                                }
                                while (this.currentIndentIndex > 0 && col < this.indentationStack[this.currentIndentIndex]) {
                                    --this.pendingIndents;
                                    --this.currentIndentIndex;
                                }
                                if (col != this.indentationStack[this.currentIndentIndex]) {
                                    this.done = StatusCode.DEDENT_INVALID;
                                    return this.createToken(60);
                                }
                                if (altcol != this.altIndentationStack[this.currentIndentIndex]) {
                                    return this.indentError();
                                }
                            }
                        }
                    }
                    this.tokenStart = this.nextCharIndex;
                    if (this.pendingIndents != 0) {
                        if (this.pendingIndents < 0) {
                            ++this.pendingIndents;
                            return this.createToken(6);
                        }
                        --this.pendingIndents;
                        return this.createToken(5);
                    }
                    c = this.nextChar();
                    this.oneBack();
                    if (this.insideAsyncDef && !blankline && c != 10 && this.parensNestingLevel == 0 && this.asyncDefFollowedByNewline && this.indentationOfAsyncDef >= this.currentIndentIndex) {
                        this.insideAsyncDef = false;
                        this.indentationOfAsyncDef = 0;
                        this.asyncDefFollowedByNewline = false;
                    }
                }
                case 1: {
                    while ((c = this.nextChar()) == 32 || c == 9 || c == 12) {
                    }
                    this.tokenStart = this.nextCharIndex - 1;
                    if (c == 35) {
                        while ((c = this.nextChar()) != -1 && c != 10) {
                        }
                        if (this.lookForTypeComments) {
                            chIdx = this.tokenStart;
                            for (prefixIdx = 0; chIdx < this.codePointsInput.length && prefixIdx < Tokenizer.TYPE_COMMENT_PREFIX.length; ++prefixIdx) {
                                if (Tokenizer.TYPE_COMMENT_PREFIX[prefixIdx] == 32) {
                                    while (chIdx < this.codePointsInput.length && (this.codePointsInput[chIdx] == 32 || this.codePointsInput[chIdx] == 9)) {
                                        ++chIdx;
                                    }
                                    continue;
                                }
                                if (Tokenizer.TYPE_COMMENT_PREFIX[prefixIdx] != this.codePointsInput[chIdx]) break;
                                ++chIdx;
                            }
                            if (prefixIdx == Tokenizer.TYPE_COMMENT_PREFIX.length) {
                                ignoreEnd = chIdx + 6;
                                endChar = ignoreEnd < this.codePointsInput.length ? this.codePointsInput[ignoreEnd] : -1;
                                this.oneBack();
                                typeStart = chIdx;
                                v2 = isTypeIgnore = this.nextCharIndex >= ignoreEnd && Arrays.equals(this.codePointsInput, chIdx, ignoreEnd, Tokenizer.IGNORE_BYTES, 0, 6) != false && (this.nextCharIndex <= ignoreEnd || endChar < 128 && Character.isLetterOrDigit(endChar) == false);
                                if (isTypeIgnore) {
                                    if (blankline) {
                                        this.nextChar();
                                        this.atBeginningOfLine = true;
                                    }
                                    this.tokenStart = ignoreEnd;
                                    return this.createToken(57);
                                }
                                this.tokenStart = typeStart;
                                return this.createToken(58);
                            }
                        }
                    }
                    if (this.done == StatusCode.INTERACTIVE_STOP) {
                        return this.createToken(0);
                    }
                    if (c == -1) {
                        this.tokenStart = this.nextCharIndex;
                        if (this.parensNestingLevel > 0) {
                            return this.createToken(60);
                        }
                        if (this.done == StatusCode.EOF) {
                            return this.createToken(0);
                        }
                        return this.createToken(60);
                    }
                    nonascii = false;
                    if (!Tokenizer.isPotentialIdentifierStart(c)) ** GOTO lbl173
                    sawb = false;
                    sawr = false;
                    sawu = false;
                    sawf = false;
                    do {
                        if (!(sawb || sawu || sawf || c != 98 && c != 66)) {
                            sawb = true;
                            continue;
                        }
                        if (!(sawb || sawu || sawr || sawf || c != 117 && c != 85)) {
                            sawu = true;
                            continue;
                        }
                        if (!(sawr || sawu || c != 114 && c != 82)) {
                            sawr = true;
                            continue;
                        }
                        if (sawf || sawb || sawu || c != 102 && c != 70) ** GOTO lbl150
                        sawf = true;
                    } while ((c = this.nextChar()) != 34 && c != 39);
                    target = 2;
                    continue block18;
lbl150:
                    // 2 sources

                    while (Tokenizer.isPotentialIdentifierChar(c)) {
                        if (c >= 128) {
                            nonascii = true;
                        }
                        c = this.nextChar();
                    }
                    this.oneBack();
                    tokenString = new String(this.codePointsInput, this.tokenStart, this.nextCharIndex - this.tokenStart);
                    if (nonascii && (errMsg = Tokenizer.verifyIdentifier(tokenString)) != null) {
                        this.done = StatusCode.SYNTAX_ERROR;
                        return this.createToken(60, errMsg);
                    }
                    if (!this.asyncHacks || this.insideAsyncDef) {
                        if (tokenString.equals("async")) {
                            return this.createToken(56);
                        }
                        if (tokenString.equals("await")) {
                            return this.createToken(55);
                        }
                    } else if (tokenString.equals("async")) {
                        t = new Tokenizer(this).next();
                        if (t.type == 1 && this.getTokenString(t).equals("def")) {
                            this.insideAsyncDef = true;
                            this.indentationOfAsyncDef = this.currentIndentIndex;
                            return this.createToken(56);
                        }
                    }
                    return this.createToken(1);
lbl173:
                    // 1 sources

                    if (c == 10) {
                        this.atBeginningOfLine = true;
                        if (blankline || this.parensNestingLevel > 0) {
                            target = 0;
                            continue block18;
                        }
                        if (this.insideAsyncDef) {
                            this.asyncDefFollowedByNewline = true;
                        }
                        return this.createToken(4);
                    }
                    if (c == 46) {
                        c = this.nextChar();
                        if (Character.isDigit(c)) {
                            target = 3;
                            continue block18;
                        }
                        if (c == 46) {
                            c = this.nextChar();
                            if (c == 46) {
                                return this.createToken(52);
                            }
                            this.oneBack();
                            this.oneBack();
                        } else {
                            this.oneBack();
                        }
                        return this.createToken(23);
                    }
                    if (Character.isDigit(c)) {
                        if (c == 48) {
                            c = this.nextChar();
                            if (c == 120 || c == 88) {
                                c = this.nextChar();
                                do {
                                    if (c == 95) {
                                        c = this.nextChar();
                                    }
                                    if (!Tokenizer.isHexDigit(c)) {
                                        this.oneBack();
                                        return this.syntaxError("invalid hexadecimal literal");
                                    }
                                    while (Tokenizer.isHexDigit(c = this.nextChar())) {
                                    }
                                } while (c == 95);
                                syntaxError = this.verifyEndOfNumber(c, "hexadecimal");
                                if (syntaxError != null) {
                                    return syntaxError;
                                }
                            } else if (c == 111 || c == 79) {
                                c = this.nextChar();
                                do {
                                    if (c == 95) {
                                        c = this.nextChar();
                                    }
                                    if (c < 48 || c >= 56) {
                                        this.oneBack();
                                        if (Character.isDigit(c)) {
                                            return this.syntaxError(String.format("invalid digit '%c' in octal literal", new Object[]{Character.valueOf((char)c)}));
                                        }
                                        this.oneBack();
                                        return this.syntaxError("invalid octal literal");
                                    }
                                    while (48 <= (c = this.nextChar()) && c < 56) {
                                    }
                                } while (c == 95);
                                if (Character.isDigit(c)) {
                                    return this.syntaxError(String.format("invalid digit '%c' in octal literal", new Object[]{Character.valueOf((char)c)}));
                                }
                                syntaxError = this.verifyEndOfNumber(c, "octal");
                                if (syntaxError != null) {
                                    return syntaxError;
                                }
                            } else if (c == 98 || c == 66) {
                                c = this.nextChar();
                                do {
                                    if (c == 95) {
                                        c = this.nextChar();
                                    }
                                    if (c != 48 && c != 49) {
                                        this.oneBack();
                                        if (Character.isDigit(c)) {
                                            return this.syntaxError(String.format("invalid digit '%c' in binary literal", new Object[]{Character.valueOf((char)c)}));
                                        }
                                        return this.syntaxError("invalid binary literal");
                                    }
                                    while ((c = this.nextChar()) == 48 || c == 49) {
                                    }
                                } while (c == 95);
                                if (Character.isDigit(c)) {
                                    return this.syntaxError(String.format("invalid digit '%c' in binary literal", new Object[]{Character.valueOf((char)c)}));
                                }
                                syntaxError = this.verifyEndOfNumber(c, "octal");
                                if (syntaxError != null) {
                                    return syntaxError;
                                }
                            } else {
                                nonzero = false;
                                while (true) {
                                    if (c == 95 && !Character.isDigit(c = this.nextChar())) {
                                        this.oneBack();
                                        return this.syntaxError("invalid decimal literal");
                                    }
                                    if (c != 48) break;
                                    c = this.nextChar();
                                }
                                zerosEnd = this.nextCharIndex;
                                if (Character.isDigit(c)) {
                                    nonzero = true;
                                    c = this.readDecimalTail();
                                    if (c == 0) {
                                        return this.syntaxError("invalid decimal literal");
                                    }
                                }
                                if (c == 46) {
                                    c = this.nextChar();
                                    target = 3;
                                    continue block18;
                                }
                                if (c == 101 || c == 69) {
                                    target = 4;
                                    continue block18;
                                }
                                if (c == 106 || c == 74) {
                                    target = 5;
                                    continue block18;
                                }
                                if (nonzero) {
                                    this.oneBack();
                                    this.nextCharIndex = zerosEnd;
                                    return this.syntaxError(this.tokenStart + 1 - this.lineStartIndex, zerosEnd - this.lineStartIndex, "leading zeros in decimal integer literals are not permitted; use an 0o prefix for octal integers");
                                }
                                syntaxError = this.verifyEndOfNumber(c, "decimal");
                                if (syntaxError != null) {
                                    return syntaxError;
                                }
                            }
                        } else {
                            c = this.readDecimalTail();
                            if (c == 0) {
                                return this.syntaxError("invalid decimal literal");
                            }
                            if (c == 46) {
                                c = this.nextChar();
                                target = 3;
                                continue block18;
                            }
                            if (c == 101 || c == 69) {
                                target = 4;
                                continue block18;
                            }
                            if (c == 106 || c == 74) {
                                target = 5;
                                continue block18;
                            }
                            syntaxError = this.verifyEndOfNumber(c, "decimal");
                            if (syntaxError != null) {
                                return syntaxError;
                            }
                        }
                        this.oneBack();
                        return this.createToken(2);
                    }
                    target = 2;
                    continue block18;
                }
                case 3: {
                    if (Character.isDigit(c) && (c = this.readDecimalTail()) == 0) {
                        return this.syntaxError("invalid decimal literal");
                    }
                    if (c == 101 || c == 69) {
                        target = 4;
                        continue block18;
                    }
                    if (c == 106 || c == 74) {
                        target = 5;
                        continue block18;
                    }
                    syntaxError = this.verifyEndOfNumber(c, "decimal");
                    if (syntaxError != null) {
                        return syntaxError;
                    }
                    this.oneBack();
                    return this.createToken(2);
                }
                case 4: {
                    e = c;
                    c = this.nextChar();
                    if (c == 43 || c == 45) {
                        c = this.nextChar();
                        if (!Character.isDigit(c)) {
                            this.oneBack();
                            return this.syntaxError("invalid decimal literal");
                        }
                    } else if (!Character.isDigit(c)) {
                        this.oneBack();
                        syntaxError = this.verifyEndOfNumber(e, "decimal");
                        if (syntaxError != null) {
                            return syntaxError;
                        }
                        this.oneBack();
                        return this.createToken(2);
                    }
                    if ((c = this.readDecimalTail()) == 0) {
                        return this.syntaxError("invalid decimal literal");
                    }
                    if (c == 106 || c == 74) {
                        target = 5;
                        continue block18;
                    }
                    syntaxError = this.verifyEndOfNumber(c, "decimal");
                    if (syntaxError != null) {
                        return syntaxError;
                    }
                    this.oneBack();
                    return this.createToken(2);
                }
                case 5: {
                    c = this.nextChar();
                    syntaxError = this.verifyEndOfNumber(c, "decimal");
                    if (syntaxError != null) {
                        return syntaxError;
                    }
                    this.oneBack();
                    return this.createToken(2);
                }
                case 2: {
                    if (c == 39 || c == 34) {
                        quote = c;
                        quote_size = 1;
                        end_quote_size = 0;
                        this.firstLineNumber = this.currentLineNumber;
                        this.multiLineStartIndex = this.lineStartIndex;
                        c = this.nextChar();
                        if (c == quote) {
                            c = this.nextChar();
                            if (c == quote) {
                                quote_size = 3;
                            } else {
                                end_quote_size = 1;
                            }
                        }
                        if (c != quote) {
                            this.oneBack();
                        }
                        while (end_quote_size != quote_size) {
                            c = this.nextChar();
                            if (c == -1 || quote_size == 1 && c == 10) {
                                this.nextCharIndex = this.tokenStart;
                                ++this.nextCharIndex;
                                this.lineStartIndex = this.multiLineStartIndex;
                                start = this.currentLineNumber;
                                this.currentLineNumber = this.firstLineNumber;
                                if (quote_size == 3) {
                                    return this.syntaxError(String.format("unterminated triple-quoted string literal (detected at line %d)", new Object[]{start}));
                                }
                                return this.syntaxError(String.format("unterminated string literal (detected at line %d)", new Object[]{start}));
                            }
                            if (c == quote) {
                                ++end_quote_size;
                                continue;
                            }
                            end_quote_size = 0;
                            if (c != 92) continue;
                            this.nextChar();
                        }
                        return this.createToken(3);
                    }
                    if (c == 92) {
                        c = this.continuationLine();
                        if (c == -1) {
                            return this.createToken(60);
                        }
                        this.inContinuationLine = true;
                        target = 1;
                        continue block18;
                    }
                    c2 = this.nextChar();
                    kind2 = Token.twoChars(c, c2);
                    if (kind2 != 54) {
                        c3 = this.nextChar();
                        kind3 = Token.threeChars(c, c2, c3);
                        if (kind3 != 54) {
                            return this.createToken(kind3);
                        }
                        this.oneBack();
                        return this.createToken(kind2);
                    }
                    this.oneBack();
                    switch (c) {
                        case 40: 
                        case 91: 
                        case 123: {
                            if (this.parensNestingLevel >= 200) {
                                return this.syntaxError("too many nested parentheses");
                            }
                            this.parensStack[this.parensNestingLevel] = c;
                            this.parensLineNumberStack[this.parensNestingLevel] = this.currentLineNumber;
                            this.parensColumnsStack[this.parensNestingLevel] = this.tokenStart - this.lineStartIndex;
                            ++this.parensNestingLevel;
                            break;
                        }
                        case 41: 
                        case 93: 
                        case 125: {
                            if (this.parensNestingLevel == 0) {
                                return this.syntaxError(String.format("unmatched '%c'", new Object[]{Character.valueOf((char)c)}));
                            }
                            --this.parensNestingLevel;
                            opening = this.parensStack[this.parensNestingLevel];
                            if (opening == 40 && c == 41 || opening == 91 && c == 93 || opening == 123 && c == 125) break;
                            if (this.parensLineNumberStack[this.parensNestingLevel] != this.currentLineNumber) {
                                return this.syntaxError(String.format("closing parenthesis '%c' does not match opening parenthesis '%c' on line %d", new Object[]{Character.valueOf((char)c), Character.valueOf((char)opening), this.parensLineNumberStack[this.parensNestingLevel]}));
                            }
                            return this.syntaxError(String.format("closing parenthesis '%c' does not match opening parenthesis '%c'", new Object[]{Character.valueOf((char)c), Character.valueOf((char)opening)}));
                        }
                    }
                    return this.createToken(Token.oneChar(c));
                }
            }
        }
    }

    public static Charset findEncodingForFilename(SeekableByteChannel channel) throws IOException {
        int bytesRead;
        byte[] ary = new byte[]{};
        int bufferSize = 0;
        int newlines = 0;
        int totalBytesRead = 0;
        do {
            int i = bufferSize;
            ByteBuffer buf = ByteBuffer.allocate(bufferSize += 4096);
            buf.put(ary);
            bytesRead = channel.read(buf);
            if (bytesRead <= 0) continue;
            totalBytesRead += bytesRead;
            ary = buf.array();
            while (i < totalBytesRead && (ary[i++] != 10 || ++newlines != 2)) {
            }
        } while (bytesRead > 0 && newlines < 2);
        return Tokenizer.detectEncoding(Tokenizer.getSourceStart(ary), ary);
    }

    private static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private Token createToken(int kind) {
        return this.createToken(kind, null);
    }

    private Token createToken(int kind, Object extraData) {
        if (kind == 0) {
            return new Token(kind, this.parensNestingLevel, this.tokenStart, this.nextCharIndex, new SourceRange(this.currentLineNumber, -1, this.currentLineNumber, -1), extraData);
        }
        return new Token(kind, this.parensNestingLevel, this.tokenStart, this.nextCharIndex, this.getCurrentTokenRange(kind == 3), extraData);
    }

    private SourceRange getCurrentTokenRange(boolean multiLineString) {
        int endColOffset;
        int lineStart = multiLineString ? this.multiLineStartIndex : this.lineStartIndex;
        int lineno = multiLineString ? this.firstLineNumber : this.currentLineNumber;
        int endLineno = this.currentLineNumber;
        int colOffset = this.tokenStart >= lineStart ? this.tokenStart - lineStart : -1;
        int n = endColOffset = this.nextCharIndex >= this.lineStartIndex ? this.nextCharIndex - this.lineStartIndex : -1;
        if (lineno == 1) {
            colOffset += this.srcStartColumn;
        }
        if (endLineno == 1) {
            endColOffset += this.srcStartColumn;
        }
        return new SourceRange(lineno += this.srcStartLine, colOffset, endLineno += this.srcStartLine, endColOffset);
    }

    public String getTokenString(Token tok) {
        if (tok.startOffset >= this.codePointsInput.length) {
            return "";
        }
        String s = tok.endOffset >= this.codePointsInput.length ? new String(this.codePointsInput, tok.startOffset, this.codePointsInput.length - tok.startOffset) : new String(this.codePointsInput, tok.startOffset, tok.endOffset - tok.startOffset);
        if (s.indexOf(13) >= 0) {
            s = s.replaceAll("\r\n", "\n");
            s = s.replace('\r', '\n');
        }
        return s;
    }

    public String toString(Token token) {
        StringBuilder sb = new StringBuilder();
        sb.append("Token ");
        sb.append(token.typeName());
        sb.append(" [").append(token.startOffset).append(", ").append(token.endOffset).append("]");
        sb.append(" (").append(token.sourceRange.startLine).append(", ").append(token.sourceRange.startColumn);
        sb.append(") (").append(token.sourceRange.endLine).append(", ").append(token.sourceRange.endColumn).append(") '");
        sb.append(this.getTokenString(token)).append("'");
        return sb.toString();
    }

    public SourceRange extendRangeToCurrentPosition(SourceRange rangeStart) {
        return rangeStart.withEnd(this.currentLineNumber, this.nextCharIndex - this.lineStartIndex);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isBadSingleStatement() {
        cur = this.nextCharIndex;
        if (cur >= this.codePointsInput.length) {
            return false;
        }
        c = this.codePointsInput[cur];
        block0: while (true) {
            if (c == 32 || c == 9 || c == 10 || c == 12) {
                if (++cur >= this.codePointsInput.length) {
                    return false;
                }
                c = this.codePointsInput[cur];
                continue;
            }
            if (c != 35) {
                return true;
            }
            while (true) {
                if (c != 10) ** break;
                continue block0;
                if (++cur >= this.codePointsInput.length) {
                    return false;
                }
                c = this.codePointsInput[cur];
            }
            break;
        }
    }

    public StatusCode getDone() {
        return this.done;
    }

    public int getParensNestingLevel() {
        return this.parensNestingLevel;
    }

    public int[] getParensStack() {
        return this.parensStack;
    }

    public int[] getParensLineNumberStack() {
        return this.parensLineNumberStack;
    }

    public int[] getParensColumnsStack() {
        return this.parensColumnsStack;
    }

    public int getNextCharIndex() {
        return this.nextCharIndex;
    }

    public int getLineStartIndex() {
        return this.lineStartIndex;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public int getCurrentIndentIndex() {
        return this.currentIndentIndex;
    }

    public void setCurrentIndentIndex(int currentIndentIndex) {
        this.currentIndentIndex = currentIndentIndex;
    }

    public void setPendingIndents(int pendingIndents) {
        this.pendingIndents = pendingIndents;
    }

    public static enum StatusCode {
        OK,
        EOF,
        INTERRUPTED,
        BAD_TOKEN,
        SYNTAX_ERROR,
        OUT_OF_MEMORY,
        DONE,
        EXECUTION_ERROR,
        TABS_SPACES_INCONSISTENT,
        NODE_OVERFLOW,
        TOO_DEEP_INDENTATION,
        DEDENT_INVALID,
        UNICODE_DECODE_ERROR,
        LINE_CONTINUATION_ERROR,
        BAD_SINGLE_STATEMENT,
        INTERACTIVE_STOP;

    }

    public static enum Flag {
        EXEC_INPUT,
        INTERACTIVE,
        TYPE_COMMENT,
        ASYNC_HACKS;

    }
}

