/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.source;

import japa.parser.ASTHelper;
import japa.parser.JavaParser;
import japa.parser.ast.Comment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.LineComment;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.graphwalker.core.model.Model;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.source.ChangeContext;
import org.graphwalker.java.source.SourceFile;

public final class CodeGenerator
extends VoidVisitorAdapter<ChangeContext> {
    public String generate(String file) {
        return this.generate(Paths.get(file, new String[0]));
    }

    public String generate(File file) {
        return this.generate(file.toPath());
    }

    public String generate(Path path) {
        ContextFactory factory = ContextFactoryScanner.get((Path)path);
        SourceFile sourceFile = new SourceFile(path);
        return this.generate(sourceFile, factory.create(path).getModel());
    }

    public String generate(SourceFile sourceFile, Model.RuntimeModel model) {
        CompilationUnit compilationUnit = this.getCompilationUnit(sourceFile);
        ChangeContext changeContext = new ChangeContext(model);
        this.visit(compilationUnit, changeContext);
        this.removeMethods(compilationUnit, changeContext);
        this.generateMethods(compilationUnit, changeContext);
        return compilationUnit.toString();
    }

    private CompilationUnit getCompilationUnit(SourceFile sourceFile) {
        CompilationUnit compilationUnit;
        if (Files.exists(sourceFile.getOutputPath(), new LinkOption[0])) {
            try {
                compilationUnit = JavaParser.parse((File)sourceFile.getOutputPath().toFile());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else {
            compilationUnit = new CompilationUnit();
            compilationUnit.setComment((Comment)new LineComment(" Generated by GraphWalker (http://www.graphwalker.org)"));
            if (!"".equals(sourceFile.getPackageName())) {
                compilationUnit.setPackage(this.createPackageDeclaration(sourceFile));
            }
            compilationUnit.setImports(Arrays.asList(new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Model"), false, false), new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Vertex"), false, false), new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Edge"), false, false)));
            ASTHelper.addTypeDeclaration((CompilationUnit)compilationUnit, (TypeDeclaration)this.getInterfaceName(sourceFile));
        }
        return compilationUnit;
    }

    private void removeMethods(CompilationUnit compilationUnit, ChangeContext changeContext) {
        if (0 < changeContext.getMethodDeclarations().size()) {
            ClassOrInterfaceDeclaration body = (ClassOrInterfaceDeclaration)compilationUnit.getTypes().get(0);
            body.getMembers().removeAll(changeContext.getMethodDeclarations());
        }
    }

    private void generateMethods(CompilationUnit compilationUnit, ChangeContext changeContext) {
        ClassOrInterfaceDeclaration body = (ClassOrInterfaceDeclaration)compilationUnit.getTypes().get(0);
        for (String methodName : changeContext.getMethodNames()) {
            ArrayList memberValuePairs;
            if (!this.isValidName(methodName)) continue;
            MethodDeclaration method = new MethodDeclaration(512, (Type)ASTHelper.VOID_TYPE, methodName);
            ArrayList<NormalAnnotationExpr> annotations = new ArrayList<NormalAnnotationExpr>();
            if (changeContext.isVertex(methodName)) {
                memberValuePairs = new ArrayList();
                annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Vertex"), memberValuePairs));
            } else {
                memberValuePairs = new ArrayList();
                annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Edge"), memberValuePairs));
            }
            method.setAnnotations(annotations);
            ASTHelper.addMember((TypeDeclaration)body, (BodyDeclaration)method);
        }
    }

    private boolean isValidName(String name) {
        if (null == name || name.isEmpty()) {
            return false;
        }
        boolean valid = true;
        for (int i = 0; i < name.length(); ++i) {
            if (0 == i) {
                valid &= Character.isJavaIdentifierStart(name.charAt(i));
                continue;
            }
            valid &= Character.isJavaIdentifierPart(name.charAt(i));
        }
        return valid;
    }

    public void visit(MethodDeclaration methodDeclaration, ChangeContext changeContext) {
        if (changeContext.getMethodNames().contains(methodDeclaration.getName())) {
            changeContext.getMethodNames().remove(methodDeclaration.getName());
        } else {
            changeContext.addMethodDeclaration(methodDeclaration);
        }
    }

    private PackageDeclaration createPackageDeclaration(SourceFile sourceFile) {
        return new PackageDeclaration(ASTHelper.createNameExpr((String)sourceFile.getPackageName()));
    }

    private ClassOrInterfaceDeclaration getInterfaceName(SourceFile sourceFile) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(1, false, sourceFile.getFileName());
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        memberValuePairs.add(new MemberValuePair("file", (Expression)new StringLiteralExpr(sourceFile.getRelativePath().toString().replace(File.separator, "/"))));
        ArrayList<NormalAnnotationExpr> annotations = new ArrayList<NormalAnnotationExpr>();
        annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Model"), memberValuePairs));
        classOrInterfaceDeclaration.setAnnotations(annotations);
        classOrInterfaceDeclaration.setInterface(true);
        return classOrInterfaceDeclaration;
    }
}

