/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.graphwalker.core.condition.ReachedStopCondition;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.event.Observer;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.SimpleMachine;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.annotation.AfterElement;
import org.graphwalker.java.annotation.AfterExecution;
import org.graphwalker.java.annotation.AnnotationUtils;
import org.graphwalker.java.annotation.BeforeElement;
import org.graphwalker.java.annotation.BeforeExecution;
import org.graphwalker.java.annotation.GraphWalker;
import org.graphwalker.java.annotation.Model;
import org.graphwalker.java.test.Configuration;
import org.graphwalker.java.test.Executor;
import org.graphwalker.java.test.SelectorUtils;
import org.graphwalker.java.test.TestExecutionException;

public final class TestExecutor
implements Executor {
    private final Configuration configuration;
    private final Set<Machine> machines = new HashSet<Machine>();
    private final Map<Context, MachineException> failures = new HashMap<Context, MachineException>();

    public TestExecutor(Configuration configuration) {
        this.configuration = configuration;
        List<Context> contexts = this.createContexts(AnnotationUtils.findTests());
        if (!contexts.isEmpty()) {
            this.machines.add(this.createMachine(contexts));
        }
    }

    public TestExecutor(Context ... contexts) {
        this.configuration = new Configuration();
        this.configureContexts(contexts);
        if (0 < contexts.length) {
            this.machines.add(this.createMachine(contexts));
        }
    }

    private Machine createMachine(Context ... contexts) {
        return this.createMachine(Arrays.asList(contexts));
    }

    private Machine createMachine(List<Context> contexts) {
        SimpleMachine machine = new SimpleMachine(contexts);
        for (Context context : contexts) {
            if (!(context instanceof Observer)) continue;
            machine.addObserver((Observer)context);
        }
        return machine;
    }

    @Override
    public Set<Machine> getMachines() {
        return this.machines;
    }

    private List<Context> createContexts(Set<Class<? extends Context>> testClasses) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (Class<? extends Context> testClass : testClasses) {
            GraphWalker annotation = testClass.getAnnotation(GraphWalker.class);
            if (!this.isTestIncluded(annotation, testClass.getName())) continue;
            Context context = this.createContext(testClass);
            this.configureContext(context, annotation);
            contexts.add(context);
        }
        return contexts;
    }

    private void configureContexts(Context ... contexts) {
        for (Context context : contexts) {
            this.configureContext(context);
        }
    }

    private void configureContext(Context context) {
        GraphWalker annotation = context.getClass().getAnnotation(GraphWalker.class);
        if (null != annotation) {
            this.configureContext(context, annotation);
        }
    }

    private void configureContext(Context context, GraphWalker annotation) {
        if (!"".equals(annotation.value())) {
            context.setPathGenerator(GeneratorFactory.parse((String)annotation.value()));
        } else {
            context.setPathGenerator(this.createPathGenerator(annotation));
        }
        if (!"".equals(annotation.start())) {
            context.setNextElement(this.getElement(context.getModel(), annotation.start()));
        }
    }

    private boolean isTestIncluded(GraphWalker annotation, String name) {
        boolean belongsToGroup = false;
        block0: for (String group : annotation.groups()) {
            for (String definedGroups : this.configuration.getGroups()) {
                if (!SelectorUtils.match(definedGroups, group)) continue;
                belongsToGroup = true;
                continue block0;
            }
        }
        if (belongsToGroup) {
            for (String exclude : this.configuration.getExcludes()) {
                if (!SelectorUtils.match(exclude, name)) continue;
                return false;
            }
            for (String include : this.configuration.getIncludes()) {
                if (!SelectorUtils.match(include, name)) continue;
                return true;
            }
        }
        return false;
    }

    private Context createContext(Class<? extends Context> testClass) {
        try {
            Set<Model> models = AnnotationUtils.getAnnotations(testClass, Model.class);
            Context context = testClass.newInstance();
            if (!models.isEmpty()) {
                Path path = Paths.get(models.iterator().next().file(), new String[0]);
                context = ContextFactoryScanner.get((Path)path).create(path, context);
            }
            return context;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private PathGenerator createPathGenerator(GraphWalker annotation) {
        try {
            Constructor<? extends PathGenerator> constructor = null;
            try {
                constructor = annotation.pathGenerator().getConstructor(StopCondition.class);
            }
            catch (Throwable t) {
                constructor = annotation.pathGenerator().getConstructor(ReachedStopCondition.class);
            }
            if (null == constructor) {
                throw new TestExecutionException("Couldn't find a valid constructor");
            }
            return constructor.newInstance(this.createStopCondition(annotation));
        }
        catch (Throwable e) {
            throw new TestExecutionException(e);
        }
    }

    private StopCondition createStopCondition(GraphWalker annotation) {
        String value = annotation.stopConditionValue();
        Class<? extends StopCondition> stopCondition = annotation.stopCondition();
        if (value.isEmpty()) {
            try {
                return stopCondition.newInstance();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            return stopCondition.getConstructor(String.class).newInstance(value);
        }
        catch (Throwable e) {
            try {
                return stopCondition.getConstructor(Long.TYPE).newInstance(Long.parseLong(value));
            }
            catch (Throwable e2) {
                try {
                    return stopCondition.getConstructor(Integer.TYPE).newInstance(Integer.parseInt(value));
                }
                catch (Throwable e3) {
                    try {
                        return stopCondition.getConstructor(Double.TYPE).newInstance(Double.parseDouble(value));
                    }
                    catch (Throwable e4) {
                        try {
                            return stopCondition.getConstructor(Float.TYPE).newInstance(Float.valueOf(Float.parseFloat(value)));
                        }
                        catch (Throwable e5) {
                            throw new TestExecutionException();
                        }
                    }
                }
            }
        }
    }

    private Element getElement(Model.RuntimeModel model, String name) {
        List elements = model.findElements(name);
        if (null == elements || 0 == elements.size()) {
            throw new TestExecutionException("Start element not found");
        }
        if (1 < elements.size()) {
            throw new TestExecutionException("Ambiguous start element defined");
        }
        return (Element)elements.get(0);
    }

    @Override
    public Executor execute() {
        if (!this.machines.isEmpty()) {
            this.executeAnnotation(BeforeExecution.class, this.machines);
            ExecutorService executorService = Executors.newFixedThreadPool(this.machines.size());
            for (final Machine machine : this.machines) {
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Context context = null;
                            while (machine.hasNextStep()) {
                                if (null != context) {
                                    TestExecutor.this.executeAnnotation((Class<? extends Annotation>)BeforeElement.class, context);
                                }
                                context = machine.getNextStep();
                                TestExecutor.this.executeAnnotation((Class<? extends Annotation>)AfterElement.class, context);
                            }
                        }
                        catch (MachineException e) {
                            TestExecutor.this.failures.put(e.getContext(), e);
                        }
                    }
                });
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executeAnnotation(AfterExecution.class, this.machines);
        }
        return this;
    }

    private void executeAnnotation(Class<? extends Annotation> annotation, Set<Machine> machines) {
        for (Machine machine : machines) {
            this.executeAnnotation(annotation, machine);
        }
    }

    private void executeAnnotation(Class<? extends Annotation> annotation, Machine machine) {
        for (Context context : machine.getContexts()) {
            this.executeAnnotation(annotation, context);
        }
    }

    private void executeAnnotation(Class<? extends Annotation> annotation, Context context) {
        AnnotationUtils.execute(annotation, context);
    }

    @Override
    public boolean isFailure(Context context) {
        return this.failures.containsKey(context);
    }

    @Override
    public MachineException getFailure(Context context) {
        return this.failures.get(context);
    }

    @Override
    public Collection<MachineException> getFailures() {
        return this.failures.values();
    }
}

