/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public final class IsolatedClassLoader
extends URLClassLoader {
    public IsolatedClassLoader(List<String> urls) {
        this(IsolatedClassLoader.convert(urls));
    }

    public IsolatedClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader().getParent());
    }

    private static URL[] convert(List<String> urls) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String url : urls) {
            try {
                urlList.add(new File(url).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urlList.toArray(new URL[urlList.size()]);
    }
}

