/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.RequirementStatus;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Result {
    private List<String> errors = new ArrayList<String>();
    private JSONObject results;

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public void setResults(String results) {
        this.results = new JSONObject(results.toString());
    }

    public JSONObject getResults() {
        return this.results;
    }

    public String getResultsAsString() {
        return this.results.toString(2);
    }

    public void updateResults(Machine machine, Map<Context, MachineException> failures) {
        int modelCount = 0;
        int completedModelCount = 0;
        int incompleteModelCount = 0;
        int failedModelCount = 0;
        int notExecutedModelCount = 0;
        int totalNumberOfEdges = 0;
        int totalNumberOfVertices = 0;
        int totalNumberOfUnvisitedVertices = 0;
        int totalNumberOfUnvisitedEdges = 0;
        int totalNumberOfRequirements = 0;
        int totalNumberOfRequirementsNotCovered = 0;
        int totalNumberOfRequirementsPassed = 0;
        int totalNumberOfRequirementsFailed = 0;
        JSONArray edgesNotVisitedJson = new JSONArray();
        JSONArray verticesNotVisitedJson = new JSONArray();
        JSONArray requirementsNotCoveredJson = new JSONArray();
        JSONArray requirementsPassedJson = new JSONArray();
        JSONArray requirementsFailedJson = new JSONArray();
        for (Context context : machine.getContexts()) {
            JSONObject jsonElement;
            switch (context.getExecutionStatus()) {
                case COMPLETED: {
                    ++completedModelCount;
                    break;
                }
                case FAILED: {
                    ++failedModelCount;
                    break;
                }
                case NOT_EXECUTED: {
                    ++notExecutedModelCount;
                    break;
                }
                case EXECUTING: {
                    ++incompleteModelCount;
                }
            }
            for (Requirement r : context.getRequirements(RequirementStatus.NOT_COVERED)) {
                jsonElement = new JSONObject();
                jsonElement.put("requirementKey", (Object)r.getKey());
                jsonElement.put("modelName", (Object)context.getModel().getName());
                requirementsNotCoveredJson.put((Object)jsonElement);
            }
            for (Requirement r : context.getRequirements(RequirementStatus.PASSED)) {
                jsonElement = new JSONObject();
                jsonElement.put("requirementKey", (Object)r.getKey());
                jsonElement.put("modelName", (Object)context.getModel().getName());
                requirementsPassedJson.put((Object)jsonElement);
            }
            for (Requirement r : context.getRequirements(RequirementStatus.FAILED)) {
                jsonElement = new JSONObject();
                jsonElement.put("RequirementKey", (Object)r.getKey());
                jsonElement.put("modelName", (Object)context.getModel().getName());
                requirementsFailedJson.put((Object)jsonElement);
            }
            for (Element edge : context.getProfiler().getUnvisitedEdges(context)) {
                jsonElement = new JSONObject();
                jsonElement.put("edgeName", (Object)edge.getName());
                jsonElement.put("edgeId", (Object)edge.getId());
                jsonElement.put("modelName", (Object)context.getModel().getName());
                edgesNotVisitedJson.put((Object)jsonElement);
            }
            for (Element vertex : context.getProfiler().getUnvisitedVertices(context)) {
                jsonElement = new JSONObject();
                jsonElement.put("vertexName", (Object)vertex.getName());
                jsonElement.put("vertexId", (Object)vertex.getId());
                jsonElement.put("modelName", (Object)context.getModel().getName());
                verticesNotVisitedJson.put((Object)jsonElement);
            }
            ++modelCount;
            totalNumberOfEdges += context.getModel().getEdges().size();
            totalNumberOfVertices += context.getModel().getVertices().size();
            totalNumberOfUnvisitedVertices += context.getProfiler().getUnvisitedVertices(context).size();
            totalNumberOfUnvisitedEdges += context.getProfiler().getUnvisitedEdges(context).size();
            totalNumberOfRequirements += context.getRequirements().size();
            totalNumberOfRequirementsNotCovered += context.getRequirements(RequirementStatus.NOT_COVERED).size();
            totalNumberOfRequirementsPassed += context.getRequirements(RequirementStatus.PASSED).size();
            totalNumberOfRequirementsFailed += context.getRequirements(RequirementStatus.FAILED).size();
        }
        this.results = new JSONObject();
        this.results.put("totalNumberOfModels", modelCount);
        this.results.put("totalCompletedNumberOfModels", completedModelCount);
        this.results.put("totalIncompleteNumberOfModels", incompleteModelCount);
        this.results.put("totalFailedNumberOfModels", failedModelCount);
        this.results.put("totalNotExecutedNumberOfModels", notExecutedModelCount);
        this.results.put("totalNumberOfEdges", totalNumberOfEdges);
        this.results.put("totalNumberOfUnvisitedEdges", totalNumberOfUnvisitedEdges);
        this.results.put("totalNumberOfVisitedEdges", machine.getProfiler().getVisitedEdges().size());
        this.results.put("edgeCoverage", 100 * (totalNumberOfEdges - totalNumberOfUnvisitedEdges) / totalNumberOfEdges);
        this.results.put("totalNumberOfVertices", totalNumberOfVertices);
        this.results.put("totalNumberOfUnvisitedVertices", totalNumberOfUnvisitedVertices);
        this.results.put("totalNumberOfVisitedVertices", machine.getProfiler().getVisitedVertices().size());
        this.results.put("vertexCoverage", 100 * (totalNumberOfVertices - totalNumberOfUnvisitedVertices) / totalNumberOfVertices);
        this.results.put("edgesNotVisited", (Object)edgesNotVisitedJson);
        this.results.put("verticesNotVisited", (Object)verticesNotVisitedJson);
        if (totalNumberOfRequirements > 0) {
            this.results.put("totalNumberOfRequirement", totalNumberOfRequirements);
            this.results.put("totalNumberOfUncoveredRequirement", totalNumberOfRequirementsNotCovered);
            this.results.put("totalNumberOfPassedRequirement", totalNumberOfRequirementsPassed);
            this.results.put("totalNumberOfFailedRequirement", totalNumberOfRequirementsFailed);
            this.results.put("requirementCoverage", 100 * (totalNumberOfRequirements - totalNumberOfRequirementsNotCovered) / totalNumberOfRequirements);
            this.results.put("requirementsNotCovered", (Object)requirementsNotCoveredJson);
            this.results.put("requirementsPassed", (Object)requirementsPassedJson);
            this.results.put("requirementsFailed", (Object)requirementsFailedJson);
        }
        if (failures.size() > 0) {
            JSONArray jsonFailures = new JSONArray();
            for (MachineException exception : failures.values()) {
                JSONObject jsonFailure = new JSONObject();
                jsonFailure.put("failure", (Object)this.getStackTrace(exception.getCause()));
                jsonFailures.put((Object)jsonFailure);
            }
            this.results.put("failures", (Object)jsonFailures);
        }
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)writer, true));
        return writer.getBuffer().toString();
    }
}

