/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsolatedClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(IsolatedClassLoader.class);

    public IsolatedClassLoader(List<String> urls) {
        this(IsolatedClassLoader.convert(urls));
    }

    public IsolatedClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader().getParent());
    }

    private static URL[] convert(List<String> urls) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (String url : urls) {
            try {
                urlList.add(new File(url).toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return urlList.toArray(new URL[urlList.size()]);
    }
}

