/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class ClassDumpTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ClassDumpTransformer.class);
    private static final String CLASS_DUMP_DIR = "classDump";
    private final Set<Class<?>> classesToEnhance;
    private final Map<Class<?>, File> dumpResult;
    private final File directory;

    public ClassDumpTransformer(Set<Class<?>> classesToEnhance) {
        this(classesToEnhance, null);
    }

    public ClassDumpTransformer(Set<Class<?>> classesToEnhance, File directory) {
        this.classesToEnhance = classesToEnhance;
        this.dumpResult = new HashMap();
        this.directory = directory;
    }

    @Override
    @Nullable
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this.classesToEnhance.contains(classBeingRedefined)) {
            this.dumpClassIfNecessary(classBeingRedefined, classfileBuffer);
        }
        return null;
    }

    public Map<Class<?>, File> getDumpResult() {
        return this.dumpResult;
    }

    private void dumpClassIfNecessary(Class<?> clazz, byte[] data) {
        File dumpClassFile;
        String className = clazz.getName();
        ClassLoader classLoader = clazz.getClassLoader();
        File dumpDir = this.directory != null ? this.directory : new File(CLASS_DUMP_DIR);
        if (!dumpDir.mkdirs() && !dumpDir.exists()) {
            logger.warn("create dump directory:{} failed.", (Object)dumpDir.getAbsolutePath());
            return;
        }
        String fileName = classLoader != null ? classLoader.getClass().getName() + "-" + Integer.toHexString(classLoader.hashCode()) + File.separator + className.replace(".", File.separator) + ".class" : className.replace(".", File.separator) + ".class";
        File paths = new File(dumpDir, fileName.substring(0, fileName.lastIndexOf("/") + 1));
        if (!paths.exists()) {
            boolean mkdirs = paths.mkdirs();
            logger.info("create calssDump dirs : {}", (Object)mkdirs);
        }
        if ((dumpClassFile = new File(dumpDir, fileName)).exists()) {
            boolean delete = dumpClassFile.delete();
            logger.info("delete file {} {}", (Object)dumpClassFile.getName(), (Object)delete);
        }
        try (FileOutputStream out = new FileOutputStream(dumpClassFile);){
            ((OutputStream)out).write(data);
            out.flush();
            this.dumpResult.put(clazz, dumpClassFile);
        }
        catch (IOException e) {
            logger.warn("dump class:{} to file {} failed.", new Object[]{className, dumpClassFile, e});
        }
    }
}

