/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class DynamicCompilerException
extends RuntimeException {
    private static final long serialVersionUID = 844455388423567597L;
    private final List<Diagnostic<? extends JavaFileObject>> diagnostics;

    public DynamicCompilerException(String message, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        super(message);
        this.diagnostics = diagnostics;
    }

    public DynamicCompilerException(Throwable cause, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        super(cause);
        this.diagnostics = diagnostics;
    }

    private List<Map<String, Object>> getErrorList() {
        ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
        if (this.diagnostics != null) {
            for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnostics) {
                HashMap<String, Object> message = new HashMap<String, Object>();
                message.put("line", diagnostic.getLineNumber());
                message.put("message", diagnostic.getMessage(Locale.ENGLISH));
                messages.add(message);
            }
        }
        return messages;
    }

    private String getErrors() {
        StringBuilder errors = new StringBuilder();
        for (Map<String, Object> message : this.getErrorList()) {
            for (Map.Entry<String, Object> entry : message.entrySet()) {
                Object value = entry.getValue();
                if (value != null && !value.toString().isEmpty()) {
                    errors.append(entry.getKey());
                    errors.append(": ");
                    errors.append(value);
                }
                errors.append(" , ");
            }
            errors.append("\n");
        }
        return errors.toString();
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n" + this.getErrors();
    }
}

