/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.spring.launcher;

import org.jacpfx.api.fragment.Scope;
import org.jacpfx.api.launcher.Launcher;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringXmlConfigLauncher
implements Launcher<ClassPathXmlApplicationContext> {
    private final ClassPathXmlApplicationContext context;
    private final ConfigurableListableBeanFactory factory;
    private final String BASIC_CONFIG_BEANS = "basic.xml";

    public SpringXmlConfigLauncher(String resource) {
        this.context = new ClassPathXmlApplicationContext(new String[]{resource, this.BASIC_CONFIG_BEANS});
        this.factory = this.context.getBeanFactory();
    }

    public ClassPathXmlApplicationContext getContext() {
        return this.context;
    }

    public synchronized <E> E getBean(Class<E> clazz) {
        return (E)this.factory.getBean(clazz);
    }

    public synchronized <T> T registerAndGetBean(Class<? extends T> type, String id, Scope scope) {
        if (this.factory.containsBean(id)) {
            return this.getBean(type);
        }
        AutowireCapableBeanFactory factory = this.getContext().getAutowireCapableBeanFactory();
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)factory;
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(type);
        if (scope != null) {
            beanDefinition.setScope(scope.getType());
        }
        beanDefinition.setAutowireCandidate(true);
        registry.registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        factory.autowireBeanProperties((Object)this, 2, false);
        return this.getBean(type);
    }
}

