/*
 * Decompiled with CFR 0.152.
 */
package org.jacpfx.spring.launcher;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.jacpfx.api.handler.ErrorDialogHandler;
import org.jacpfx.rcp.handler.DefaultErrorDialogHandler;
import org.jacpfx.rcp.handler.ExceptionHandler;
import org.jacpfx.rcp.registry.ClassRegistry;
import org.jacpfx.rcp.util.ClassFinder;
import org.jacpfx.rcp.workbench.AFXWorkbench;
import org.jacpfx.rcp.workbench.FXWorkbench;

public abstract class ASpringLauncher
extends Application {
    protected AFXWorkbench workbench;

    public AFXWorkbench getWorkbench() {
        return this.workbench;
    }

    protected abstract Class<? extends FXWorkbench> getWorkbenchClass();

    protected void scanPackegesAndInitRegestry() {
        String[] packages = this.getBasePackages();
        if (packages == null) {
            throw new InvalidParameterException("no  packes declared, declare all packages containing perspective and component");
        }
        ClassFinder finder = new ClassFinder();
        Stream.of(packages).forEach(p -> {
            try {
                ClassRegistry.addClasses(Arrays.asList(finder.getAll(p)));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
    }

    protected void initExceptionHandler() {
        ExceptionHandler.initExceptionHandler(this.getErrorHandler());
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getInstance());
    }

    protected abstract String[] getBasePackages();

    protected abstract void postInit(Stage var1);

    protected ErrorDialogHandler<Node> getErrorHandler() {
        return new DefaultErrorDialogHandler();
    }
}

