/*
 * Decompiled with CFR 0.152.
 */
package com.plato.util.html;

import com.plato.util.html.HTMLSearchableCompression;
import com.plato.util.html.StringSerializable;
import com.plato.util.html.TagInstance;

public class Attribute
implements StringSerializable {
    static final String ATTR_DELIMIT = "#attr";
    static String ATTR_REGEX = "[^(\"|<|>|\\s|;)]+=\"[^\"]+\"";
    private String key;
    private String value;

    Attribute(String key, String value) {
        this.key = key;
        this.value = value;
    }

    static Attribute deserializeString(String a) {
        if (a == null) {
            throw new NullPointerException("Input value is cannot be null");
        }
        if ("".equals(a.trim())) {
            throw new IllegalArgumentException("Attribute must have a key and a value");
        }
        String[] tmpAttr = a.split(HTMLSearchableCompression.notBewteenQuotesRegex("="));
        String[] tmpValue = tmpAttr[1].split("\"");
        if (tmpValue.length < 2) {
            throw new IllegalArgumentException("Attribute value must be of form \"xxx\"");
        }
        return new Attribute(tmpAttr[0], tmpValue[1]);
    }

    static void createAttribute(String sAttr, TagInstance t) {
        String[] keyValue = sAttr.split(HTMLSearchableCompression.notBewteenQuotesRegex("="));
        String key = keyValue[0].trim();
        String value = keyValue[1].split("\"")[1].split("\"")[0].trim();
        t.addAttribute(new Attribute(key, value));
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    @Override
    public String serializeString() {
        return this.key + "=\"" + this.value + "\"";
    }

    public String toString() {
        return this.key + "=\"" + this.value + "\"";
    }
}

