/*
 * Decompiled with CFR 0.152.
 */
package com.plato.util.html;

import com.plato.util.html.StringSerializable;
import com.plato.util.html.TagInstance;

public class ClassAttribute
implements StringSerializable {
    static final String CLASS_REGEX = "class=\"([a-z0-9]|-|\\s)+\"";
    static final String CLASS_DELIMIT = "#class";
    private String value;

    ClassAttribute(String value) {
        this.value = value;
    }

    static void createClassAttribute(String sAttr, TagInstance t) {
        String sSet = sAttr.split("\"")[1].split("\"")[0];
        for (String s : sSet.split(" ")) {
            if ("".equals(s.trim())) continue;
            t.addClassAttribute(new ClassAttribute(s));
        }
    }

    static ClassAttribute deserializeString(String c) {
        if (c == null) {
            throw new NullPointerException("Input value is cannot be null");
        }
        if ("".equals(c.trim())) {
            throw new IllegalArgumentException("Value of class attribute cannot be empty");
        }
        return new ClassAttribute(c);
    }

    String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassAttribute that = (ClassAttribute)o;
        return this.value.equals(that.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String serializeString() {
        return this.value;
    }
}

