/*
 * Decompiled with CFR 0.152.
 */
package com.plato.util.html;

import com.plato.util.html.StringSerializable;
import com.plato.util.html.TagInstance;

public class StyleAttribute
implements StringSerializable {
    static final String STYLE = "style";
    static final String STYLE_REGEX = "style=\"(\\{)?(([a-z0-9]|-)*\\:([a-z0-9]|\\s|-|\\)|\\(|,|#)*\\;)*(\\})?\"";
    static final String STYLE_DELIMIT = "#style";
    private String key;
    private String value;

    StyleAttribute(String key, String value) {
        this.key = key;
        this.value = value;
    }

    static StyleAttribute deserializeString(String s) {
        if (s == null) {
            throw new NullPointerException("Input value is cannot be null");
        }
        if ("".equals(s.trim())) {
            throw new IllegalArgumentException("Value of style attribute cannot be empty");
        }
        String[] sProps = s.split("#:");
        return new StyleAttribute(sProps[0], sProps[1]);
    }

    static void createStyleAttribute(String sAttr, TagInstance t) {
        if (sAttr.split("\"(\\{)?").length < 2) {
            return;
        }
        String sMap = sAttr.split("\"(\\{)?")[1].split("(\\})?\"")[0];
        for (String s : sMap.split("\\;")) {
            String[] sKeyValue = s.split("\\:");
            t.addStyleAttribute(new StyleAttribute(sKeyValue[0].trim(), sKeyValue[1].trim()));
        }
    }

    String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.key + ":" + this.value;
    }

    @Override
    public String serializeString() {
        return this.key + "#:" + this.value;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleAttribute that = (StyleAttribute)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }
}

