/*
 * Decompiled with CFR 0.152.
 */
package com.plato.util.html;

import com.plato.util.html.Attribute;
import com.plato.util.html.ClassAttribute;
import com.plato.util.html.StringSerializable;
import com.plato.util.html.StyleAttribute;
import com.plato.util.html.Tag;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagInstance {
    static final String TAG_DELIMIT = "#tag";
    private static final String OUT_OF_RANGE = "rangeFrom and rangeTo must both be greater or equal than 0";
    private static final String UNRECOGNIZED = " is not a recognized tag";
    private Tag tag;
    private List<StyleAttribute> styleAttributes;
    private List<ClassAttribute> classAttributes;
    private List<Attribute> otherAttributes;
    private int rangeFrom;
    private int rangeTo;

    TagInstance(String sTagName, int rangeFrom, int rangeTo) {
        if (sTagName == null || sTagName.trim().isEmpty()) {
            throw new NullPointerException("TagInstance string cannot be null or empty");
        }
        if (rangeFrom < 0 || rangeTo < 0) {
            throw new IllegalArgumentException(OUT_OF_RANGE);
        }
        Tag locTag = Tag.isTag(sTagName);
        if (locTag == null) {
            throw new IllegalArgumentException(sTagName + UNRECOGNIZED);
        }
        this.tag = locTag;
        this.rangeFrom = rangeFrom;
        if (this.tag.isSelfClosing) {
            this.rangeTo = this.rangeFrom;
            this.styleAttributes = null;
            return;
        }
        this.rangeTo = rangeTo;
        this.styleAttributes = new LinkedList<StyleAttribute>();
        this.classAttributes = new LinkedList<ClassAttribute>();
        this.otherAttributes = new LinkedList<Attribute>();
    }

    TagInstance(String sTagName, int rangeFrom) {
        if (rangeFrom < 0) {
            throw new IllegalArgumentException(OUT_OF_RANGE);
        }
        Tag locTag = Tag.isTag(sTagName);
        if (locTag == null) {
            throw new IllegalArgumentException(sTagName + UNRECOGNIZED);
        }
        this.tag = locTag;
        this.rangeFrom = rangeFrom;
        if (locTag.isSelfClosing) {
            this.rangeTo = rangeFrom;
        }
        this.styleAttributes = new LinkedList<StyleAttribute>();
        this.classAttributes = new LinkedList<ClassAttribute>();
        this.otherAttributes = new LinkedList<Attribute>();
    }

    private TagInstance(Tag tag, int rangeFrom, int rangeTo) {
        if (rangeFrom < 0 || rangeTo < 0) {
            throw new IllegalArgumentException(OUT_OF_RANGE);
        }
        this.tag = tag;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
        this.styleAttributes = new LinkedList<StyleAttribute>();
        this.classAttributes = new LinkedList<ClassAttribute>();
        this.otherAttributes = new LinkedList<Attribute>();
    }

    private TagInstance(Tag tag, int rangeFrom) {
        if (rangeFrom < 0) {
            throw new IllegalArgumentException(OUT_OF_RANGE);
        }
        this.tag = tag;
        this.tag.isSelfClosing = true;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeFrom;
        this.styleAttributes = new LinkedList<StyleAttribute>();
        this.classAttributes = new LinkedList<ClassAttribute>();
        this.otherAttributes = new LinkedList<Attribute>();
    }

    static TagInstance deserializeString(String in, boolean selfClosing) {
        int indexOfOtherAttr;
        String regexStyleOrClass = "(#style)|(#class)|(#attr)";
        String[] sTemp = in.split(regexStyleOrClass);
        String[] sTagProps = sTemp[0].split(";");
        TagInstance t = selfClosing ? new TagInstance(Tag.getInstance(sTagProps[0]), Integer.parseInt(sTagProps[1])) : new TagInstance(Tag.getInstance(sTagProps[0]), Integer.parseInt(sTagProps[1]), Integer.parseInt(sTagProps[2]));
        if (sTemp.length < 2 || "".equals(sTemp[1].trim())) {
            return t;
        }
        boolean hasStyle = in.contains("#style");
        boolean hasClass = in.contains("#class");
        boolean hasOtherAttr = in.contains("#attr");
        int indexOfStyle = 1;
        int indexOfClass = hasStyle ? indexOfStyle + 1 : indexOfStyle;
        int n = indexOfOtherAttr = hasClass ? indexOfClass + 1 : indexOfClass;
        if (hasStyle) {
            String[] sStyles;
            for (String s : sStyles = sTemp[indexOfStyle].split(";")) {
                t.addStyleAttribute(StyleAttribute.deserializeString(s));
            }
        }
        if (hasClass) {
            String[] sClass;
            for (String c : sClass = sTemp[indexOfClass].split(";")) {
                t.addClassAttribute(ClassAttribute.deserializeString(c));
            }
        }
        if (hasOtherAttr) {
            Pattern pattern = Pattern.compile(Attribute.ATTR_REGEX);
            Matcher m = pattern.matcher(sTemp[indexOfOtherAttr]);
            while (m.find()) {
                String sAttr = sTemp[indexOfOtherAttr].substring(m.start(), m.end());
                t.addAttribute(Attribute.deserializeString(sAttr));
            }
        }
        return t;
    }

    List<StyleAttribute> getStyleAttributes() {
        return this.styleAttributes;
    }

    List<ClassAttribute> getClassAttributes() {
        return this.classAttributes;
    }

    List<Attribute> getOtherAttributes() {
        return this.otherAttributes;
    }

    void setRangeTo(int to) {
        this.rangeTo = to;
    }

    public void addStyleAttribute(StyleAttribute s) {
        this.styleAttributes.add(s);
    }

    public void addAttribute(Attribute attribute) {
        this.otherAttributes.add(attribute);
    }

    void addClassAttribute(ClassAttribute c) {
        this.classAttributes.add(c);
    }

    String openingString() {
        StringBuilder openingString = new StringBuilder("<" + this.tagName().toString());
        if (!this.classAttributes.isEmpty()) {
            openingString.append(" ");
            openingString.append("class=\"");
            for (ClassAttribute c : this.classAttributes) {
                openingString.append(c.toString()).append(" ");
            }
            openingString.deleteCharAt(openingString.length() - 1);
            openingString.append("\"");
        }
        if (!this.styleAttributes.isEmpty()) {
            openingString.append(" ");
            openingString.append("style=\"");
            for (StyleAttribute s : this.styleAttributes) {
                openingString.append(s.toString()).append(";");
            }
            openingString.append("\"");
        }
        for (Attribute attr : this.otherAttributes) {
            openingString.append(" ");
            openingString.append(attr.key());
            openingString.append("=\"");
            openingString.append(attr.value());
            openingString.append("\"");
        }
        return openingString.append(">").toString();
    }

    Tag tagName() {
        return this.tag;
    }

    String closingString() {
        return this.tagName().closingString();
    }

    String serializeString() {
        StringBuilder s = new StringBuilder();
        s.append(this.tag.toString()).append(";").append(this.from());
        if (!this.tag.isSelfClosing) {
            s.append(";").append(this.to());
        }
        this.addAttributesToStringBuilder(s, this.styleAttributes, "#style");
        this.addAttributesToStringBuilder(s, this.classAttributes, "#class");
        this.addAttributesToStringBuilder(s, this.otherAttributes, "#attr");
        return s.toString();
    }

    int from() {
        return this.rangeFrom;
    }

    int to() {
        return this.rangeTo;
    }

    void findAttributes(String sTag) {
        Pattern p = Pattern.compile("(class=\"([a-z0-9]|-|\\s)+\")|(style=\"(\\{)?(([a-z0-9]|-)*\\:([a-z0-9]|\\s|-|\\)|\\(|,|#)*\\;)*(\\})?\")|(" + Attribute.ATTR_REGEX + ")");
        Matcher m = p.matcher(sTag);
        while (m.find()) {
            String sAttr = sTag.substring(m.start(), m.end());
            if (sAttr.startsWith("class")) {
                ClassAttribute.createClassAttribute(sAttr, this);
                continue;
            }
            if (sAttr.startsWith("style")) {
                StyleAttribute.createStyleAttribute(sAttr, this);
                continue;
            }
            Attribute.createAttribute(sAttr, this);
        }
    }

    private void addAttributesToStringBuilder(StringBuilder s, List<? extends StringSerializable> attributes, String attrTag) {
        if (!attributes.isEmpty()) {
            s.append(attrTag);
            for (StringSerializable stringSerializable : attributes) {
                s.append(stringSerializable.serializeString()).append(";");
            }
            s.deleteCharAt(s.length() - 1);
        }
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = 31 * result + this.styleAttributes.hashCode();
        result = 31 * result + this.classAttributes.hashCode();
        result = 31 * result + this.rangeFrom;
        result = 31 * result + this.rangeTo;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagInstance that = (TagInstance)o;
        if (this.rangeFrom != that.rangeFrom) {
            return false;
        }
        if (this.rangeTo != that.rangeTo) {
            return false;
        }
        if (this.tag != that.tag) {
            return false;
        }
        if (!this.styleAttributes.equals(that.styleAttributes)) {
            return false;
        }
        return this.classAttributes.equals(that.classAttributes);
    }

    public String toString() {
        String queue = (String)(this.styleAttributes.isEmpty() ? "" : "\n" + this.styleAttributes) + (String)(this.classAttributes.isEmpty() ? "" : "\n" + this.classAttributes) + (String)(this.otherAttributes.isEmpty() ? "" : "\n" + this.otherAttributes);
        return this.tagName().toString() + "; " + this.from() + "; " + this.to() + queue;
    }
}

