/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.python;

import java.io.OutputStream;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.GlobalGameScript;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionResult;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.exception.ScriptSkippedException;
import org.mini2Dx.miniscript.python.PythonScriptExecutorPool;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class PythonScriptExecutor
implements ScriptExecutor<PyCode> {
    private final PythonScriptExecutorPool executorPool;
    private final InteractiveInterpreter pythonInterpreter;

    public PythonScriptExecutor(PythonScriptExecutorPool executorPool) {
        this.executorPool = executorPool;
        this.pythonInterpreter = new InteractiveInterpreter();
        this.pythonInterpreter.setErr((OutputStream)System.err);
        this.pythonInterpreter.setOut((OutputStream)System.out);
    }

    public GameScript<PyCode> compile(String script) {
        return new GlobalGameScript((Object)this.pythonInterpreter.compile(script));
    }

    public ScriptExecutionResult execute(GameScript<PyCode> script, ScriptBindings bindings, boolean returnResult) throws Exception {
        PyCode pythonScript = (PyCode)script.getScript();
        for (String variableName : bindings.keySet()) {
            this.pythonInterpreter.set(variableName, bindings.get((Object)variableName));
        }
        try {
            this.pythonInterpreter.exec((PyObject)pythonScript);
        }
        catch (PyException e) {
            if (e.getCause() instanceof ScriptSkippedException) {
                throw new ScriptSkippedException();
            }
            throw e;
        }
        if (!returnResult) {
            return null;
        }
        ScriptExecutionResult executionResult = new ScriptExecutionResult(null);
        for (String variableName : bindings.keySet()) {
            executionResult.put(variableName, this.pythonInterpreter.get(variableName, Object.class));
        }
        return executionResult;
    }

    public void release() {
        try {
            this.pythonInterpreter.cleanup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.executorPool.release(this);
    }
}

