/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.http.ApacheHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.server.ForwardChainExpectation;
import org.mockserver.matchers.HttpResponseMatcher;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerClient {
    private static final Logger logger = LoggerFactory.getLogger(MockServerClient.class);
    protected final int port;
    private final String uriBase;
    private ApacheHttpClient apacheHttpClient;
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.port = port;
        this.uriBase = "http://" + host + ":" + port + (contextPath.length() > 0 && !contextPath.startsWith("/") ? "/" : "") + contextPath;
        this.apacheHttpClient = new ApacheHttpClient(false);
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times));
    }

    public MockServerClient dumpToLog() {
        this.dumpToLog(null);
        return this;
    }

    public MockServerClient dumpToLog(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/dumpToLog", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    public MockServerClient reset() {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/reset", "");
        return this;
    }

    public MockServerClient stop() {
        try {
            this.apacheHttpClient.sendPUTRequest(this.uriBase, "/stop", "");
        }
        catch (Exception e) {
            logger.debug("Failed to send stop request to proxy " + e.getMessage());
        }
        return this;
    }

    public MockServerClient clear(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/clear", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    protected void sendExpectation(Expectation expectation) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/expectation", expectation != null ? this.expectationSerializer.serialize(expectation) : "");
    }

    public MockServerClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/verifySequence", this.verificationSequenceSerializer.serialize(verificationSequence));
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public MockServerClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = new Verification().withRequest(httpRequest).withTimes(times);
        String result = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/verify", this.verificationSerializer.serialize(verification));
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        return this.retrieveAsExpectations(httpRequest, null);
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest, HttpResponse httpResponse) {
        Expectation[] expectations = this.expectationSerializer.deserializeArray(this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
        if (httpResponse != null) {
            ArrayList<Expectation> matchingExpectations = new ArrayList<Expectation>();
            HttpResponseMatcher httpResponseMatcher = new HttpResponseMatcher(httpResponse);
            for (Expectation expectation : expectations) {
                if (!httpResponseMatcher.matches(expectation.getHttpResponse(false))) continue;
                matchingExpectations.add(expectation);
            }
            expectations = matchingExpectations.toArray(new Expectation[matchingExpectations.size()]);
        }
        return expectations;
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        return this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
    }
}

