/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_websocket.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_websocket.WsNioChannelAssistant;
import org.noear.socketd.transport.java_websocket.WsNioServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerImpl
extends WebSocketServer {
    static final Logger log = LoggerFactory.getLogger(WebSocketServerImpl.class);
    private WsNioServer server;

    public WebSocketServerImpl(int port, WsNioServer server) {
        super(new InetSocketAddress(port));
        this.server = server;
    }

    public WebSocketServerImpl(String addr, int port, WsNioServer server) {
        super(new InetSocketAddress(addr, port));
        this.server = server;
    }

    private ChannelInternal getChannel(WebSocket conn) {
        ChannelInternal channel = (ChannelInternal)conn.getAttachment();
        if (channel == null) {
            channel = new ChannelDefault((Object)conn, (ChannelSupporter)this.server);
            conn.setAttachment((Object)channel);
        }
        return channel;
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        this.getChannel(conn);
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        ChannelInternal channel = this.getChannel(conn);
        this.server.getProcessor().onClose(channel);
    }

    public void onMessage(WebSocket conn, String message) {
        if (log.isWarnEnabled()) {
            log.warn("Server channel unsupported onMessage(String test)");
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer message) {
        try {
            ((WebSocketImpl)conn).updateLastPong();
            ChannelInternal channel = this.getChannel(conn);
            Frame frame = ((WsNioChannelAssistant)this.server.getAssistant()).read(message);
            if (frame != null) {
                this.server.getProcessor().onReceive(channel, frame);
            }
        }
        catch (Throwable e) {
            log.warn("WebSocket server onMessage error", e);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        try {
            ChannelInternal channel = this.getChannel(conn);
            if (channel != null) {
                this.server.getProcessor().onError(channel, (Throwable)ex);
            }
        }
        catch (Throwable e) {
            log.warn("WebSocket server onError error", e);
        }
    }

    public void onStart() {
        if (this.server.getConfig().getIdleTimeout() > 0L) {
            this.setConnectionLostTimeout((int)(this.server.getConfig().getIdleTimeout() / 1000L));
        } else {
            this.setConnectionLostTimeout(0);
        }
    }
}

