/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.stream.RequestStream;
import org.noear.socketd.transport.stream.SendStream;
import org.noear.socketd.transport.stream.SubscribeStream;
import org.noear.socketd.utils.RunUtils;
import org.noear.socketd.utils.StrUtils;

public class ClusterClientSession
implements ClientSession {
    private final List<ClientSession> sessionSet;
    private final AtomicInteger sessionRoundCounter;
    private final String sessionId;

    public ClusterClientSession(List<ClientSession> sessions) {
        this.sessionSet = sessions;
        this.sessionId = StrUtils.guid();
        this.sessionRoundCounter = new AtomicInteger(0);
    }

    public List<ClientSession> getSessionAll() {
        return Collections.unmodifiableList(this.sessionSet);
    }

    public ClientSession getSessionOne() {
        if (this.sessionSet.size() == 0) {
            throw new SocketdException("No session!");
        }
        if (this.sessionSet.size() == 1) {
            return this.sessionSet.get(0);
        }
        List sessions = this.sessionSet.stream().filter(s -> s.isValid()).collect(Collectors.toList());
        if (sessions.size() == 0) {
            throw new SocketdException("No session is available!");
        }
        if (sessions.size() == 1) {
            return (ClientSession)sessions.get(0);
        }
        int counter = this.sessionRoundCounter.incrementAndGet();
        int idx = counter % sessions.size();
        if (counter > 999999999) {
            this.sessionRoundCounter.set(0);
        }
        return (ClientSession)sessions.get(idx);
    }

    @Override
    public boolean isValid() {
        for (ClientSession session : this.sessionSet) {
            if (!session.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public void reconnect() throws IOException {
        for (ClientSession session : this.sessionSet) {
            if (session.isValid()) continue;
            session.reconnect();
        }
    }

    @Override
    public SendStream send(String event, Entity entity) throws IOException {
        ClientSession sender = this.getSessionOne();
        return sender.send(event, entity);
    }

    @Override
    public RequestStream sendAndRequest(String event, Entity entity, long timeout) throws IOException {
        ClientSession sender = this.getSessionOne();
        return sender.sendAndRequest(event, entity, timeout);
    }

    @Override
    public SubscribeStream sendAndSubscribe(String event, Entity entity, long timeout) throws IOException {
        ClientSession sender = this.getSessionOne();
        return sender.sendAndSubscribe(event, entity, timeout);
    }

    @Override
    public void close() throws IOException {
        for (ClientSession session : this.sessionSet) {
            RunUtils.runAndTry(session::close);
        }
    }
}

