/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.socketd.exception.SocketdChannelException;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.impl.ChannelBase;
import org.noear.socketd.transport.core.impl.HeartbeatHandlerDefault;
import org.noear.socketd.transport.core.impl.SessionDefault;
import org.noear.socketd.transport.stream.StreamInternal;
import org.noear.socketd.utils.RunUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannel
extends ChannelBase
implements Channel {
    private static final Logger log = LoggerFactory.getLogger(ClientChannel.class);
    private final ClientConnector connector;
    private final Session sessionShell;
    private ChannelInternal real;
    private HeartbeatHandler heartbeatHandler;
    private ScheduledFuture<?> heartbeatScheduledFuture;
    private AtomicBoolean isConnecting = new AtomicBoolean(false);

    public ClientChannel(ClientConnector connector) {
        super(connector.getConfig());
        this.connector = connector;
        this.sessionShell = new SessionDefault(this);
        this.heartbeatHandler = connector.getHeartbeatHandler() == null ? new HeartbeatHandlerDefault() : connector.getHeartbeatHandler();
        this.initHeartbeat();
    }

    private void initHeartbeat() {
        if (this.heartbeatScheduledFuture != null) {
            this.heartbeatScheduledFuture.cancel(false);
        }
        if (this.connector.autoReconnect()) {
            this.heartbeatScheduledFuture = RunUtils.scheduleWithFixedDelay(() -> {
                block2: {
                    try {
                        this.heartbeatHandle();
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn("Client channel heartbeat error", (Throwable)e);
                    }
                }
            }, this.connector.getHeartbeatInterval(), this.connector.getHeartbeatInterval());
        }
    }

    @Override
    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this.real.isValid();
    }

    @Override
    public int isClosed() {
        if (this.real == null) {
            return 0;
        }
        return this.real.isClosed();
    }

    @Override
    public long getLiveTime() {
        if (this.real == null) {
            return 0L;
        }
        return this.real.getLiveTime();
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getRemoteAddress();
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        if (this.real == null) {
            return null;
        }
        return this.real.getLocalAddress();
    }

    private void heartbeatHandle() throws IOException {
        if (this.real != null) {
            if (this.real.getHandshake() == null) {
                return;
            }
            if (Asserts.isClosedAndEnd(this.real)) {
                if (log.isDebugEnabled()) {
                    log.debug("Client channel is closed (pause heartbeat), sessionId={}", (Object)this.getSession().sessionId());
                }
                return;
            }
        }
        try {
            this.internalCheck();
            this.heartbeatHandler.heartbeat(this.getSession());
        }
        catch (SocketdException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.internalCloseIfError();
            }
            throw new SocketdChannelException("Client channel heartbeat failed", e);
        }
    }

    @Override
    public void send(Frame frame, StreamInternal stream) throws IOException {
        Asserts.assertClosedAndEnd(this.real);
        try {
            this.internalCheck();
            if (this.real == null) {
                throw new SocketdChannelException("Client channel is not connected");
            }
            this.real.send(frame, stream);
        }
        catch (SocketdException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.connector.autoReconnect()) {
                this.internalCloseIfError();
            }
            throw new SocketdChannelException("Client channel send failed", e);
        }
    }

    @Override
    public void retrieve(Frame frame, StreamInternal stream) {
        this.real.retrieve(frame, stream);
    }

    @Override
    public void reconnect() throws IOException {
        this.initHeartbeat();
        this.internalCheck();
    }

    @Override
    public void onError(Throwable error) {
        this.real.onError(error);
    }

    @Override
    public void close(int code) {
        RunUtils.runAndTry(() -> this.heartbeatScheduledFuture.cancel(true));
        RunUtils.runAndTry(() -> this.connector.close());
        RunUtils.runAndTry(() -> this.real.close(code));
    }

    @Override
    public Session getSession() {
        return this.sessionShell;
    }

    public void connect() throws IOException {
        if (this.isConnecting.get()) {
            return;
        }
        this.isConnecting.set(true);
        try {
            if (this.real != null) {
                this.real.close(22);
            }
            this.real = this.connector.connect();
            this.real.setSession(this.sessionShell);
            this.setHandshake(this.real.getHandshake());
        }
        finally {
            this.isConnecting.set(false);
        }
    }

    private void internalCloseIfError() {
        if (this.real != null) {
            this.real.close(21);
            this.real = null;
        }
    }

    private boolean internalCheck() throws IOException {
        if (this.real == null || !this.real.isValid()) {
            this.connect();
            return true;
        }
        return false;
    }
}

