/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.fragment;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.FragmentAggregator;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.fragment.FragmentAggregatorDefault;
import org.noear.socketd.transport.stream.StreamInternal;
import org.noear.socketd.utils.IoConsumer;

public abstract class FragmentHandlerBase
implements FragmentHandler {
    @Override
    public void spliFragment(Channel channel, StreamInternal stream, MessageInternal message, IoConsumer<Entity> consumer) throws IOException {
        if (message.dataSize() > channel.getConfig().getFragmentSize()) {
            int fragmentTotal = message.dataSize() / channel.getConfig().getFragmentSize();
            if (message.dataSize() % channel.getConfig().getFragmentSize() > 0) {
                ++fragmentTotal;
            }
            int fragmentIndex = 0;
            while (true) {
                ++fragmentIndex;
                ByteBuffer dataBuffer = this.readFragmentData(message.data(), channel.getConfig().getFragmentSize());
                if (dataBuffer == null || dataBuffer.limit() == 0) {
                    return;
                }
                EntityDefault fragmentEntity = new EntityDefault().dataSet(dataBuffer);
                if (fragmentIndex == 1) {
                    fragmentEntity.metaMapPut(message.metaMap());
                }
                fragmentEntity.metaPut("Data-Fragment-Idx", String.valueOf(fragmentIndex));
                fragmentEntity.metaPut("Data-Fragment-Total", String.valueOf(fragmentTotal));
                consumer.accept(fragmentEntity);
                if (stream == null) continue;
                stream.onProgress(true, fragmentIndex, fragmentTotal);
            }
        }
        consumer.accept(message);
        if (stream != null) {
            stream.onProgress(true, 1, 1);
        }
    }

    @Override
    public Frame aggrFragment(Channel channel, int fragmentIndex, MessageInternal message) throws IOException {
        FragmentAggregator aggregator = (FragmentAggregator)channel.getAttachment(message.sid());
        if (aggregator == null) {
            aggregator = new FragmentAggregatorDefault(message);
            channel.putAttachment(aggregator.getSid(), aggregator);
        }
        aggregator.add(fragmentIndex, message);
        if (aggregator.getDataLength() > aggregator.getDataStreamSize()) {
            return null;
        }
        channel.putAttachment(message.sid(), null);
        return aggregator.get();
    }

    protected abstract FragmentAggregator createFragmentAggregator(MessageInternal var1) throws IOException;

    protected ByteBuffer readFragmentData(ByteBuffer ins, int maxSize) {
        int size = 0;
        size = ins.remaining() > maxSize ? maxSize : ins.remaining();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        ins.get(bytes);
        return ByteBuffer.wrap(bytes);
    }
}

