/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.noear.socketd.transport.core.Asserts;
import org.noear.socketd.transport.core.Codec;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.FragmentHandler;
import org.noear.socketd.transport.core.IdGenerator;
import org.noear.socketd.transport.core.codec.CodecDefault;
import org.noear.socketd.transport.core.fragment.FragmentHandlerDefault;
import org.noear.socketd.transport.core.identifier.GuidGenerator;
import org.noear.socketd.transport.stream.StreamManger;
import org.noear.socketd.transport.stream.impl.StreamMangerDefault;
import org.noear.socketd.utils.NamedThreadFactory;

public abstract class ConfigBase<T extends Config>
implements Config {
    private final boolean clientMode;
    private final StreamManger streamManger;
    private final Codec codec;
    private boolean sequenceMode;
    private IdGenerator idGenerator;
    private FragmentHandler fragmentHandler;
    private int fragmentSize;
    private SSLContext sslContext;
    private volatile ExecutorService channelExecutor;
    protected Charset charset;
    protected int coreThreads;
    protected int maxThreads;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected long idleTimeout;
    protected long requestTimeout;
    protected long streamTimeout;
    protected int maxUdpSize;
    private ReentrantLock EXECUTOR_LOCK = new ReentrantLock();

    public ConfigBase(boolean clientMode) {
        this.clientMode = clientMode;
        this.sequenceMode = false;
        this.streamManger = new StreamMangerDefault(this);
        this.codec = new CodecDefault(this);
        this.charset = StandardCharsets.UTF_8;
        this.idGenerator = new GuidGenerator();
        this.fragmentHandler = new FragmentHandlerDefault();
        this.fragmentSize = 0x1000000;
        this.coreThreads = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        this.maxThreads = this.coreThreads * 4;
        this.readBufferSize = 512;
        this.writeBufferSize = 512;
        this.idleTimeout = 60000L;
        this.requestTimeout = 10000L;
        this.streamTimeout = 0x6DDD00L;
        this.maxUdpSize = 2048;
    }

    @Override
    public boolean clientMode() {
        return this.clientMode;
    }

    @Override
    public boolean sequenceMode() {
        return this.sequenceMode;
    }

    public T sequenceMode(boolean sequenceMode) {
        this.sequenceMode = sequenceMode;
        return (T)this;
    }

    @Override
    public StreamManger getStreamManger() {
        return this.streamManger;
    }

    @Override
    public String getRoleName() {
        return this.clientMode() ? "Client" : "Server";
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public T charset(Charset charset) {
        this.charset = charset;
        return (T)this;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public FragmentHandler getFragmentHandler() {
        return this.fragmentHandler;
    }

    public T fragmentHandler(FragmentHandler fragmentHandler) {
        Asserts.assertNull("fragmentHandler", fragmentHandler);
        this.fragmentHandler = fragmentHandler;
        return (T)this;
    }

    @Override
    public int getFragmentSize() {
        return this.fragmentSize;
    }

    public T fragmentSize(int fragmentSize) {
        if (fragmentSize > 0x1000000) {
            throw new IllegalArgumentException("The parameter fragmentSize cannot > 16m");
        }
        if (fragmentSize < 1024) {
            throw new IllegalArgumentException("The parameter fragmentSize cannot < 1k");
        }
        this.fragmentSize = fragmentSize;
        return (T)this;
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public T idGenerator(IdGenerator idGenerator) {
        Asserts.assertNull("idGenerator", idGenerator);
        this.idGenerator = idGenerator;
        return (T)this;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public T sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return (T)this;
    }

    @Override
    public ExecutorService getChannelExecutor() {
        if (this.channelExecutor == null) {
            this.EXECUTOR_LOCK.lock();
            try {
                if (this.channelExecutor == null) {
                    int nThreads = this.clientMode() ? this.coreThreads : this.maxThreads;
                    this.channelExecutor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Socketd-channelExecutor-"));
                }
            }
            finally {
                this.EXECUTOR_LOCK.unlock();
            }
        }
        return this.channelExecutor;
    }

    public T channelExecutor(ExecutorService channelExecutor) {
        ExecutorService odl = this.channelExecutor;
        this.channelExecutor = channelExecutor;
        if (odl != null) {
            odl.shutdown();
        }
        return (T)this;
    }

    @Override
    public int getCoreThreads() {
        return this.coreThreads;
    }

    public T coreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        this.maxThreads = coreThreads * 4;
        return (T)this;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public T maxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return (T)this;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public T readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return (T)this;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public T writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return (T)this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public T idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return (T)this;
    }

    @Override
    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public T requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)this;
    }

    @Override
    public long getStreamTimeout() {
        return this.streamTimeout;
    }

    public T streamTimeout(long streamTimeout) {
        this.streamTimeout = streamTimeout;
        return (T)this;
    }

    @Override
    public int getMaxUdpSize() {
        return this.maxUdpSize;
    }

    public T maxUdpSize(int maxUdpSize) {
        this.maxUdpSize = maxUdpSize;
        return (T)this;
    }
}

