/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.io.IOException;
import org.noear.socketd.exception.SocketdAlarmException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.impl.HandshakeDefault;
import org.noear.socketd.transport.core.listener.SimpleListener;
import org.noear.socketd.transport.stream.StreamInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorDefault
implements Processor {
    private static Logger log = LoggerFactory.getLogger(ProcessorDefault.class);
    private Listener listener = new SimpleListener();

    @Override
    public void setListener(Listener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    @Override
    public void onReceive(ChannelInternal channel, Frame frame) {
        if (log.isDebugEnabled()) {
            if (channel.getConfig().clientMode()) {
                log.debug("C-REV:{}", (Object)frame);
            } else {
                log.debug("S-REV:{}", (Object)frame);
            }
        }
        if (frame.flag() == 10) {
            HandshakeDefault handshake = new HandshakeDefault(frame.message());
            channel.setHandshake(handshake);
            channel.onOpenFuture((r, e) -> {
                if (e == null) {
                    if (channel.isValid()) {
                        try {
                            channel.sendConnack(frame.message());
                        }
                        catch (Throwable err) {
                            this.onError(channel, err);
                        }
                    }
                } else if (channel.isValid()) {
                    channel.close(21);
                    this.onCloseInternal(channel);
                }
            });
            this.onOpen(channel);
        } else if (frame.flag() == 11) {
            HandshakeDefault handshake = new HandshakeDefault(frame.message());
            channel.setHandshake(handshake);
            this.onOpen(channel);
        } else {
            if (channel.getHandshake() == null) {
                channel.close(11);
                if (frame.flag() == 30) {
                    throw new SocketdConnectionException("Connection request was rejected");
                }
                if (log.isWarnEnabled()) {
                    log.warn("{} channel handshake is null, sessionId={}", (Object)channel.getConfig().getRoleName(), (Object)channel.getSession().sessionId());
                }
                return;
            }
            channel.setLiveTimeAsNow();
            try {
                switch (frame.flag()) {
                    case 20: {
                        channel.sendPong();
                        break;
                    }
                    case 21: {
                        break;
                    }
                    case 30: {
                        channel.close(11);
                        this.onCloseInternal(channel);
                        break;
                    }
                    case 31: {
                        SocketdAlarmException exception = new SocketdAlarmException(frame.message());
                        StreamInternal stream = channel.getConfig().getStreamManger().getStream(frame.message().sid());
                        if (stream == null) {
                            this.onError(channel, exception);
                            break;
                        }
                        channel.getConfig().getStreamManger().removeStream(frame.message().sid());
                        stream.onError(exception);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: {
                        this.onReceiveDo(channel, frame, false);
                        break;
                    }
                    case 48: 
                    case 49: {
                        this.onReceiveDo(channel, frame, true);
                        break;
                    }
                    default: {
                        channel.close(12);
                        this.onCloseInternal(channel);
                        break;
                    }
                }
            }
            catch (Throwable e2) {
                this.onError(channel, e2);
            }
        }
    }

    private void onReceiveDo(ChannelInternal channel, Frame frame, boolean isReply) throws IOException {
        String fragmentIdxStr;
        StreamInternal stream = null;
        int streamIndex = 0;
        int streamTotal = 1;
        if (isReply) {
            stream = channel.getStream(frame.message().sid());
        }
        if (channel.getConfig().getFragmentHandler().aggrEnable() && (fragmentIdxStr = frame.message().meta("Data-Fragment-Idx")) != null) {
            streamIndex = Integer.parseInt(fragmentIdxStr);
            Frame frameNew = channel.getConfig().getFragmentHandler().aggrFragment(channel, streamIndex, frame.message());
            if (stream != null) {
                streamTotal = Integer.parseInt(frame.message().metaOrDefault("Data-Fragment-Total", "0"));
            }
            if (frameNew == null) {
                if (stream != null) {
                    stream.onProgress(false, streamIndex, streamTotal);
                }
                return;
            }
            frame = frameNew;
        }
        if (isReply) {
            if (stream != null) {
                stream.onProgress(false, streamIndex, streamTotal);
            }
            channel.retrieve(frame, stream);
        } else {
            this.onMessage(channel, frame.message());
        }
    }

    @Override
    public void onOpen(ChannelInternal channel) {
        channel.getConfig().getChannelExecutor().submit(() -> {
            try {
                this.listener.onOpen(channel.getSession());
                channel.doOpenFuture(true, null);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("{} channel listener onOpen error", (Object)channel.getConfig().getRoleName(), (Object)e);
                }
                channel.doOpenFuture(false, e);
            }
        });
    }

    @Override
    public void onMessage(ChannelInternal channel, Message message) {
        channel.getConfig().getChannelExecutor().submit(() -> {
            try {
                this.listener.onMessage(channel.getSession(), message);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("{} channel listener onMessage error", (Object)channel.getConfig().getRoleName(), (Object)e);
                }
                this.onError(channel, e);
            }
        });
    }

    @Override
    public void onClose(ChannelInternal channel) {
        if (channel.isClosed() == 0) {
            this.onCloseInternal(channel);
        }
    }

    private void onCloseInternal(ChannelInternal channel) {
        this.listener.onClose(channel.getSession());
    }

    @Override
    public void onError(ChannelInternal channel, Throwable error) {
        this.listener.onError(channel.getSession(), error);
    }
}

