/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.IOMatrixLoader;
import org.opencompare.api.java.io.PCMLoader;

public class HTMLLoader
implements PCMLoader {
    private PCMFactory factory;
    private boolean productsAsLines;
    private Map<Integer, Feature> features;

    public HTMLLoader(PCMFactory factory) {
        this(factory, true);
    }

    public HTMLLoader(PCMFactory factory, boolean productsAsLines) {
        this.factory = factory;
        this.productsAsLines = productsAsLines;
    }

    public static List<IOMatrix> createMatrices(Document doc) {
        ArrayList<IOMatrix> matrices = new ArrayList<IOMatrix>();
        String pageName = doc.head().getElementsByTag("title").text();
        int indice = 0;
        for (Element table : doc.getElementsByTag("table")) {
            IOMatrix matrix = new IOMatrix().setName(pageName + " #" + indice);
            int i = 0;
            for (Element line : table.getElementsByTag("tr")) {
                int j = 0;
                for (Element column : line.getAllElements()) {
                    if (!column.tag().getName().equals("th") && !column.tag().getName().equals("td")) continue;
                    if (matrix.getCell(i, j) != null) {
                        ++j;
                    }
                    int rowspan = 1;
                    int colspan = 1;
                    if (column.attributes().get("rowspan") != "") {
                        rowspan = Integer.valueOf(column.attributes().get("rowspan"));
                    }
                    if (column.attributes().get("colspan") != "") {
                        colspan = Integer.valueOf(column.attributes().get("colspan"));
                    }
                    matrix.setCell(new IOCell(column.text()), i, j, rowspan, colspan);
                    j += colspan;
                }
                ++i;
            }
            matrices.add(matrix);
            ++indice;
        }
        return matrices;
    }

    @Override
    public List<PCMContainer> load(String pcm) {
        ArrayList<PCMContainer> containers = new ArrayList();
        Document doc = Jsoup.parse((String)pcm);
        List<IOMatrix> matrices = HTMLLoader.createMatrices(doc);
        containers = this.load(matrices.get(0));
        return containers;
    }

    @Override
    public List<PCMContainer> load(File file) throws IOException {
        Document doc = Jsoup.parse((File)file, (String)"UTF-8");
        ArrayList<PCMContainer> containers = new ArrayList<PCMContainer>();
        for (IOMatrix matrix : HTMLLoader.createMatrices(doc)) {
            containers.add(this.load(matrix).get(0));
        }
        return containers;
    }

    public List<PCMContainer> load(IOMatrix matrix) {
        return new IOMatrixLoader(this.factory, this.productsAsLines).load(matrix);
    }
}

