/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencompare.api.java.io.IOCell;
import org.opencompare.api.java.util.Pair;

public class IOMatrix<T extends IOCell> {
    protected String name = "";
    protected int maxRow = 0;
    protected int maxColumn = 0;
    protected Map<Pair<Integer, Integer>, T> cells = new HashMap<Pair<Integer, Integer>, T>();

    public String getName() {
        return this.name;
    }

    public IOMatrix setName(String name) {
        this.name = name;
        return this;
    }

    public T getCell(int row, int column) {
        return (T)((IOCell)this.cells.get(new Pair<Integer, Integer>(row, column)));
    }

    public IOMatrix<T> setCell(T cell, int row, int column) {
        this.cells.put(new Pair<Integer, Integer>(row, column), cell);
        this.maxRow = this.maxRow < row + ((IOCell)cell).getRowspan() - 1 ? row + ((IOCell)cell).getRowspan() - 1 : this.maxRow;
        this.maxColumn = this.maxColumn < column + ((IOCell)cell).getColspan() - 1 ? column + ((IOCell)cell).getColspan() - 1 : this.maxColumn;
        return this;
    }

    public int getNumberOfRows() {
        return this.maxRow + 1;
    }

    public int getNumberOfColumns() {
        return this.maxColumn + 1;
    }

    public boolean isPositionOccupied(int row, int column) {
        T cell;
        if (this.getCell(row, column) != null) {
            return true;
        }
        for (int i = row; i >= 0; --i) {
            cell = this.getCell(i, column);
            if (cell != null && i + ((IOCell)cell).getRowspan() > row) {
                return true;
            }
            if (cell != null) break;
        }
        for (int j = column; j >= 0; --j) {
            cell = this.getCell(row, j);
            if (cell != null && j + ((IOCell)cell).getColspan() > column) {
                return true;
            }
            if (cell != null) break;
        }
        return false;
    }

    public void transpose() {
        HashMap<Pair<Integer, Integer>, T> transposedCells = new HashMap<Pair<Integer, Integer>, T>();
        for (Map.Entry<Pair<Integer, Integer>, T> entry : this.cells.entrySet()) {
            IOCell cell = (IOCell)entry.getValue();
            int tempRowspan = cell.rowspan;
            cell.rowspan = cell.colspan;
            cell.colspan = tempRowspan;
            transposedCells.put(new Pair(entry.getKey()._2, entry.getKey()._1), entry.getValue());
        }
        int tempMaxRow = this.maxRow;
        this.maxRow = this.maxColumn;
        this.maxColumn = tempMaxRow;
        this.cells = transposedCells;
    }

    public void flattenCells() {
        for (int row = 0; row < this.getNumberOfRows(); ++row) {
            for (int column = 0; column < this.getNumberOfColumns(); ++column) {
                IOCell cell = (IOCell)this.cells.get(new Pair<Integer, Integer>(row, column));
                if (cell == null) continue;
                for (int rowOffset = 0; rowOffset < cell.getRowspan(); ++rowOffset) {
                    for (int columnOffset = 0; columnOffset < cell.getColspan(); ++columnOffset) {
                        this.cells.put(new Pair<Integer, Integer>(row + rowOffset, column + columnOffset), cell);
                    }
                }
                cell.setRowspan(1);
                cell.setColspan(1);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                result.append(i + "," + j + ":");
                T cell = this.getCell(i, j);
                if (cell != null) {
                    result.append(((IOCell)cell).getContent());
                } else {
                    result.append("");
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof IOMatrix) {
            try {
                IOMatrix matrix = (IOMatrix)obj;
                if (!this.name.equals(matrix.getName())) {
                    return false;
                }
                for (Pair<Integer, Integer> pos : this.cells.keySet()) {
                    T cell2;
                    T cell1 = this.getCell((Integer)pos._1, (Integer)pos._2);
                    if (((IOCell)cell1).equals(cell2 = matrix.getCell((Integer)pos._1, (Integer)pos._2))) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public List<String[]> toList() {
        ArrayList<String[]> matrix = new ArrayList<String[]>(this.getNumberOfRows());
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            String[] line = new String[this.getNumberOfColumns()];
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                line[j] = ((IOCell)this.getCell(i, j)).getContent();
            }
            matrix.add(line);
        }
        return matrix;
    }
}

