/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.util;

import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdMeterSubTypeSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdTypeSerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterMeterBandSubType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public abstract class ExperimenterSerializerKeyFactory {
    public static ExperimenterIdSerializerKey<ExperimenterDataOfChoice> createExperimenterMessageSerializerKey(Uint8 msgVersion, Uint32 experimenterId, long type) {
        return new ExperimenterIdTypeSerializerKey(msgVersion, experimenterId, type, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdSerializerKey<ExperimenterDataOfChoice> createMultipartRequestSerializerKey(Uint8 msgVersion, Uint32 experimenterId, long type) {
        return new ExperimenterIdTypeSerializerKey(msgVersion, experimenterId, type, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdSerializerKey<TableFeatureProperties> createMultipartRequestTFSerializerKey(Uint8 msgVersion, Uint32 experimenterId) {
        return new ExperimenterIdSerializerKey(msgVersion, experimenterId, TableFeatureProperties.class);
    }

    public static ExperimenterIdSerializerKey<MeterBandExperimenterCase> createMeterBandSerializerKey(Uint8 msgVersion, Uint32 experimenterId) {
        return new ExperimenterIdMeterSubTypeSerializerKey(msgVersion, experimenterId, MeterBandExperimenterCase.class, null);
    }

    public static ExperimenterIdSerializerKey<MeterBandExperimenterCase> createMeterBandSerializerKey(Uint8 msgVersion, Uint32 experimenterId, Class<? extends ExperimenterMeterBandSubType> meterSubType) {
        return new ExperimenterIdMeterSubTypeSerializerKey(msgVersion, experimenterId, MeterBandExperimenterCase.class, meterSubType);
    }
}

