/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.util;

import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdTypeDeserializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class ExperimenterDeserializerKeyFactory {
    private ExperimenterDeserializerKeyFactory() {
    }

    public static ExperimenterIdDeserializerKey createExperimenterErrorDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, ErrorMessage.class);
    }

    public static ExperimenterIdTypeDeserializerKey createExperimenterMessageDeserializerKey(Uint8 version, Uint32 experimenterId, long type) {
        return new ExperimenterIdTypeDeserializerKey(version, experimenterId, type, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdDeserializerKey createVendorMessageDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdTypeDeserializerKey createMultipartReplyMessageDeserializerKey(Uint8 version, Uint32 experimenterId, long type) {
        return new ExperimenterIdTypeDeserializerKey(version, experimenterId, type, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdDeserializerKey createMultipartReplyVendorMessageDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, ExperimenterDataOfChoice.class);
    }

    public static ExperimenterIdDeserializerKey createMultipartReplyTFDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, TableFeatureProperties.class);
    }

    public static ExperimenterIdDeserializerKey createQueuePropertyDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, QueueProperty.class);
    }

    public static ExperimenterIdDeserializerKey createMeterBandDeserializerKey(Uint8 version, Uint32 experimenterId) {
        return new ExperimenterIdDeserializerKey(version, experimenterId, MeterBandExperimenterCase.class);
    }
}

