/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.IetfYangUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public abstract class ByteBufUtils {
    public static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    public static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Splitter HEXSTRING_SPLITTER = Splitter.onPattern((String)"\\s+").omitEmptyStrings();
    private static final Splitter HEXSTRING_NOSPACE_SPLITTER = Splitter.onPattern((String)"(?<=\\G.{2})").omitEmptyStrings();

    private ByteBufUtils() {
    }

    public static String byteBufToHexString(ByteBuf bb) {
        StringBuilder sb = new StringBuilder();
        for (int i = bb.readerIndex(); i < bb.readerIndex() + bb.readableBytes(); ++i) {
            sb.append(String.format(" %02x", bb.getUnsignedByte(i)));
        }
        return sb.toString().trim();
    }

    public static byte[] hexStringToBytes(String hexSrc) {
        return ByteBufUtils.hexStringToBytes(hexSrc, true);
    }

    public static byte[] hexStringToBytes(String hexSrc, boolean withSpaces) {
        Splitter splitter = withSpaces ? HEXSTRING_SPLITTER : HEXSTRING_NOSPACE_SPLITTER;
        ArrayList byteChips = Lists.newArrayList((Iterable)splitter.split((CharSequence)hexSrc));
        byte[] result = new byte[byteChips.size()];
        int index = 0;
        for (String chip : byteChips) {
            result[index] = (byte)Short.parseShort(chip, 16);
            ++index;
        }
        return result;
    }

    public static ByteBuf hexStringToByteBuf(String hexSrc) {
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ByteBufUtils.hexStringToByteBuf(hexSrc, out);
        return out;
    }

    public static void hexStringToByteBuf(String hexSrc, ByteBuf out) {
        out.writeBytes(ByteBufUtils.hexStringToBytes(hexSrc));
    }

    public static <E extends OfHeader> void writeOFHeader(byte msgType, E message, ByteBuf out, int length) {
        out.writeByte((int)message.getVersion().toJava());
        out.writeByte((int)msgType);
        out.writeShort(length);
        out.writeInt(message.getXid().intValue());
    }

    public static void updateOFHeaderLength(ByteBuf out) {
        out.setShort(2, out.readableBytes());
    }

    public static void updateOFHeaderLength(ByteBuf out, int index) {
        out.setShort(index + 2, out.writerIndex() - index);
    }

    public static int fillBitMaskFromMap(Map<Integer, Boolean> booleanMap) {
        int bitmask = 0;
        for (Map.Entry<Integer, Boolean> iterator : booleanMap.entrySet()) {
            if (iterator.getValue() == null || !iterator.getValue().booleanValue()) continue;
            bitmask |= 1 << iterator.getKey();
        }
        return bitmask;
    }

    public static int fillBitMask(int offset, boolean ... values) {
        int bitmask = 0;
        int index = offset;
        for (boolean v : values) {
            if (v) {
                bitmask |= 1 << index;
            }
            ++index;
        }
        return bitmask;
    }

    public static int[] fillBitMaskFromList(List<Boolean> booleanList) {
        int index = 0;
        int arrayIndex = 0;
        int[] bitmask = booleanList.size() % 32 != 0 ? new int[booleanList.size() / 32 + 1] : new int[booleanList.size() / 32];
        for (Boolean currElement : booleanList) {
            if (currElement != null && currElement.booleanValue()) {
                int n = arrayIndex;
                bitmask[n] = bitmask[n] | 1 << index;
            }
            arrayIndex = ++index / 32;
        }
        return bitmask;
    }

    public static String bytesToHexString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        for (byte element : array) {
            sb.append(String.format(" %02x", element));
        }
        return sb.toString().trim();
    }

    public static String decodeNullTerminatedString(ByteBuf rawMessage, int length) {
        byte[] name = new byte[length];
        rawMessage.readBytes(name);
        return new String(name, StandardCharsets.UTF_8).trim();
    }

    public static Ipv4Address readIetfIpv4Address(ByteBuf buf) {
        return IetfInetUtil.ipv4AddressFor((int)buf.readInt());
    }

    public static Ipv6Address readIetfIpv6Address(ByteBuf buf) {
        byte[] tmp = new byte[16];
        buf.readBytes(tmp);
        return IetfInetUtil.ipv6AddressFor((byte[])tmp);
    }

    public static MacAddress readIetfMacAddress(ByteBuf buf) {
        byte[] tmp = new byte[6];
        buf.readBytes(tmp);
        return IetfYangUtil.macAddressFor((byte[])tmp);
    }

    public static byte[] serializeList(List<Short> list) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(list.size() * 2);
        for (Short shortValue : list) {
            byteBuffer.putShort(shortValue);
        }
        return byteBuffer.array();
    }
}

