/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.images.firstimage;

import java.io.IOException;
import java.net.URL;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.hershey.HersheyFont;
import org.openimaj.math.geometry.shape.Ellipse;
import org.openimaj.math.geometry.shape.Shape;

public class App {
    public static void main(String[] args) throws IOException {
        MBFImage image = ImageUtilities.readMBF((URL)new URL("http://dl.dropbox.com/u/8705593/sinaface.jpg"));
        System.out.println(image.colourSpace);
        DisplayUtilities.display((Image)image);
        DisplayUtilities.display((Image)image.getBand(0), (String)"Red Channel");
        MBFImage clone = (MBFImage)image.clone();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                ((FImage)clone.getBand((int)1)).pixels[y][x] = 0.0f;
                ((FImage)clone.getBand((int)2)).pixels[y][x] = 0.0f;
            }
        }
        DisplayUtilities.display((Image)clone);
        image.processInplace((SinglebandImageProcessor)new CannyEdgeDetector());
        DisplayUtilities.display((Image)image);
        image.drawShapeFilled((Shape)new Ellipse(700.0, 450.0, 20.0, 10.0, 0.0), (Object)RGBColour.WHITE);
        image.drawShapeFilled((Shape)new Ellipse(650.0, 425.0, 25.0, 12.0, 0.0), (Object)RGBColour.WHITE);
        image.drawShapeFilled((Shape)new Ellipse(600.0, 380.0, 30.0, 15.0, 0.0), (Object)RGBColour.WHITE);
        image.drawShapeFilled((Shape)new Ellipse(500.0, 300.0, 100.0, 70.0, 0.0), (Object)RGBColour.WHITE);
        image.drawText("OpenIMAJ is", 425, 300, (Font)HersheyFont.ASTROLOGY, 20, (Object)RGBColour.BLACK);
        image.drawText("Awesome", 425, 330, (Font)HersheyFont.ASTROLOGY, 20, (Object)RGBColour.BLACK);
        DisplayUtilities.display((Image)image);
    }
}

