/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.images.siftmatch;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.matcher.BasicMatcher;
import org.openimaj.feature.local.matcher.FastBasicKeypointMatcher;
import org.openimaj.feature.local.matcher.LocalFeatureMatcher;
import org.openimaj.feature.local.matcher.MatchingUtilities;
import org.openimaj.feature.local.matcher.consistent.ConsistentLocalFeatureMatcher2d;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.feature.local.engine.DoGSIFTEngine;
import org.openimaj.math.geometry.transforms.estimation.RobustAffineTransformEstimator;
import org.openimaj.math.model.fit.RANSAC;
import org.openimaj.math.model.fit.RobustModelFitting;

public class App {
    public static void main(String[] args) throws IOException {
        MBFImage query = ImageUtilities.readMBF((URL)new URL("http://dl.dropbox.com/u/8705593/query.jpg"));
        MBFImage target = ImageUtilities.readMBF((URL)new URL("http://dl.dropbox.com/u/8705593/target.jpg"));
        DoGSIFTEngine engine = new DoGSIFTEngine();
        LocalFeatureList queryKeypoints = engine.findFeatures(query.flatten());
        LocalFeatureList targetKeypoints = engine.findFeatures(target.flatten());
        BasicMatcher matcher = new BasicMatcher(80);
        matcher.setModelFeatures((List)queryKeypoints);
        matcher.findMatches((List)targetKeypoints);
        MBFImage basicMatches = (MBFImage)MatchingUtilities.drawMatches((Image)query, (Image)target, (List)matcher.getMatches(), (Object)RGBColour.RED);
        DisplayUtilities.display((Image)basicMatches);
        RobustAffineTransformEstimator modelFitter = new RobustAffineTransformEstimator(5.0, 1500, (RANSAC.StoppingCondition)new RANSAC.PercentageInliersStoppingCondition(0.5));
        matcher = new ConsistentLocalFeatureMatcher2d((LocalFeatureMatcher)new FastBasicKeypointMatcher(8), (RobustModelFitting)modelFitter);
        matcher.setModelFeatures((List)queryKeypoints);
        matcher.findMatches((List)targetKeypoints);
        MBFImage consistentMatches = (MBFImage)MatchingUtilities.drawMatches((Image)query, (Image)target, (List)matcher.getMatches(), (Object)RGBColour.RED);
        DisplayUtilities.display((Image)consistentMatches);
        target.drawShape(query.getBounds().transform(modelFitter.getModel().getTransform().inverse()), 3, (Object)RGBColour.BLUE);
        DisplayUtilities.display((Image)target);
    }
}

