/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.adv.advanced.parallel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.experiment.dataset.sampling.GroupSampler;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.MultiBandImage;
import org.openimaj.image.annotation.evaluation.datasets.Caltech101;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.time.Timer;
import org.openimaj.util.function.Operation;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.Partitioner;
import org.openimaj.util.parallel.partition.RangePartitioner;

public class App {
    public static void main(String[] args) throws IOException {
        Parallel.forIndex((int)0, (int)10, (int)1, (Operation)new Operation<Integer>(){

            public void perform(Integer i) {
                System.out.println(i);
            }
        });
        VFSGroupDataset allImages = Caltech101.getImages((InputStreamObjectReader)ImageUtilities.MBFIMAGE_READER);
        GroupedDataset images = GroupSampler.sample((GroupedDataset)allImages, (int)8, (boolean)false);
        ArrayList<MBFImage> output = new ArrayList<MBFImage>();
        final ResizeProcessor resize = new ResizeProcessor(200);
        Timer t1 = Timer.timer();
        for (Object clzImages : images.values()) {
            MBFImage current = new MBFImage(200, 200, ColourSpace.RGB);
            Iterator iterator = clzImages.iterator();
            while (iterator.hasNext()) {
                MBFImage i = (MBFImage)iterator.next();
                MBFImage tmp = new MBFImage(200, 200, ColourSpace.RGB);
                tmp.fill(RGBColour.WHITE);
                MBFImage small = (MBFImage)((MBFImage)i.process((SinglebandImageProcessor)resize)).normalise();
                int x = (200 - small.getWidth()) / 2;
                int y = (200 - small.getHeight()) / 2;
                tmp.drawImage((Image)small, x, y);
                current.addInplace((MultiBandImage)tmp);
            }
            current.divideInplace((Comparable)Float.valueOf(clzImages.size()));
            output.add(current);
        }
        System.out.println("time " + t1.duration() + "ms");
        output.clear();
        Timer t2 = Timer.timer();
        for (ListDataset clzImages : images.values()) {
            final MBFImage current = new MBFImage(200, 200, ColourSpace.RGB);
            Parallel.forEach((Iterable)clzImages, (Operation)new Operation<MBFImage>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(MBFImage i) {
                    MBFImage tmp = new MBFImage(200, 200, ColourSpace.RGB);
                    tmp.fill(RGBColour.WHITE);
                    MBFImage small = (MBFImage)((MBFImage)i.process((SinglebandImageProcessor)resize)).normalise();
                    int x = (200 - small.getWidth()) / 2;
                    int y = (200 - small.getHeight()) / 2;
                    tmp.drawImage((Image)small, x, y);
                    MBFImage mBFImage = current;
                    synchronized (mBFImage) {
                        current.addInplace((MultiBandImage)tmp);
                    }
                }
            });
            current.divideInplace((Comparable)Float.valueOf(clzImages.size()));
            output.add(current);
        }
        System.out.println("time " + t2.duration() + "ms");
        output.clear();
        Timer t3 = Timer.timer();
        for (ListDataset clzImages : images.values()) {
            final MBFImage current = new MBFImage(200, 200, ColourSpace.RGB);
            Parallel.forEachPartitioned((Partitioner)new RangePartitioner((List)clzImages), (Operation)new Operation<Iterator<MBFImage>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform(Iterator<MBFImage> im) {
                    MBFImage tmpAccum = new MBFImage(200, 200, 3);
                    MBFImage tmp = new MBFImage(200, 200, ColourSpace.RGB);
                    while (im.hasNext()) {
                        MBFImage i = im.next();
                        tmp.fill(RGBColour.WHITE);
                        MBFImage small = (MBFImage)((MBFImage)i.process((SinglebandImageProcessor)resize)).normalise();
                        int x = (200 - small.getWidth()) / 2;
                        int y = (200 - small.getHeight()) / 2;
                        tmp.drawImage((Image)small, x, y);
                        tmpAccum.addInplace((MultiBandImage)tmp);
                    }
                    MBFImage mBFImage = current;
                    synchronized (mBFImage) {
                        current.addInplace((MultiBandImage)tmpAccum);
                    }
                }
            });
            current.divideInplace((Comparable)Float.valueOf(clzImages.size()));
            output.add(current);
        }
        System.out.println("time " + t3.duration() + "ms");
        DisplayUtilities.display((String)"Images", output);
    }
}

