/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.adv.faces.eigen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openimaj.data.dataset.Dataset;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.experiment.dataset.split.GroupedRandomSplitter;
import org.openimaj.experiment.dataset.util.DatasetAdaptors;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.model.EigenImages;

public class App {
    public static void main(String[] args) throws IOException {
        VFSGroupDataset dataset = new VFSGroupDataset("zip:http://datasets.openimaj.org/att_faces.zip", ImageUtilities.FIMAGE_READER);
        GroupedRandomSplitter splits = new GroupedRandomSplitter((GroupedDataset)dataset, 5, 0, 5);
        GroupedDataset training = splits.getTrainingDataset();
        GroupedDataset testing = splits.getTestDataset();
        List basisImages = DatasetAdaptors.asList((Dataset)training);
        int nEigenvectors = 100;
        EigenImages eigen = new EigenImages(100);
        eigen.train(basisImages);
        ArrayList<FImage> eigenFaces = new ArrayList<FImage>();
        for (int i = 0; i < 12; ++i) {
            eigenFaces.add(eigen.visualisePC(i));
        }
        DisplayUtilities.display((String)"EigenFaces", eigenFaces);
        HashMap<String, DoubleFV[]> features = new HashMap<String, DoubleFV[]>();
        for (String person : training.getGroups()) {
            DoubleFV[] fvs = new DoubleFV[5];
            for (int i = 0; i < 5; ++i) {
                FImage face = (FImage)((ListDataset)training.get((Object)person)).get(i);
                fvs[i] = eigen.extractFeature(face);
            }
            features.put(person, fvs);
        }
        double correct = 0.0;
        double incorrect = 0.0;
        for (String truePerson : testing.getGroups()) {
            for (FImage face : (ListDataset)testing.get((Object)truePerson)) {
                DoubleFV testFeature = eigen.extractFeature(face);
                String bestPerson = null;
                double minDistance = Double.MAX_VALUE;
                for (String person : features.keySet()) {
                    for (DoubleFV fv : (DoubleFV[])features.get(person)) {
                        double distance = fv.compare(testFeature, DoubleFVComparison.EUCLIDEAN);
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                        bestPerson = person;
                    }
                }
                System.out.println("Actual: " + truePerson + "\tguess: " + bestPerson);
                if (truePerson.equals(bestPerson)) {
                    correct += 1.0;
                    continue;
                }
                incorrect += 1.0;
            }
        }
        System.out.println("Accuracy: " + correct / (correct + incorrect));
    }
}

