/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.video.faces;

import java.io.IOException;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.capture.VideoCapture;

public class App {
    public static void main(String[] args) throws IOException {
        VideoCapture vc = new VideoCapture(320, 240);
        VideoDisplay vd = VideoDisplay.createVideoDisplay((Video)vc);
        vd.addVideoListener((VideoDisplayListener)new VideoDisplayListener<MBFImage>(){

            public void beforeUpdate(MBFImage frame) {
                HaarCascadeDetector fd = new HaarCascadeDetector(40);
                List faces = fd.detectFaces((Image)Transforms.calculateIntensity((MBFImage)frame));
                for (DetectedFace face : faces) {
                    frame.drawShape((Shape)face.getBounds(), (Object)RGBColour.RED);
                }
            }

            public void afterUpdate(VideoDisplay<MBFImage> display) {
            }
        });
    }
}

