/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.images.datasets;

import java.util.Collection;
import java.util.Map;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.dataset.BingImageDataset;
import org.openimaj.image.dataset.FlickrImageDataset;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.util.api.auth.DefaultTokenFactory;
import org.openimaj.util.api.auth.common.BingAPIToken;
import org.openimaj.util.api.auth.common.FlickrAPIToken;

public class App {
    public static void main(String[] args) throws Exception {
        VFSListDataset images = new VFSListDataset("/images", ImageUtilities.FIMAGE_READER);
        System.out.println(images.size());
        DisplayUtilities.display((Image)((Image)images.getRandomInstance()), (String)"A random image from the dataset");
        DisplayUtilities.display((String)"My images", (Collection)images);
        VFSListDataset faces = new VFSListDataset("zip:http://datasets.openimaj.org/att_faces.zip", ImageUtilities.FIMAGE_READER);
        System.out.println(faces.size());
        DisplayUtilities.display((String)"ATT faces", (Collection)faces);
        VFSGroupDataset groupedFaces = new VFSGroupDataset("zip:http://datasets.openimaj.org/att_faces.zip", ImageUtilities.FIMAGE_READER);
        for (Map.Entry entry : groupedFaces.entrySet()) {
            DisplayUtilities.display((String)((String)entry.getKey()), (Collection)((Collection)entry.getValue()));
        }
        FlickrAPIToken flickrToken = (FlickrAPIToken)DefaultTokenFactory.get(FlickrAPIToken.class);
        FlickrImageDataset cats = FlickrImageDataset.create((InputStreamObjectReader)ImageUtilities.FIMAGE_READER, (FlickrAPIToken)flickrToken, (String)"cat", (int)10);
        DisplayUtilities.display((String)"Cats", (Collection)cats);
        BingAPIToken bingToken = (BingAPIToken)DefaultTokenFactory.get(BingAPIToken.class);
        BingImageDataset arnie = BingImageDataset.create((InputStreamObjectReader)ImageUtilities.MBFIMAGE_READER, (BingAPIToken)bingToken, (String)"Arnold Schwarzenegger", (int)10);
        DisplayUtilities.display((String)"Arnie", (Collection)arnie);
    }
}

