/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.mode.java.tweak.ColorControlBox;
import processing.mode.java.tweak.ColorMode;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.HandleComparator;

public class SketchParser {
    public List<List<ColorControlBox>> colorBoxes;
    public List<List<Handle>> allHandles;
    int intVarCount;
    int floatVarCount;
    final String varPrefix = "tweakmode";
    String[] codeTabs;
    boolean requiresComment;
    List<ColorMode> colorModes;
    List<List<Range>> scientificNotations;
    List<List<Range>> ignoreFunctions;
    List<List<Range>> commentBlocks;
    List<int[]> curlyScopes;

    public SketchParser(String[] codeTabs, boolean requiresComment) {
        this.codeTabs = codeTabs;
        this.requiresComment = requiresComment;
        this.intVarCount = 0;
        this.floatVarCount = 0;
        this.commentBlocks = new ArrayList<List<Range>>();
        for (String code : codeTabs) {
            this.commentBlocks.add(SketchParser.getCommentBlocks(code));
        }
        this.ignoreFunctions = new ArrayList<List<Range>>();
        Range settingsRange = SketchParser.getVoidFunctionRange(codeTabs[0], "settings");
        Range setupRange = SketchParser.getVoidFunctionRange(codeTabs[0], "setup");
        this.ignoreFunctions.add(Arrays.asList(settingsRange, setupRange));
        for (int i = 0; i < codeTabs.length - 1; ++i) {
            this.ignoreFunctions.add(new ArrayList());
        }
        this.curlyScopes = new ArrayList<int[]>();
        for (String code : codeTabs) {
            this.curlyScopes.add(SketchParser.getCurlyScopes(code));
        }
        this.scientificNotations = this.getAllScientificNotations();
        this.addAllNumbers();
        this.colorModes = this.findAllColorModes();
        this.createColorBoxes();
        this.createColorBoxesForLights();
        this.handleMultipleColorModes();
    }

    private void addAllNumbers() {
        this.allHandles = new ArrayList<List<Handle>>();
        this.addAllDecimalNumbers();
        this.addAllHexNumbers();
        this.addAllWebColorNumbers();
        for (List<Handle> handle : this.allHandles) {
            Collections.sort(handle, new HandleComparator());
        }
    }

    private void addAllDecimalNumbers() {
        Pattern p = Pattern.compile("[\\[\\{<>(),\\t\\s\\+\\-\\/\\*^%!|&=?:~]\\d+\\.?\\d*");
        for (int i = 0; i < this.codeTabs.length; ++i) {
            ArrayList<Handle> handles = new ArrayList<Handle>();
            this.allHandles.add(handles);
            String c = this.codeTabs[i];
            Matcher m = p.matcher(c);
            while (m.find()) {
                String name;
                boolean forceFloat = false;
                int start = m.start() + 1;
                int end = m.end();
                if (SketchParser.isInRangeList(start, this.commentBlocks.get(i)) || SketchParser.isInRangeList(start, this.ignoreFunctions.get(i)) || this.requiresComment && !SketchParser.lineHasTweakComment(start, c)) continue;
                boolean found = false;
                for (Range r : this.scientificNotations.get(i)) {
                    if (!r.contains(start)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (c.charAt(end) == 'f') {
                    forceFloat = true;
                    ++end;
                }
                if (c.charAt(start - 1) == '-' && SketchParser.isNegativeSign(start - 2, c)) {
                    --start;
                }
                if (c.charAt(m.end()) == 'x' || c.charAt(m.end()) == 'X' || SketchParser.isInsideString(start, c) || this.isGlobal(m.start(), i)) continue;
                int line = SketchParser.countLines(c.substring(0, start)) - 1;
                String value = c.substring(start, end);
                if (value.contains(".") || forceFloat) {
                    name = "tweakmode_float[" + this.floatVarCount + "]";
                    int decimalDigits = SketchParser.getNumDigitsAfterPoint(value);
                    handles.add(new Handle("float", name, this.floatVarCount, value, i, line, start, end, decimalDigits));
                    ++this.floatVarCount;
                    continue;
                }
                name = "tweakmode_int[" + this.intVarCount + "]";
                handles.add(new Handle("int", name, this.intVarCount, value, i, line, start, end, 0));
                ++this.intVarCount;
            }
        }
    }

    private void addAllHexNumbers() {
        Pattern p = Pattern.compile("[\\[\\{<>(),\\t\\s\\+\\-\\/\\*^%!|&=?:~]0x[A-Fa-f0-9]+");
        for (int i = 0; i < this.codeTabs.length; ++i) {
            String c = this.codeTabs[i];
            Matcher m = p.matcher(c);
            while (m.find()) {
                Handle handle;
                int start = m.start() + 1;
                int end = m.end();
                if (SketchParser.isInRangeList(start, this.commentBlocks.get(i)) || SketchParser.isInRangeList(start, this.ignoreFunctions.get(i)) || this.requiresComment && !SketchParser.lineHasTweakComment(start, c) || SketchParser.isInsideString(start, c) || this.isGlobal(m.start(), i)) continue;
                int line = SketchParser.countLines(c.substring(0, start)) - 1;
                String value = c.substring(start, end);
                String name = "tweakmode_int[" + this.intVarCount + "]";
                try {
                    handle = new Handle("hex", name, this.intVarCount, value, i, line, start, end, 0);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.allHandles.get(i).add(handle);
                ++this.intVarCount;
            }
        }
    }

    private void addAllWebColorNumbers() {
        Pattern p = Pattern.compile("#[A-Fa-f0-9]{6}");
        for (int i = 0; i < this.codeTabs.length; ++i) {
            String c = this.codeTabs[i];
            Matcher m = p.matcher(c);
            while (m.find()) {
                Handle handle;
                int start = m.start();
                int end = m.end();
                if (SketchParser.isInRangeList(start, this.commentBlocks.get(i)) || SketchParser.isInRangeList(start, this.ignoreFunctions.get(i)) || this.requiresComment && !SketchParser.lineHasTweakComment(start, c) || SketchParser.isInsideString(start, c) || this.isGlobal(m.start(), i)) continue;
                int line = SketchParser.countLines(c.substring(0, start)) - 1;
                String value = c.substring(start, end);
                String name = "tweakmode_int[" + this.intVarCount + "]";
                try {
                    handle = new Handle("webcolor", name, this.intVarCount, value, i, line, start, end, 0);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                this.allHandles.get(i).add(handle);
                ++this.intVarCount;
            }
        }
    }

    private ArrayList<ColorMode> findAllColorModes() {
        ArrayList<ColorMode> modes = new ArrayList<ColorMode>();
        for (int i = 0; i < this.codeTabs.length; ++i) {
            String tab = this.codeTabs[i];
            int index = -1;
            while ((index = tab.indexOf("colorMode", index + 1)) > -1) {
                int parClose;
                int parOpen;
                if (SketchParser.isInRangeList(index, this.commentBlocks.get(i)) || (parOpen = tab.indexOf(40, index += 9)) < 0 || (parClose = tab.indexOf(41, parOpen + 1)) < 0) continue;
                String modeDesc = tab.substring(parOpen + 1, parClose);
                String context = SketchParser.getObject(index - 9, tab);
                modes.add(ColorMode.fromString(context, modeDesc));
            }
        }
        return modes;
    }

    private void createColorBoxes() {
        this.colorBoxes = new ArrayList<List<ColorControlBox>>();
        Pattern p = Pattern.compile("color\\(|color\\s\\(|fill[\\(\\s]|stroke[\\(\\s]|background[\\(\\s]|tint[\\(\\s]");
        for (int i = 0; i < this.codeTabs.length; ++i) {
            ArrayList<ColorControlBox> colorBox = new ArrayList<ColorControlBox>();
            this.colorBoxes.add(colorBox);
            String tab = this.codeTabs[i];
            Matcher m = p.matcher(tab);
            while (m.find()) {
                boolean bl;
                ArrayList<Handle> colorHandles = new ArrayList<Handle>();
                int openPar = tab.indexOf("(", m.start());
                int closePar = tab.indexOf(")", m.end());
                if (openPar < 0 || closePar < 0 || SketchParser.isInRangeList(m.start(), this.commentBlocks.get(i)) || SketchParser.isInRangeList(m.start(), this.ignoreFunctions.get(i))) continue;
                for (Handle handle : this.allHandles.get(i)) {
                    if (handle.startChar <= openPar || handle.endChar > closePar) continue;
                    colorHandles.add(handle);
                }
                if (colorHandles.size() <= 0) continue;
                String insidePar = tab.substring(openPar + 1, closePar);
                for (Handle h : colorHandles) {
                    insidePar = insidePar.replaceFirst(h.strValue, "");
                }
                boolean bl2 = false;
                for (int j = 0; j < insidePar.length(); ++j) {
                    if (insidePar.charAt(j) == ' ' || insidePar.charAt(j) == ',') continue;
                    bl = true;
                }
                if (bl) continue;
                String context = SketchParser.getObject(m.start(), tab);
                ColorMode cmode = this.getColorModeForContext(context);
                ColorControlBox newCCB = new ColorControlBox(context, cmode, colorHandles);
                if (cmode.unrecognizedMode) {
                    if (!newCCB.isHex) continue;
                    colorBox.add(newCCB);
                    continue;
                }
                colorBox.add(newCCB);
            }
        }
    }

    private void createColorBoxesForLights() {
        Pattern p = Pattern.compile("ambientLight[\\(\\s]|directionalLight[\\(\\s]|pointLight[\\(\\s]|spotLight[\\(\\s]|lightSpecular[\\(\\s]|specular[\\(\\s]|ambient[\\(\\s]|emissive[\\(\\s]");
        for (int i = 0; i < this.codeTabs.length; ++i) {
            String tab = this.codeTabs[i];
            Matcher m = p.matcher(tab);
            while (m.find()) {
                boolean bl;
                ArrayList<Handle> colorHandles = new ArrayList<Handle>();
                int openPar = tab.indexOf("(", m.start());
                int closePar = tab.indexOf(")", m.end());
                if (openPar < 0 || closePar < 0 || SketchParser.isInRangeList(m.start(), this.commentBlocks.get(i)) || SketchParser.isInRangeList(m.start(), this.ignoreFunctions.get(i))) continue;
                int colorParamsEnd = openPar;
                int commas = 3;
                while (commas-- > 0) {
                    if ((colorParamsEnd = tab.indexOf(",", colorParamsEnd + 1)) >= 0 && colorParamsEnd <= closePar) continue;
                    colorParamsEnd = closePar;
                    break;
                }
                for (Handle handle : this.allHandles.get(i)) {
                    if (handle.startChar <= openPar || handle.endChar > colorParamsEnd) continue;
                    colorHandles.add(handle);
                }
                if (colorHandles.size() <= 0) continue;
                String insidePar = tab.substring(openPar + 1, colorParamsEnd);
                for (Handle h : colorHandles) {
                    insidePar = insidePar.replaceFirst(h.strValue, "");
                }
                boolean bl2 = false;
                for (int j = 0; j < insidePar.length(); ++j) {
                    if (insidePar.charAt(j) == ' ' || insidePar.charAt(j) == ',') continue;
                    bl = true;
                }
                if (bl) continue;
                String context = SketchParser.getObject(m.start(), tab);
                ColorMode cmode = this.getColorModeForContext(context);
                ColorControlBox newCCB = new ColorControlBox(context, cmode, colorHandles);
                if (cmode.unrecognizedMode) {
                    if (!newCCB.isHex) continue;
                    this.colorBoxes.get(i).add(newCCB);
                    continue;
                }
                this.colorBoxes.get(i).add(newCCB);
            }
        }
    }

    private ColorMode getColorModeForContext(String context) {
        for (ColorMode cm : this.colorModes) {
            if (!cm.drawContext.equals(context)) continue;
            return cm;
        }
        ColorMode newMode = new ColorMode(context);
        this.colorModes.add(newMode);
        return newMode;
    }

    private void handleMultipleColorModes() {
        HashMap<String, Integer> modeCount = new HashMap<String, Integer>();
        for (ColorMode cm : this.colorModes) {
            Object prev = (Integer)modeCount.get(cm.drawContext);
            if (prev == null) {
                prev = 0;
            }
            modeCount.put(cm.drawContext, (Integer)prev + 1);
        }
        ArrayList<String> multipleContexts = new ArrayList<String>();
        Set allContexts = modeCount.keySet();
        for (String context : allContexts) {
            if ((Integer)modeCount.get(context) <= 1) continue;
            multipleContexts.add(context);
        }
        for (int i = 0; i < this.codeTabs.length; ++i) {
            ArrayList<ColorControlBox> toDelete = new ArrayList<ColorControlBox>();
            for (String context : multipleContexts) {
                for (ColorControlBox ccb : this.colorBoxes.get(i)) {
                    if (!ccb.drawContext.equals(context) || ccb.isHex) continue;
                    toDelete.add(ccb);
                }
            }
            this.colorBoxes.get(i).removeAll(toDelete);
        }
    }

    private List<List<Range>> getAllScientificNotations() {
        ArrayList<List<Range>> notations = new ArrayList<List<Range>>();
        Pattern p = Pattern.compile("[+\\-]?(?:0|[1-9]\\d*)(?:\\.\\d*)?[eE][+\\-]?\\d+");
        for (String code : this.codeTabs) {
            ArrayList<Range> notation = new ArrayList<Range>();
            Matcher m = p.matcher(code);
            while (m.find()) {
                notation.add(new Range(m.start(), m.end()));
            }
            notations.add(notation);
        }
        return notations;
    }

    public static boolean containsTweakComment(String[] codeTabs) {
        for (String tab : codeTabs) {
            if (!SketchParser.hasTweakComment(tab)) continue;
            return true;
        }
        return false;
    }

    private static boolean lineHasTweakComment(int pos, String code) {
        int lineEnd = SketchParser.getEndOfLine(pos, code);
        if (lineEnd < 0) {
            return false;
        }
        String line = code.substring(pos, lineEnd);
        return SketchParser.hasTweakComment(line);
    }

    private static boolean hasTweakComment(String code) {
        return code.contains("/// tweak");
    }

    private static boolean isNegativeSign(int pos, String code) {
        for (int i = pos; i >= 0; --i) {
            char c = code.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return c == ',' || c == '{' || c == '[' || c == '(' || c == '=' || c == '?' || c == '+' || c == '-' || c == '/' || c == '*' || c == '%' || c == '<' || c == '>' || c == ':' || c == '&' || c == '|' || c == '^' || c == '!' || c == '~';
        }
        return false;
    }

    private static int getNumDigitsAfterPoint(String number) {
        Pattern p = Pattern.compile("\\.[0-9]+");
        Matcher m = p.matcher(number);
        if (m.find()) {
            return m.end() - m.start() - 1;
        }
        return 0;
    }

    private static int countLines(String str) {
        String[] lines = str.split("\r\n|\n\r|\n|\r");
        return lines.length;
    }

    private static boolean isInsideString(int pos, String code) {
        int quoteNum = 0;
        for (int c = pos; c >= 0 && code.charAt(c) != '\n'; --c) {
            if (code.charAt(c) != '\"') continue;
            ++quoteNum;
        }
        return quoteNum % 2 == 1;
    }

    private static int[] getCurlyScopes(String code) {
        List<Range> comments = SketchParser.getCommentBlocks(code);
        int[] scopes = new int[code.length()];
        int curlyScope = 0;
        boolean arrayAssignmentMaybeCommingFlag = false;
        int arrayAssignmentCurlyScope = 0;
        for (int pos = 0; pos < code.length(); ++pos) {
            scopes[pos] = curlyScope++;
            if (SketchParser.isInRangeList(pos, comments)) continue;
            if (code.charAt(pos) == '{') {
                if (arrayAssignmentMaybeCommingFlag || arrayAssignmentCurlyScope > 0) {
                    ++arrayAssignmentCurlyScope;
                    arrayAssignmentMaybeCommingFlag = false;
                }
                continue;
            }
            if (code.charAt(pos) == '}') {
                if (arrayAssignmentCurlyScope > 0) {
                    --arrayAssignmentCurlyScope;
                    continue;
                }
                --curlyScope;
                continue;
            }
            if (code.charAt(pos) == '=') {
                arrayAssignmentMaybeCommingFlag = true;
                continue;
            }
            if (SketchParser.isWhiteSpace(code.charAt(pos))) continue;
            arrayAssignmentMaybeCommingFlag = false;
        }
        return scopes;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private boolean isGlobal(int pos, int codeTabIndex) {
        return this.curlyScopes.get(codeTabIndex)[pos] == 0;
    }

    private static List<Range> getCommentBlocks(String code) {
        ArrayList<Range> commentBlocks = new ArrayList<Range>();
        int lastBlockStart = 0;
        boolean lookForEnd = false;
        for (int pos = 0; pos < code.length() - 1; ++pos) {
            if (lookForEnd) {
                if (code.charAt(pos) != '*' || code.charAt(pos + 1) != '/') continue;
                commentBlocks.add(new Range(lastBlockStart, pos + 1));
                lookForEnd = false;
                continue;
            }
            if (code.charAt(pos) == '/' && code.charAt(pos + 1) == '*') {
                lastBlockStart = pos;
                lookForEnd = true;
                continue;
            }
            if (code.charAt(pos) != '/' || code.charAt(pos + 1) != '/') continue;
            commentBlocks.add(new Range(pos, SketchParser.getEndOfLine(pos, code)));
        }
        return commentBlocks;
    }

    private static boolean isInRangeList(int pos, List<Range> rangeList) {
        for (Range r : rangeList) {
            if (!r.contains(pos)) continue;
            return true;
        }
        return false;
    }

    private static int getEndOfLine(int pos, String code) {
        return code.indexOf("\n", pos);
    }

    private static String getObject(int pos, String code) {
        boolean readObject = false;
        String obj = "this";
        while (pos-- >= 0) {
            if (code.charAt(pos) == '.') {
                if (readObject) break;
                obj = "";
                readObject = true;
                continue;
            }
            if (code.charAt(pos) == ' ' || code.charAt(pos) == '\t') break;
            if (!readObject) continue;
            obj = code.charAt(pos) + obj;
        }
        return obj;
    }

    public static Range getVoidFunctionRange(String code, String functionName) {
        return new Range(SketchParser.getVoidFunctionStart(code, functionName), SketchParser.getVoidFunctionEnd(code, functionName));
    }

    public static int getVoidFunctionStart(String code, String functionName) {
        Pattern p = Pattern.compile("void[\\s\\t\\r\\n]*" + functionName + "[\\s\\t]*\\(\\)[\\s\\t\\r\\n]*\\{");
        Matcher m = p.matcher(code);
        if (m.find()) {
            return m.end();
        }
        return -1;
    }

    public static int getVoidFunctionEnd(String code, String functionName) {
        List<Range> comments = SketchParser.getCommentBlocks(code);
        int start = SketchParser.getVoidFunctionStart(code, functionName);
        if (start == -1) {
            return -1;
        }
        int bracketCount = 1;
        int pos = start;
        while (bracketCount > 0 && pos < code.length()) {
            if (SketchParser.isInRangeList(pos, comments)) {
                ++pos;
                continue;
            }
            if (code.charAt(pos) == '{') {
                ++bracketCount;
            } else if (code.charAt(pos) == '}') {
                --bracketCount;
            }
            ++pos;
        }
        if (bracketCount == 0) {
            return pos - 1;
        }
        return -1;
    }

    public static int getSetupStart(String code) {
        Pattern p = Pattern.compile("void[\\s\\t\\r\\n]*setup[\\s\\t]*\\(\\)[\\s\\t\\r\\n]*\\{");
        Matcher m = p.matcher(code);
        if (m.find()) {
            return m.end();
        }
        return -1;
    }

    public static int getSetupEnd(String code) {
        List<Range> comments = SketchParser.getCommentBlocks(code);
        int setupStart = SketchParser.getSetupStart(code);
        if (setupStart == -1) {
            return -1;
        }
        int bracketCount = 1;
        int pos = setupStart;
        while (bracketCount > 0 && pos < code.length()) {
            if (SketchParser.isInRangeList(pos, comments)) {
                ++pos;
                continue;
            }
            if (code.charAt(pos) == '{') {
                ++bracketCount;
            } else if (code.charAt(pos) == '}') {
                --bracketCount;
            }
            ++pos;
        }
        if (bracketCount == 0) {
            return pos - 1;
        }
        return -1;
    }

    public static int getAfterSizePos(String code) {
        List<Range> comments = SketchParser.getCommentBlocks(code);
        Pattern p = Pattern.compile("size[\\s\\t]*\\(");
        Matcher m = p.matcher(code);
        while (m.find()) {
            if (SketchParser.isInRangeList(m.start(), comments) || SketchParser.isInRangeList(m.end(), comments)) continue;
            int bracketCount = 1;
            int pos = m.end();
            while (bracketCount > 0 && pos < code.length()) {
                if (SketchParser.isInRangeList(pos, comments)) {
                    ++pos;
                    continue;
                }
                if (code.charAt(pos) == '(') {
                    ++bracketCount;
                } else if (code.charAt(pos) == ')') {
                    --bracketCount;
                }
                ++pos;
            }
            if (bracketCount != 0) continue;
            boolean found = false;
            while (pos < code.length()) {
                if (code.charAt(pos) == ';' && !SketchParser.isInRangeList(pos, comments)) {
                    found = true;
                    break;
                }
                ++pos;
            }
            if (!found) continue;
            return pos + 1;
        }
        return -1;
    }

    static class Range {
        int start;
        int end;

        Range(int s, int e) {
            this.start = s;
            this.end = e;
        }

        boolean contains(int v) {
            return v >= this.start && v < this.end;
        }
    }
}

