/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.util.Stack;
import java.util.regex.Pattern;
import processing.app.Formatter;
import processing.app.Preferences;
import processing.core.PApplet;

public class AutoFormat
implements Formatter {
    private char[] chars;
    private final StringBuilder buf = new StringBuilder();
    private final StringBuilder result = new StringBuilder();
    private int indentValue;
    private boolean EOF;
    private boolean inStatementFlag;
    private boolean overflowFlag;
    private boolean startFlag;
    private boolean if_flg;
    private boolean elseFlag;
    private int arrayLevel;
    private int arrayIndent;
    private int conditionalLevel;
    private int[][] sp_flg;
    private boolean[][] s_ind;
    private int if_lev;
    private int pos;
    private int level;
    private int curlyLvl;
    private int parenLevel;
    private boolean[] ind;
    private int[] p_flg;
    private int[][] s_tabs;
    private Stack<Boolean> doWhileFlags;
    private Stack<Boolean> ifWhileForFlags;
    private boolean jdoc_flag;
    private int tabs;
    private char lastNonWhitespace = '\u0000';

    private void handleMultiLineComment() {
        boolean savedStartFlag = this.startFlag;
        this.buf.append(this.nextChar());
        char ch = this.nextChar();
        while (!this.EOF) {
            this.buf.append(ch);
            while (ch != '/' && !this.EOF) {
                if (ch == '\n') {
                    this.writeIndentedComment();
                    this.startFlag = true;
                }
                ch = this.nextChar();
                this.buf.append(ch);
            }
            if (this.buf.length() >= 2 && this.buf.charAt(this.buf.length() - 2) == '*') {
                this.jdoc_flag = false;
                break;
            }
            ch = this.nextChar();
        }
        this.writeIndentedComment();
        this.startFlag = savedStartFlag;
        this.jdoc_flag = false;
    }

    private void handleSingleLineComment() {
        char ch = this.nextChar();
        while (ch != '\n' && !this.EOF) {
            this.buf.append(ch);
            ch = this.nextChar();
        }
        this.writeIndentedLine();
        this.startFlag = true;
    }

    private void writeIndentedLine() {
        if (this.buf.length() == 0) {
            if (this.startFlag) {
                this.elseFlag = false;
                this.startFlag = false;
            }
            return;
        }
        if (this.startFlag) {
            boolean indentMore;
            boolean bl = indentMore = !this.buf.toString().matches("[\\s\\]\\}\\)]+;") && (this.buf.charAt(0) != '{' || this.arrayLevel >= 0) && this.overflowFlag;
            if (indentMore) {
                ++this.tabs;
                if (this.arrayIndent > 0) {
                    this.tabs += this.arrayIndent;
                }
            }
            this.printIndentation();
            this.startFlag = false;
            if (indentMore) {
                --this.tabs;
                if (this.arrayIndent > 0) {
                    this.tabs -= this.arrayIndent;
                }
            }
        }
        if (this.lastNonSpaceChar() == '}' && this.bufStarts("else")) {
            this.result.append(' ');
        }
        if (this.elseFlag) {
            if (this.lastNonSpaceChar() == '}') {
                AutoFormat.trimRight(this.result);
                this.result.append(' ');
            }
            this.elseFlag = false;
        }
        this.overflowFlag = this.inStatementFlag;
        this.arrayIndent = this.arrayLevel;
        this.result.append((CharSequence)this.buf);
        this.buf.setLength(0);
    }

    private char lastNonSpaceChar() {
        for (int i = this.result.length() - 1; i >= 0; --i) {
            char chI = this.result.charAt(i);
            if (chI == ' ' || chI == '\n') continue;
            return chI;
        }
        return '\u0000';
    }

    private void writeIndentedComment() {
        if (this.buf.length() == 0) {
            return;
        }
        int firstNonSpace = 0;
        while (this.buf.charAt(firstNonSpace) == ' ') {
            ++firstNonSpace;
        }
        if (this.lookup_com("/**")) {
            this.jdoc_flag = true;
        }
        if (this.startFlag) {
            this.printIndentation();
        }
        if (this.buf.charAt(firstNonSpace) == '/' && this.buf.charAt(firstNonSpace + 1) == '*') {
            if (this.startFlag && this.lastNonWhitespace != ';') {
                this.result.append(this.buf.substring(firstNonSpace));
            } else {
                this.result.append((CharSequence)this.buf);
            }
        } else if (this.buf.charAt(firstNonSpace) == '*' || !this.jdoc_flag) {
            this.result.append(" " + this.buf.substring(firstNonSpace));
        } else {
            this.result.append(" * " + this.buf.substring(firstNonSpace));
        }
        this.buf.setLength(0);
    }

    private void printIndentation() {
        if (this.tabs <= 0) {
            this.tabs = 0;
            return;
        }
        int spaces = this.tabs * this.indentValue;
        for (int i = 0; i < spaces; ++i) {
            this.result.append(' ');
        }
    }

    private char peek() {
        return this.pos + 1 >= this.chars.length ? (char)'\u0000' : this.chars[this.pos + 1];
    }

    private void advanceToNonSpace(boolean allWsp) {
        if (this.EOF) {
            return;
        }
        if (allWsp) {
            do {
                ++this.pos;
            } while (this.pos < this.chars.length && Character.isWhitespace(this.chars[this.pos]));
        } else {
            do {
                ++this.pos;
            } while (this.pos < this.chars.length && this.chars[this.pos] == ' ');
        }
        if (this.pos == this.chars.length - 1) {
            this.EOF = true;
        } else {
            --this.pos;
        }
    }

    private char nextChar() {
        if (this.EOF) {
            return '\u0000';
        }
        ++this.pos;
        if (this.pos >= this.chars.length - 1) {
            this.EOF = true;
        }
        if (this.pos >= this.chars.length) {
            return '\u0000';
        }
        char retVal = this.chars[this.pos];
        if (!Character.isWhitespace(retVal)) {
            this.lastNonWhitespace = retVal;
        }
        return retVal;
    }

    private void gotElse() {
        this.tabs = this.s_tabs[this.curlyLvl][this.if_lev];
        this.p_flg[this.level] = this.sp_flg[this.curlyLvl][this.if_lev];
        this.ind[this.level] = this.s_ind[this.curlyLvl][this.if_lev];
        this.if_flg = true;
        this.inStatementFlag = false;
    }

    private boolean readForNewLine() {
        int savedTabs = this.tabs;
        char c = this.peek();
        while (!(this.EOF || c != '\t' && c != ' ')) {
            this.buf.append(this.nextChar());
            c = this.peek();
        }
        if (c == '/') {
            this.buf.append(this.nextChar());
            c = this.peek();
            if (c == '*') {
                this.buf.append(this.nextChar());
                this.handleMultiLineComment();
            } else if (c == '/') {
                this.buf.append(this.nextChar());
                this.handleSingleLineComment();
                return true;
            }
        }
        if ((c = this.peek()) == '\n') {
            this.nextChar();
            this.tabs = savedTabs;
            return true;
        }
        return false;
    }

    private char prevNonWhitespace() {
        StringBuffer tot = new StringBuffer();
        tot.append((CharSequence)this.result);
        tot.append((CharSequence)this.buf);
        for (int i = tot.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(tot.charAt(i))) continue;
            return tot.charAt(i);
        }
        return '\u0000';
    }

    private boolean bufStarts(String keyword) {
        return Pattern.matches("^\\s*" + keyword + "(?![a-zA-Z0-9_&]).*$", this.buf);
    }

    private boolean bufEnds(String keyword) {
        return Pattern.matches("^.*(?<![a-zA-Z0-9_&])" + keyword + "\\s*$", this.buf);
    }

    private void if_levSafe() {
        int i;
        if (this.s_tabs[0].length <= this.if_lev) {
            for (i = 0; i < this.s_tabs.length; ++i) {
                this.s_tabs[i] = PApplet.expand((int[])this.s_tabs[i]);
            }
        }
        if (this.sp_flg[0].length <= this.if_lev) {
            for (i = 0; i < this.sp_flg.length; ++i) {
                this.sp_flg[i] = PApplet.expand((int[])this.sp_flg[i]);
            }
        }
        if (this.s_ind[0].length <= this.if_lev) {
            for (i = 0; i < this.s_ind.length; ++i) {
                this.s_ind[i] = PApplet.expand((boolean[])this.s_ind[i]);
            }
        }
    }

    private boolean lookup_com(String keyword) {
        String regex = "^\\s*" + keyword.replace("*", "\\*") + ".*$";
        return Pattern.matches(regex, this.buf);
    }

    private static void trimRight(StringBuilder sb) {
        while (sb.length() >= 1 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.setLength(sb.length() - 1);
        }
    }

    public String format(String source) {
        String formatted;
        String normalizedText = source.replaceAll("\r", "");
        String cleanText = normalizedText + (normalizedText.endsWith("\n") ? "" : "\n");
        this.result.setLength(0);
        this.indentValue = Preferences.getInteger((String)"editor.tabs.size");
        this.if_flg = false;
        boolean forFlag = false;
        this.startFlag = true;
        int forParenthLevel = 0;
        this.level = 0;
        this.if_lev = 0;
        this.curlyLvl = 0;
        this.parenLevel = 0;
        this.conditionalLevel = 0;
        this.tabs = 0;
        this.overflowFlag = false;
        this.inStatementFlag = false;
        this.jdoc_flag = false;
        this.arrayLevel = -1;
        this.pos = -1;
        int[] s_level = new int[10];
        this.sp_flg = new int[20][10];
        this.s_ind = new boolean[20][10];
        int[] s_if_lev = new int[10];
        boolean[] s_if_flg = new boolean[10];
        this.ind = new boolean[10];
        this.p_flg = new int[10];
        this.s_tabs = new int[20][10];
        this.doWhileFlags = new Stack();
        this.ifWhileForFlags = new Stack();
        this.chars = cleanText.toCharArray();
        this.EOF = false;
        block15: while (!this.EOF) {
            char c = this.nextChar();
            switch (c) {
                default: {
                    this.inStatementFlag = true;
                    this.buf.append(c);
                    break;
                }
                case ',': {
                    this.inStatementFlag = true;
                    AutoFormat.trimRight(this.buf);
                    this.buf.append(", ");
                    this.advanceToNonSpace(false);
                    break;
                }
                case '\t': 
                case ' ': {
                    this.elseFlag = this.bufEnds("else");
                    if (this.elseFlag) {
                        this.gotElse();
                        if (!this.startFlag || this.buf.length() > 0) {
                            this.buf.append(c);
                        }
                        this.writeIndentedLine();
                        this.startFlag = false;
                        break;
                    }
                    if (this.startFlag && this.buf.length() <= 0) continue block15;
                    this.buf.append(c);
                    break;
                }
                case '\n': {
                    if (this.EOF) break;
                    this.elseFlag = this.bufEnds("else");
                    if (this.elseFlag) {
                        this.gotElse();
                    }
                    if (this.lookup_com("//") && this.buf.charAt(this.buf.length() - 1) == '\n') {
                        this.buf.setLength(this.buf.length() - 1);
                    }
                    if (this.elseFlag) {
                        this.writeIndentedLine();
                        this.result.append("\n");
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] + 1;
                        ++this.tabs;
                    } else {
                        this.writeIndentedLine();
                        this.result.append("\n");
                    }
                    this.startFlag = true;
                    break;
                }
                case '{': {
                    this.elseFlag = this.bufEnds("else");
                    if (this.elseFlag) {
                        this.gotElse();
                    }
                    this.doWhileFlags.push(this.bufEnds("do"));
                    char prevChar = this.prevNonWhitespace();
                    if (this.arrayLevel >= 0 || prevChar == '=' || prevChar == ']') {
                        ++this.arrayLevel;
                        this.buf.append(c);
                        break;
                    }
                    this.inStatementFlag = false;
                    if (s_if_lev.length == this.curlyLvl) {
                        s_if_lev = PApplet.expand((int[])s_if_lev);
                        s_if_flg = PApplet.expand((boolean[])s_if_flg);
                    }
                    s_if_lev[this.curlyLvl] = this.if_lev;
                    s_if_flg[this.curlyLvl] = this.if_flg;
                    this.if_lev = 0;
                    this.if_flg = false;
                    ++this.curlyLvl;
                    if (this.startFlag && this.p_flg[this.level] != 0) {
                        int n = this.level;
                        this.p_flg[n] = this.p_flg[n] - 1;
                        --this.tabs;
                    }
                    AutoFormat.trimRight(this.buf);
                    if (this.buf.length() > 0 || this.result.length() > 0 && !Character.isWhitespace(this.result.charAt(this.result.length() - 1))) {
                        this.buf.append(" ");
                    }
                    this.buf.append(c);
                    this.writeIndentedLine();
                    this.readForNewLine();
                    this.writeIndentedLine();
                    this.result.append('\n');
                    ++this.tabs;
                    this.startFlag = true;
                    if (this.p_flg[this.level] <= 0) continue block15;
                    this.ind[this.level] = true;
                    ++this.level;
                    s_level[this.level] = this.curlyLvl;
                    break;
                }
                case '}': {
                    if (this.arrayLevel >= 0) {
                        if (this.arrayLevel > 0) {
                            --this.arrayLevel;
                        }
                        if (this.arrayIndent > this.arrayLevel) {
                            this.arrayIndent = this.arrayLevel;
                        }
                        this.buf.append(c);
                        break;
                    }
                    this.inStatementFlag = false;
                    --this.curlyLvl;
                    if (this.curlyLvl < 0) {
                        this.curlyLvl = 0;
                        this.buf.append(c);
                        this.writeIndentedLine();
                        break;
                    }
                    this.if_lev = s_if_lev[this.curlyLvl] - 1;
                    if (this.if_lev < 0) {
                        this.if_lev = 0;
                    }
                    this.if_levSafe();
                    this.if_flg = s_if_flg[this.curlyLvl];
                    AutoFormat.trimRight(this.buf);
                    this.writeIndentedLine();
                    --this.tabs;
                    AutoFormat.trimRight(this.result);
                    this.result.append('\n');
                    this.overflowFlag = false;
                    this.printIndentation();
                    this.result.append(c);
                    if (this.peek() == ';') {
                        this.result.append(this.nextChar());
                    }
                    if (this.doWhileFlags.empty() || !this.doWhileFlags.pop().booleanValue() || !new String(this.chars, this.pos + 1, this.chars.length - this.pos - 1).trim().startsWith("while")) {
                        this.readForNewLine();
                        this.writeIndentedLine();
                        this.result.append('\n');
                        this.startFlag = true;
                    } else {
                        this.result.append(' ');
                        this.advanceToNonSpace(true);
                        this.startFlag = false;
                    }
                    if (this.curlyLvl < s_level[this.level] && this.level > 0) {
                        --this.level;
                    }
                    if (!this.ind[this.level]) continue block15;
                    this.tabs -= this.p_flg[this.level];
                    this.p_flg[this.level] = 0;
                    this.ind[this.level] = false;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.inStatementFlag = true;
                    this.buf.append(c);
                    char cc = this.nextChar();
                    while (!this.EOF && cc != c) {
                        this.buf.append(cc);
                        if (cc == '\\') {
                            cc = this.nextChar();
                            this.buf.append(cc);
                        }
                        if (cc == '\n') {
                            this.writeIndentedLine();
                            this.startFlag = true;
                        }
                        cc = this.nextChar();
                    }
                    this.buf.append(cc);
                    if (!this.readForNewLine()) continue block15;
                    this.chars[this.pos--] = 10;
                    break;
                }
                case ';': {
                    if (forFlag) {
                        AutoFormat.trimRight(this.buf);
                        this.buf.append("; ");
                        this.advanceToNonSpace(false);
                        break;
                    }
                    this.buf.append(c);
                    this.inStatementFlag = false;
                    this.writeIndentedLine();
                    if (this.p_flg[this.level] > 0 && !this.ind[this.level]) {
                        this.tabs -= this.p_flg[this.level];
                        this.p_flg[this.level] = 0;
                    }
                    this.readForNewLine();
                    this.writeIndentedLine();
                    this.result.append("\n");
                    this.startFlag = true;
                    this.arrayLevel = -1;
                    if (this.if_lev <= 0) continue block15;
                    if (this.if_flg) {
                        --this.if_lev;
                        this.if_flg = false;
                        break;
                    }
                    this.if_lev = 0;
                    break;
                }
                case '\\': {
                    this.buf.append(c);
                    this.buf.append(this.nextChar());
                    break;
                }
                case '?': {
                    ++this.conditionalLevel;
                    this.buf.append(c);
                    break;
                }
                case ':': {
                    if (this.peek() == ':') {
                        this.result.append(c).append(this.nextChar());
                        break;
                    }
                    if (this.conditionalLevel > 0) {
                        --this.conditionalLevel;
                        this.buf.append(c);
                        break;
                    }
                    if (forFlag) {
                        AutoFormat.trimRight(this.buf);
                        this.buf.append(" : ");
                        this.advanceToNonSpace(false);
                        break;
                    }
                    this.buf.append(c);
                    this.inStatementFlag = false;
                    this.arrayLevel = -1;
                    if (this.tabs > 0) {
                        --this.tabs;
                        this.writeIndentedLine();
                        ++this.tabs;
                    } else {
                        this.writeIndentedLine();
                    }
                    this.readForNewLine();
                    this.writeIndentedLine();
                    this.result.append('\n');
                    this.startFlag = true;
                    break;
                }
                case '/': {
                    char next = this.peek();
                    if (next == '/') {
                        this.buf.append(c).append(this.nextChar());
                        this.handleSingleLineComment();
                        this.result.append("\n");
                        break;
                    }
                    if (next == '*') {
                        if (this.buf.length() > 0) {
                            this.writeIndentedLine();
                        }
                        this.buf.append(c).append(this.nextChar());
                        this.handleMultiLineComment();
                        break;
                    }
                    this.buf.append(c);
                    break;
                }
                case ')': {
                    boolean wasIfEtc;
                    --this.parenLevel;
                    if (forFlag && forParenthLevel > this.parenLevel) {
                        forFlag = false;
                    }
                    if (this.parenLevel < 0) {
                        this.parenLevel = 0;
                    }
                    this.buf.append(c);
                    boolean bl = wasIfEtc = !this.ifWhileForFlags.empty() && this.ifWhileForFlags.pop() != false;
                    if (wasIfEtc) {
                        this.inStatementFlag = false;
                        this.arrayLevel = -1;
                    }
                    this.writeIndentedLine();
                    if (!wasIfEtc || !this.readForNewLine()) continue block15;
                    this.chars[this.pos] = 10;
                    --this.pos;
                    if (this.parenLevel != 0) continue block15;
                    int n = this.level;
                    this.p_flg[n] = this.p_flg[n] + 1;
                    ++this.tabs;
                    this.ind[this.level] = false;
                    break;
                }
                case '(': {
                    boolean isFor = this.bufEnds("for");
                    boolean isIf = this.bufEnds("if");
                    if (isFor || isIf || this.bufEnds("while")) {
                        if (!Character.isWhitespace(this.buf.charAt(this.buf.length() - 1))) {
                            this.buf.append(' ');
                        }
                        this.ifWhileForFlags.push(true);
                    } else {
                        this.ifWhileForFlags.push(false);
                    }
                    this.buf.append(c);
                    ++this.parenLevel;
                    if (isFor && !forFlag) {
                        forParenthLevel = this.parenLevel;
                        forFlag = true;
                        break;
                    }
                    if (!isIf) continue block15;
                    this.writeIndentedLine();
                    this.s_tabs[this.curlyLvl][this.if_lev] = this.tabs;
                    this.sp_flg[this.curlyLvl][this.if_lev] = this.p_flg[this.level];
                    this.s_ind[this.curlyLvl][this.if_lev] = this.ind[this.level];
                    ++this.if_lev;
                    this.if_levSafe();
                    this.if_flg = true;
                }
            }
        }
        if (this.buf.length() > 0) {
            this.writeIndentedLine();
        }
        return (formatted = this.result.toString()).equals(cleanText) ? source : formatted;
    }
}

