/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.ExtraMath;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyComplexDerived;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyGetSetDescr;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyComplex
extends PyObject {
    public double real;
    public double imag;
    static PyComplex J = new PyComplex(0.0, 1.0);
    public static final String exposed_name = "complex";
    private static final PyType COMPLEXTYPE = PyType.fromClass(PyComplex.class);

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        pyObject.__setitem__("imag", (PyObject)new PyGetSetDescr("imag", PyComplex.class, "getImag", null, null));
        pyObject.__setitem__("real", (PyObject)new PyGetSetDescr("real", PyComplex.class, "getReal", null, null));
        class Exposed___abs__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___abs__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___abs__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___abs__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___abs__();
            }
        }
        pyObject.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyComplex.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___float__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___float__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___float__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___float__();
            }
        }
        pyObject.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyComplex.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___int__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___int__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___int__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___int__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___int__();
            }
        }
        pyObject.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyComplex.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___long__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___long__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___long__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___long__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___long__();
            }
        }
        pyObject.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyComplex.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___neg__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___neg__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___neg__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___neg__();
            }
        }
        pyObject.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyComplex.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___pos__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pos__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pos__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___pos__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___pos__();
            }
        }
        pyObject.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyComplex.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___add__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___add__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___add__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___add__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyComplex.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___div__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___div__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___div__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___div__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___div__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyComplex.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___divmod__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___divmod__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___divmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___divmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyComplex.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___floordiv__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___floordiv__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___floordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___floordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyComplex.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___mod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mod__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mod__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___mod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___mod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyComplex.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___mul__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___mul__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___mul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___mul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyComplex.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___radd__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___radd__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___radd__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___radd__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___radd__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyComplex.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdiv__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rdiv__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rdiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rdiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyComplex.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rdivmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rdivmod__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rdivmod__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rdivmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rdivmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rdivmod__", (PyObject)new PyMethodDescr("__rdivmod__", PyComplex.class, 1, 1, new Exposed___rdivmod__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rfloordiv__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rfloordiv__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rfloordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rfloordiv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyComplex.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmod__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmod__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rmod__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyComplex.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rmul__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rmul__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rmul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rmul__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyComplex.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rpow__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rpow__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rpow__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rpow__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyComplex.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rsub__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rsub__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rsub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rsub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyComplex.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___rtruediv__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___rtruediv__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___rtruediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___rtruediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyComplex.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___sub__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___sub__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___sub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___sub__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyComplex.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___truediv__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___truediv__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___truediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___truediv__(pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyComplex.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___pow__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___pow__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___pow__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                PyObject pyObject3 = this.self.complex___pow__(pyObject, pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject4 = pyComplex.complex___pow__(pyObject2, pyObject3);
                if (pyObject4 == null) {
                    return Py.NotImplemented;
                }
                return pyObject4;
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = this.self.complex___pow__(pyObject, null);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }

            public PyObject inst_call(PyObject pyObject, PyObject pyObject2) {
                PyComplex pyComplex = (PyComplex)pyObject;
                PyObject pyObject3 = pyComplex.complex___pow__(pyObject2, null);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }
        }
        pyObject.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyComplex.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed_conjugate
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed_conjugate(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed_conjugate((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex_conjugate();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex_conjugate();
            }
        }
        pyObject.__setitem__("conjugate", (PyObject)new PyMethodDescr("conjugate", PyComplex.class, 0, 0, new Exposed_conjugate(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___nonzero__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___nonzero__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(this.self.complex___nonzero__());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return Py.newBoolean(pyComplex.complex___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyComplex.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___reduce__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___reduce__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___reduce__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return this.self.complex___reduce__();
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return pyComplex.complex___reduce__();
            }
        }
        pyObject.__setitem__("__reduce__", (PyObject)new PyMethodDescr("__reduce__", PyComplex.class, 0, 0, new Exposed___reduce__(null, null)));
        class Exposed___repr__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___repr__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___repr__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.complex_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return new PyString(pyComplex.complex_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyComplex.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___str__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___str__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(this.self.complex_toString());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return new PyString(pyComplex.complex_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyComplex.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinFunctionNarrow {
            private PyComplex self;

            public PyObject getSelf() {
                return this.self;
            }

            Exposed___hash__(PyComplex pyComplex, PyBuiltinFunction.Info info) {
                super(info);
                this.self = pyComplex;
            }

            public PyBuiltinFunction makeBound(PyObject pyObject) {
                return new Exposed___hash__((PyComplex)pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(this.self.complex_hashCode());
            }

            public PyObject inst_call(PyObject pyObject) {
                PyComplex pyComplex = (PyComplex)pyObject;
                return Py.newInteger(pyComplex.complex_hashCode());
            }
        }
        pyObject.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyComplex.class, 0, 0, new Exposed___hash__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyComplex.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                return PyComplex.complex_new(this, bl, pyType, pyObjectArray, stringArray);
            }
        });
    }

    public static PyObject complex_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        PyComplex pyComplex;
        PyObject pyObject;
        PyObject pyObject2;
        block18: {
            if (pyObjectArray.length == 0) {
                if (pyNewWrapper.for_type == pyType) {
                    return new PyComplex(0.0, 0.0);
                }
                return new PyComplexDerived(pyType, 0.0, 0.0);
            }
            if (pyObjectArray.length > 2) {
                throw Py.TypeError("complex() takes at most 2 arguments (" + pyObjectArray.length + " given)");
            }
            ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, "real", "imag");
            pyObject2 = argParser.getPyObject(0, Py.Zero);
            pyObject = argParser.getPyObject(1, null);
            if (pyObject != null) {
                if (pyObject2 instanceof PyString) {
                    throw Py.TypeError("complex() can't take second arg if first is a string");
                }
                if (pyObject instanceof PyString) {
                    throw Py.TypeError("complex() second arg can't be a string");
                }
            }
            pyComplex = null;
            try {
                pyComplex = pyObject2.__complex__();
            }
            catch (PyException pyException) {
                if (Py.matchException(pyException, Py.AttributeError)) break block18;
                throw pyException;
            }
        }
        try {
            if (pyComplex == null) {
                pyComplex = new PyComplex(pyObject2.__float__().getValue(), 0.0);
            }
            if (pyObject != null) {
                if (pyComplex == pyObject2) {
                    pyComplex = new PyComplex(pyComplex.real, pyComplex.imag);
                }
                if (pyObject instanceof PyComplex) {
                    PyComplex pyComplex2 = (PyComplex)pyObject;
                    pyComplex.real -= pyComplex2.imag;
                    pyComplex.imag += pyComplex2.real;
                } else {
                    pyComplex.imag += pyObject.__float__().getValue();
                }
            }
            if (pyNewWrapper.for_type == pyType) {
                return pyComplex;
            }
            return new PyComplexDerived(pyType, pyComplex.real, pyComplex.imag);
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.AttributeError)) {
                PyObject pyObject3;
                PyObject pyObject4 = pyObject3 = pyComplex == null ? pyObject2 : pyObject;
                if (!(pyObject3 instanceof PyInstance)) {
                    throw Py.TypeError("complex() argument must be a string or a number");
                }
            }
            throw pyException;
        }
    }

    public PyComplex(PyType pyType, double d, double d2) {
        super(pyType);
        this.real = d;
        this.imag = d2;
    }

    public PyComplex(double d, double d2) {
        this(COMPLEXTYPE, d, d2);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'complex' object";
    }

    public final PyFloat getReal() {
        return Py.newFloat(this.real);
    }

    public final PyFloat getImag() {
        return Py.newFloat(this.imag);
    }

    public static String toString(double d) {
        if (d == Math.floor(d) && d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
            return Long.toString((long)d);
        }
        return Double.toString(d);
    }

    public String toString() {
        return this.complex_toString();
    }

    final String complex_toString() {
        if (this.real == 0.0) {
            return PyComplex.toString(this.imag) + "j";
        }
        if (this.imag >= 0.0) {
            return "(" + PyComplex.toString(this.real) + "+" + PyComplex.toString(this.imag) + "j)";
        }
        return "(" + PyComplex.toString(this.real) + "-" + PyComplex.toString(-this.imag) + "j)";
    }

    public int hashCode() {
        return this.complex_hashCode();
    }

    final int complex_hashCode() {
        if (this.imag == 0.0) {
            return new PyFloat(this.real).hashCode();
        }
        long l = Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.imag);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.complex___nonzero__();
    }

    final boolean complex___nonzero__() {
        return this.real != 0.0 && this.imag != 0.0;
    }

    public int __cmp__(PyObject pyObject) {
        return this.complex___cmp__(pyObject);
    }

    final int complex___cmp__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return -2;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        if (this.real == d && this.imag == d2) {
            return 0;
        }
        if (this.real != d) {
            return this.real < d ? -1 : 1;
        }
        return this.imag < d2 ? -1 : 1;
    }

    public PyObject __eq__(PyObject pyObject) {
        return this.complex___eq__(pyObject);
    }

    final PyObject complex___eq__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return Py.newBoolean(this.real == pyComplex.real && this.imag == pyComplex.imag);
    }

    public PyObject __ne__(PyObject pyObject) {
        return this.complex___ne__(pyObject);
    }

    final PyObject complex___ne__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return Py.newBoolean(this.real != pyComplex.real || this.imag != pyComplex.imag);
    }

    private PyObject unsupported_comparison(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        throw Py.TypeError("cannot compare complex numbers using <, <=, >, >=");
    }

    public PyObject __ge__(PyObject pyObject) {
        return this.complex___ge__(pyObject);
    }

    final PyObject complex___ge__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __gt__(PyObject pyObject) {
        return this.complex___gt__(pyObject);
    }

    final PyObject complex___gt__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __le__(PyObject pyObject) {
        return this.complex___le__(pyObject);
    }

    final PyObject complex___le__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public PyObject __lt__(PyObject pyObject) {
        return this.complex___lt__(pyObject);
    }

    final PyObject complex___lt__(PyObject pyObject) {
        return this.unsupported_comparison(pyObject);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyComplex) {
            return pyObject;
        }
        if (pyObject instanceof PyFloat) {
            return new PyComplex(((PyFloat)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyInteger) {
            return new PyComplex(((PyInteger)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyLong) {
            return new PyComplex(((PyLong)pyObject).doubleValue(), 0.0);
        }
        return Py.None;
    }

    private final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyComplex || pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private final PyComplex coerce(PyObject pyObject) {
        if (pyObject instanceof PyComplex) {
            return (PyComplex)pyObject;
        }
        if (pyObject instanceof PyFloat) {
            return new PyComplex(((PyFloat)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyInteger) {
            return new PyComplex(((PyInteger)pyObject).getValue(), 0.0);
        }
        if (pyObject instanceof PyLong) {
            return new PyComplex(((PyLong)pyObject).doubleValue(), 0.0);
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.complex___add__(pyObject);
    }

    final PyObject complex___add__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        PyComplex pyComplex = this.coerce(pyObject);
        return new PyComplex(this.real + pyComplex.real, this.imag + pyComplex.imag);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.complex___radd__(pyObject);
    }

    final PyObject complex___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    private static final PyObject _sub(PyComplex pyComplex, PyComplex pyComplex2) {
        return new PyComplex(pyComplex.real - pyComplex2.real, pyComplex.imag - pyComplex2.imag);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.complex___sub__(pyObject);
    }

    final PyObject complex___sub__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._sub(this, this.coerce(pyObject));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.complex___rsub__(pyObject);
    }

    final PyObject complex___rsub__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._sub(this.coerce(pyObject), this);
    }

    private static final PyObject _mul(PyComplex pyComplex, PyComplex pyComplex2) {
        return new PyComplex(pyComplex.real * pyComplex2.real - pyComplex.imag * pyComplex2.imag, pyComplex.real * pyComplex2.imag + pyComplex.imag * pyComplex2.real);
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.complex___mul__(pyObject);
    }

    final PyObject complex___mul__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mul(this, this.coerce(pyObject));
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.complex___rmul__(pyObject);
    }

    final PyObject complex___rmul__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mul(this.coerce(pyObject), this);
    }

    private static final PyObject _div(PyComplex pyComplex, PyComplex pyComplex2) {
        double d;
        double d2 = pyComplex2.real < 0.0 ? -pyComplex2.real : pyComplex2.real;
        double d3 = d = pyComplex2.imag < 0.0 ? -pyComplex2.imag : pyComplex2.imag;
        if (d2 >= d) {
            if (d2 == 0.0) {
                throw Py.ZeroDivisionError("complex division");
            }
            double d4 = pyComplex2.imag / pyComplex2.real;
            double d5 = pyComplex2.real + pyComplex2.imag * d4;
            return new PyComplex((pyComplex.real + pyComplex.imag * d4) / d5, (pyComplex.imag - pyComplex.real * d4) / d5);
        }
        double d6 = pyComplex2.real / pyComplex2.imag;
        double d7 = pyComplex2.real * d6 + pyComplex2.imag;
        return new PyComplex((pyComplex.real * d6 + pyComplex.imag) / d7, (pyComplex.imag * d6 - pyComplex.real) / d7);
    }

    public PyObject __div__(PyObject pyObject) {
        return this.complex___div__(pyObject);
    }

    final PyObject complex___div__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this, this.coerce(pyObject));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.complex___rdiv__(pyObject);
    }

    final PyObject complex___rdiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic complex division");
        }
        return PyComplex._div(this.coerce(pyObject), this);
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.complex___floordiv__(pyObject);
    }

    final PyObject complex___floordiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(pyObject)).__finditem__(0);
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.complex___floordiv__(pyObject);
    }

    final PyObject complex___rfloordiv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(pyObject), this).__finditem__(0);
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.complex___truediv__(pyObject);
    }

    final PyObject complex___truediv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._div(this, this.coerce(pyObject));
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.complex___rtruediv__(pyObject);
    }

    final PyObject complex___rtruediv__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._div(this.coerce(pyObject), this);
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.complex___mod__(pyObject);
    }

    final PyObject complex___mod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mod(this, this.coerce(pyObject));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.complex___rmod__(pyObject);
    }

    final PyObject complex___rmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._mod(this.coerce(pyObject), this);
    }

    private static PyObject _mod(PyComplex pyComplex, PyComplex pyComplex2) {
        PyComplex pyComplex3 = (PyComplex)PyComplex._div(pyComplex, pyComplex2);
        pyComplex3.real = Math.floor(pyComplex3.real);
        pyComplex3.imag = 0.0;
        return pyComplex.__sub__(pyComplex3.__mul__(pyComplex2));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.complex___divmod__(pyObject);
    }

    final PyObject complex___divmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this, this.coerce(pyObject));
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        return this.complex___rdivmod__(pyObject);
    }

    final PyObject complex___rdivmod__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._divmod(this.coerce(pyObject), this);
    }

    private static PyObject _divmod(PyComplex pyComplex, PyComplex pyComplex2) {
        PyComplex pyComplex3 = (PyComplex)PyComplex._div(pyComplex, pyComplex2);
        pyComplex3.real = Math.floor(pyComplex3.real);
        pyComplex3.imag = 0.0;
        return new PyTuple(new PyObject[]{pyComplex3, pyComplex.__sub__(pyComplex3.__mul__(pyComplex2))});
    }

    private static PyObject ipow(PyComplex pyComplex, int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        double d3 = 1.0;
        double d4 = 0.0;
        while (n2 > 0) {
            double d5;
            if ((n2 & 1) != 0) {
                d5 = d3 * d - d4 * d2;
                d4 = d4 * d + d3 * d2;
                d3 = d5;
            }
            if ((n2 >>= 1) == 0) break;
            d5 = d * d - d2 * d2;
            d2 = d * d2 * 2.0;
            d = d5;
        }
        PyComplex pyComplex2 = new PyComplex(d3, d4);
        if (n < 0) {
            return new PyComplex(1.0, 0.0).__div__(pyComplex2);
        }
        return pyComplex2;
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.complex___pow__(pyObject, pyObject2);
    }

    final PyObject complex___pow__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 != null) {
            throw Py.ValueError("complex modulo");
        }
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._pow(this, this.coerce(pyObject));
    }

    public PyObject __rpow__(PyObject pyObject) {
        return this.complex___rpow__(pyObject);
    }

    final PyObject complex___rpow__(PyObject pyObject) {
        if (!this.canCoerce(pyObject)) {
            return null;
        }
        return PyComplex._pow(this.coerce(pyObject), this);
    }

    public static PyObject _pow(PyComplex pyComplex, PyComplex pyComplex2) {
        double d = pyComplex.real;
        double d2 = pyComplex.imag;
        double d3 = pyComplex2.real;
        double d4 = pyComplex2.imag;
        if (d3 == 0.0 && d4 == 0.0) {
            return new PyComplex(1.0, 0.0);
        }
        if (d == 0.0 && d2 == 0.0 && (d4 != 0.0 || d3 < 0.0)) {
            throw Py.ValueError("0.0 to a negative or complex power");
        }
        int n = (int)d3;
        if (d4 == 0.0 && d3 == (double)n && n >= -128 && n <= 128) {
            return PyComplex.ipow(pyComplex, n);
        }
        double d5 = ExtraMath.hypot(d, d2);
        double d6 = Math.pow(d5, d3);
        double d7 = Math.atan2(d2, d);
        double d8 = d7 * d3;
        if (d4 != 0.0) {
            d6 /= Math.exp(d7 * d4);
            d8 += d4 * Math.log(d5);
        }
        return new PyComplex(d6 * Math.cos(d8), d6 * Math.sin(d8));
    }

    public PyObject __neg__() {
        return this.complex___neg__();
    }

    final PyObject complex___neg__() {
        return new PyComplex(-this.real, -this.imag);
    }

    public PyObject __pos__() {
        return this.complex___pos__();
    }

    final PyObject complex___pos__() {
        return new PyComplex(this.real, this.imag);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.complex___abs__();
    }

    final PyObject complex___abs__() {
        return new PyFloat(ExtraMath.hypot(this.real, this.imag));
    }

    public PyObject __int__() {
        return this.complex___int__();
    }

    final PyInteger complex___int__() {
        throw Py.TypeError("can't convert complex to int; use e.g. int(abs(z))");
    }

    public PyLong __long__() {
        return this.complex___long__();
    }

    final PyLong complex___long__() {
        throw Py.TypeError("can't convert complex to long; use e.g. long(abs(z))");
    }

    public PyFloat __float__() {
        return this.complex___float__();
    }

    final PyFloat complex___float__() {
        throw Py.TypeError("can't convert complex to float; use e.g. abs(z)");
    }

    public PyComplex __complex__() {
        return new PyComplex(this.real, this.imag);
    }

    public PyComplex conjugate() {
        return this.complex_conjugate();
    }

    final PyComplex complex_conjugate() {
        return new PyComplex(this.real, -this.imag);
    }

    public PyObject __reduce__() {
        return this.complex___reduce__();
    }

    final PyObject complex___reduce__() {
        return new PyTuple(new PyObject[]{this.getType(), new PyTuple(new PyObject[]{this.getReal(), this.getImag()})});
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }
}

