/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.FileUtil;
import org.python.core.JavaImportHelper;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyRunnable;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.SyspathArchive;
import org.python.core.SyspathJavaLoader;
import org.python.core.__builtin__;
import org.python.core.parser;
import org.python.parser.ast.modType;

public class imp {
    private static final String IMPORT_LOG = "import";
    private static final String UNKNOWN_SOURCEFILE = "<unknown>";
    public static final int APIVersion = 12;
    private static Object syspathJavaLoaderLock = new Object();
    private static ClassLoader syspathJavaLoader = null;
    private static PyTuple all = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSyspathJavaLoader() {
        Object object = syspathJavaLoaderLock;
        synchronized (object) {
            if (syspathJavaLoader == null) {
                syspathJavaLoader = new SyspathJavaLoader();
            }
        }
        return syspathJavaLoader;
    }

    private imp() {
    }

    public static PyModule addModule(String string) {
        PyObject pyObject = Py.getSystemState().modules;
        PyModule pyModule = (PyModule)pyObject.__finditem__(string = string.intern());
        if (pyModule != null) {
            return pyModule;
        }
        pyModule = new PyModule(string, null);
        pyObject.__setitem__(string, (PyObject)pyModule);
        return pyModule;
    }

    private static byte[] readBytes(InputStream inputStream) {
        try {
            byte[] byArray = FileUtil.readBytes(inputStream);
            return byArray;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
    }

    private static InputStream makeStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    static PyObject createFromPyClass(String string, InputStream inputStream, boolean bl, String string2) {
        PyCode pyCode;
        int n;
        byte[] byArray = imp.readBytes(inputStream);
        int n2 = (byArray[(n = byArray.length) - 4] << 24) + (byArray[n - 3] << 16) + (byArray[n - 2] << 8) + byArray[n - 1];
        if (n2 != 12) {
            if (bl) {
                return null;
            }
            throw Py.ImportError("invalid api version(" + n2 + " != " + 12 + ") in: " + string);
        }
        try {
            pyCode = BytecodeLoader.makeCode(string + "$py", byArray);
        }
        catch (Throwable throwable) {
            if (bl) {
                return null;
            }
            throw Py.JavaError(throwable);
        }
        Py.writeComment(IMPORT_LOG, "'" + string + "' as " + string2);
        return imp.createFromCode(string, pyCode, string2);
    }

    public static byte[] compileSource(String string, File file, String string2, String string3) {
        if (string2 == null) {
            string2 = file.toString();
        }
        return imp.compileSource(string, imp.makeStream(file), string2);
    }

    private static String makeCompiledFilename(String string) {
        return string.substring(0, string.length() - 3) + "$py.class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cacheCompiledSource(String string, String string2, byte[] byArray) {
        if (string2 == null) {
            if (string == null || string.equals(UNKNOWN_SOURCEFILE)) {
                return null;
            }
            string2 = imp.makeCompiledFilename(string);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            String string3 = string2;
            return string3;
        }
        catch (IOException iOException) {
            Py.writeDebug(IMPORT_LOG, "Unable to write to source cache file '" + string2 + "' due to " + iOException);
            String string4 = null;
            return string4;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Py.writeDebug(IMPORT_LOG, "Unable to close source cache file '" + string2 + "' due to " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] compileSource(String string, InputStream inputStream, String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            modType modType2;
            if (string2 == null) {
                string2 = UNKNOWN_SOURCEFILE;
            }
            try {
                modType2 = parser.parse(inputStream, "exec", string2, null);
            }
            finally {
                inputStream.close();
            }
            Module.compile(modType2, byteArrayOutputStream, string + "$py", string2, true, false, true, null);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(null, throwable, string2);
        }
    }

    public static PyObject createFromSource(String string, InputStream inputStream, String string2) {
        return imp.createFromSource(string, inputStream, string2, null);
    }

    static PyObject createFromSource(String string, InputStream inputStream, String string2, String string3) {
        byte[] byArray = imp.compileSource(string, inputStream, string2);
        string3 = imp.cacheCompiledSource(string2, string3, byArray);
        Py.writeComment(IMPORT_LOG, "'" + string + "' as " + string2);
        PyCode pyCode = BytecodeLoader.makeCode(string + "$py", byArray);
        return imp.createFromCode(string, pyCode, string2);
    }

    static PyObject createFromCode(String string, PyCode pyCode) {
        return imp.createFromCode(string, pyCode, null);
    }

    static PyObject createFromCode(String string, PyCode pyCode, String string2) {
        PyModule pyModule = imp.addModule(string);
        PyTableCode pyTableCode = null;
        if (pyCode instanceof PyTableCode) {
            pyTableCode = (PyTableCode)pyCode;
        }
        PyFrame pyFrame = new PyFrame(pyTableCode, pyModule.__dict__, pyModule.__dict__, null);
        pyTableCode.call(pyFrame);
        if (string2 != null) {
            pyModule.__setattr__("__file__", (PyObject)new PyString(string2));
        } else {
            Py.writeDebug(IMPORT_LOG, "No fileName known to set __file__ for " + string + ".");
        }
        return pyModule;
    }

    static PyObject createFromClass(String string, Class clazz) {
        if (PyRunnable.class.isAssignableFrom(clazz)) {
            try {
                return imp.createFromCode(string, ((PyRunnable)clazz.newInstance()).getMain());
            }
            catch (InstantiationException instantiationException) {
                throw Py.JavaError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Py.JavaError(illegalAccessException);
            }
        }
        return PyJavaClass.lookup(clazz);
    }

    static PyObject getPathImporter(PyObject pyObject, PyList pyList, PyObject pyObject2) {
        PyObject pyObject3;
        PyObject pyObject4 = pyObject.__finditem__(pyObject2);
        if (pyObject4 != null) {
            return pyObject4;
        }
        PyObject pyObject5 = pyList.__iter__();
        while ((pyObject3 = pyObject5.__iternext__()) != null) {
            try {
                pyObject4 = pyObject3.__call__(pyObject2);
                break;
            }
            catch (PyException pyException) {
                if (Py.matchException(pyException, Py.ImportError)) continue;
                throw pyException;
            }
        }
        pyObject4 = pyObject4 == null ? Py.None : pyObject4;
        pyObject.__setitem__(pyObject2, pyObject4);
        return pyObject4;
    }

    static PyObject replacePathItem(PyObject pyObject) {
        if (pyObject instanceof SyspathArchive) {
            return null;
        }
        try {
            return new SyspathArchive(pyObject.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static PyObject find_module(String string, String string2, PyList pyList) {
        PyObject pyObject;
        PyObject pyObject2;
        PyObject pyObject3 = Py.None;
        PySystemState pySystemState = Py.getSystemState();
        PyList pyList2 = pySystemState.meta_path;
        PyList pyList3 = pyList == null ? pySystemState.path : pyList;
        for (int i = 0; i < pyList3.__len__(); ++i) {
            pyObject2 = pyList3.__getitem__(i);
            pyObject = imp.replacePathItem(pyObject2);
            if (pyObject == null) continue;
            pyList3.__setitem__(i, pyObject);
        }
        PyObject pyObject4 = ((PyObject)pyList2).__iter__();
        while ((pyObject2 = pyObject4.__iternext__()) != null) {
            pyObject = pyObject2.__getattr__("find_module");
            PyObject[] pyObjectArray = new PyObject[2];
            pyObjectArray[0] = new PyString(string2);
            PyObject pyObject5 = pyObjectArray[1] = pyList == null ? Py.None : pyList;
            pyObject3 = pyObject.__call__(pyObjectArray);
            if (pyObject3 == Py.None) continue;
            return imp.loadFromLoader(pyObject3, string2);
        }
        pyObject2 = imp.loadBuiltin(string2);
        if (pyObject2 != null) {
            return pyObject2;
        }
        pyList = pyList == null ? pySystemState.path : pyList;
        for (int i = 0; i < pyList.__len__(); ++i) {
            PyObject pyObject6;
            PyObject pyObject7 = pyList.__getitem__(i);
            PyObject pyObject8 = imp.getPathImporter(pySystemState.path_importer_cache, pySystemState.path_hooks, pyObject7);
            if (pyObject8 != Py.None && (pyObject3 = (pyObject6 = pyObject8.__getattr__("find_module")).__call__(new PyObject[]{new PyString(string2)})) != Py.None) {
                return imp.loadFromLoader(pyObject3, string2);
            }
            pyObject2 = imp.loadFromSource(string, string2, pyObject7);
            if (pyObject2 == null) continue;
            return pyObject2;
        }
        return pyObject2;
    }

    private static PyObject loadBuiltin(String string) {
        Class clazz;
        if (string == "sys") {
            Py.writeComment(IMPORT_LOG, "'" + string + "' as sys in " + "builtin modules");
            return Py.java2py(Py.getSystemState());
        }
        String string2 = PySystemState.getBuiltin(string);
        if (string2 != null && (clazz = Py.findClassEx(string2, "builtin modules")) != null) {
            Py.writeComment(IMPORT_LOG, "'" + string + "' as " + string2 + " in builtin modules");
            try {
                if (PyObject.class.isAssignableFrom(clazz)) {
                    return PyType.fromClass(clazz);
                }
                return imp.createFromClass(string, clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw Py.ImportError("Cannot import " + string + ", missing class " + clazz.getName());
            }
        }
        return null;
    }

    static PyObject loadFromLoader(PyObject pyObject, String string) {
        PyObject pyObject2 = pyObject.__getattr__("load_module");
        return pyObject2.__call__(new PyObject[]{new PyString(string)});
    }

    public static PyObject loadFromCompiled(String string, InputStream inputStream, String string2) {
        return imp.createFromPyClass(string, inputStream, false, string2);
    }

    public static String defaultEmptyPathDirectory(String string) {
        if (string.length() == 0) {
            string = System.getProperty("user.dir");
        }
        return string;
    }

    static PyObject loadFromSource(String string, String string2, PyObject pyObject) {
        boolean bl;
        int n = string.length();
        String string3 = "__init__.py";
        String string4 = "__init__$py.class";
        String string5 = imp.defaultEmptyPathDirectory(pyObject.toString());
        File file = new File(string5, string);
        File file2 = new File(file, string3);
        File file3 = new File(file, string4);
        boolean bl2 = bl = file.isDirectory() && imp.caseok(file, string, n) && (file2.isFile() || file3.isFile());
        if (!bl) {
            Py.writeDebug(IMPORT_LOG, "trying source " + file.getPath());
            string3 = string + ".py";
            string4 = string + "$py.class";
            file2 = new File(string5, string3);
            file3 = new File(string5, string4);
        } else {
            PyModule pyModule = imp.addModule(string2);
            PyString pyString = new PyString(file.getPath());
            pyModule.__dict__.__setitem__("__path__", (PyObject)new PyList(new PyObject[]{pyString}));
            pyModule.__dict__.__setitem__("__file__", (PyObject)pyString);
        }
        if (file2.isFile() && imp.caseok(file2, string3, string3.length())) {
            if (file3.isFile() && imp.caseok(file3, string4, string4.length())) {
                PyObject pyObject2;
                Py.writeDebug(IMPORT_LOG, "trying precompiled " + file3.getPath());
                long l = file2.lastModified();
                long l2 = file3.lastModified();
                if (l2 >= l && (pyObject2 = imp.createFromPyClass(string2, imp.makeStream(file3), true, file2.getAbsolutePath())) != null) {
                    return pyObject2;
                }
            }
            return imp.createFromSource(string2, imp.makeStream(file2), file2.getAbsolutePath());
        }
        Py.writeDebug(IMPORT_LOG, "trying precompiled with no source" + file3.getPath());
        if (file3.isFile() && imp.caseok(file3, string4, string4.length())) {
            return imp.createFromPyClass(string2, imp.makeStream(file3), true, file3.getAbsolutePath());
        }
        return null;
    }

    public static boolean caseok(File file, String string, int n) {
        if (Options.caseok) {
            return true;
        }
        try {
            File file2 = new File(file.getCanonicalPath());
            return string.regionMatches(0, file2.getName(), 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static PyObject load(String string) {
        return imp.import_first(string, new StringBuffer());
    }

    private static String getParent(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__finditem__("__name__");
        if (pyObject2 == null) {
            return null;
        }
        String string = pyObject2.toString();
        pyObject2 = pyObject.__finditem__("__path__");
        if (pyObject2 != null && pyObject2 instanceof PyList) {
            return string.intern();
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n).intern();
    }

    private static PyObject import_next(PyObject pyObject, StringBuffer stringBuffer, String string, String string2, PyObject pyObject2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('.');
        }
        stringBuffer.append(string);
        String string3 = stringBuffer.toString().intern();
        PyObject pyObject3 = Py.getSystemState().modules;
        PyObject pyObject4 = pyObject3.__finditem__(string3);
        if (pyObject4 != null) {
            return pyObject4;
        }
        pyObject4 = pyObject == null ? imp.find_module(string3.intern(), string, null) : pyObject.impAttr(string.intern());
        if (pyObject4 == null || pyObject4 == Py.None) {
            if (JavaImportHelper.tryAddPackage(string2, pyObject2)) {
                pyObject4 = pyObject3.__finditem__(string3);
            }
            return pyObject4;
        }
        if (pyObject3.__finditem__(string3) == null) {
            pyObject3.__setitem__(string3, pyObject4);
        } else {
            pyObject4 = pyObject3.__finditem__(string3);
        }
        return pyObject4;
    }

    private static PyObject import_first(String string, StringBuffer stringBuffer) {
        PyObject pyObject = imp.import_next(null, stringBuffer, string, null, null);
        if (pyObject == null || pyObject == Py.None) {
            throw Py.ImportError("no module named " + string);
        }
        return pyObject;
    }

    private static PyObject import_first(String string, StringBuffer stringBuffer, String string2, PyObject pyObject) {
        PyObject pyObject2 = imp.import_next(null, stringBuffer, string, string2, pyObject);
        if ((pyObject2 == null || pyObject2 == Py.None) && JavaImportHelper.tryAddPackage(string2, pyObject)) {
            pyObject2 = imp.import_next(null, stringBuffer, string, string2, pyObject);
        }
        if (pyObject2 == null || pyObject2 == Py.None) {
            throw Py.ImportError("no module named " + string);
        }
        return pyObject2;
    }

    private static PyObject import_logic(PyObject pyObject, StringBuffer stringBuffer, String string, String string2, PyObject pyObject2) {
        int n = 0;
        int n2 = 0;
        do {
            String string3;
            if ((pyObject = imp.import_next(pyObject, stringBuffer, string3 = (n = string.indexOf(46, n2)) == -1 ? string.substring(n2) : string.substring(n2, n), string2, pyObject2)) == null || pyObject == Py.None) {
                throw Py.ImportError("no module named " + string3);
            }
            n2 = n + 1;
        } while (n != -1);
        return pyObject;
    }

    private static PyObject import_name(String string, boolean bl, PyObject pyObject, PyObject pyObject2) {
        int n;
        String string2;
        StringBuffer stringBuffer;
        PyObject pyObject3;
        if (string.length() == 0) {
            throw Py.ValueError("Empty module name");
        }
        PyObject pyObject4 = Py.getSystemState().modules;
        PyObject pyObject5 = null;
        String string3 = null;
        if (pyObject != null && (pyObject5 = pyObject4.__finditem__(string3 = imp.getParent(pyObject))) != null && !(pyObject5 instanceof PyModule)) {
            pyObject5 = null;
        }
        if ((pyObject3 = imp.import_next(pyObject5, stringBuffer = new StringBuffer(pyObject5 != null ? string3 : ""), string2 = (n = string.indexOf(46)) == -1 ? string : string.substring(0, n), string, pyObject2)) == Py.None || pyObject3 == null) {
            if (pyObject3 == null) {
                pyObject4.__setitem__(stringBuffer.toString().intern(), Py.None);
            }
            stringBuffer = new StringBuffer("");
            pyObject3 = imp.import_first(string2, stringBuffer, string, pyObject2);
        }
        PyObject pyObject6 = pyObject3;
        if (n != -1) {
            pyObject6 = imp.import_logic(pyObject3, stringBuffer, string.substring(n + 1), string, pyObject2);
        }
        if (bl) {
            return pyObject3;
        }
        return pyObject6;
    }

    public static PyObject importName(String string, boolean bl) {
        return imp.import_name(string, bl, null, null);
    }

    public static synchronized PyObject importName(String string, boolean bl, PyObject pyObject, PyObject pyObject2) {
        return imp.import_name(string, bl, pyObject, pyObject2);
    }

    public static PyObject importOne(String string, PyFrame pyFrame) {
        PyObject pyObject = __builtin__.__import__(string, pyFrame.f_globals, pyFrame.getf_locals(), Py.EmptyTuple);
        return pyObject;
    }

    public static PyObject importOneAs(String string, PyFrame pyFrame) {
        PyObject pyObject = __builtin__.__import__(string, pyFrame.f_globals, pyFrame.getf_locals(), imp.getStarArg());
        return pyObject;
    }

    public static PyObject[] importFrom(String string, String[] stringArray, PyFrame pyFrame) {
        return imp.importFromAs(string, stringArray, null, pyFrame);
    }

    public static PyObject[] importFromAs(String string, String[] stringArray, String[] stringArray2, PyFrame pyFrame) {
        Serializable serializable;
        int n;
        PyObject[] pyObjectArray = new PyObject[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pyObjectArray[i] = Py.newString(stringArray[i]);
        }
        PyObject pyObject = __builtin__.__import__(string, pyFrame.f_globals, pyFrame.getf_locals(), new PyTuple(pyObjectArray));
        PyObject[] pyObjectArray2 = new PyObject[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n = 0; n < stringArray.length; ++n) {
            serializable = pyObject.__findattr__(stringArray[n]);
            if (serializable == null && pyObject instanceof PyJavaPackage && JavaImportHelper.tryAddPackage(string + "." + stringArray[n], null)) {
                serializable = pyObject.__findattr__(stringArray[n]);
            }
            if (serializable == null) {
                arrayList.add(stringArray[n]);
                continue;
            }
            pyObjectArray2[n] = serializable;
        }
        n = arrayList.size();
        if (n > 0) {
            serializable = new StringBuffer(20);
            ((StringBuffer)serializable).append("cannot import name");
            if (n > 1) {
                ((StringBuffer)serializable).append("s");
            }
            Iterator iterator = arrayList.iterator();
            ((StringBuffer)serializable).append(" ");
            ((StringBuffer)serializable).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuffer)serializable).append(", ");
                ((StringBuffer)serializable).append(iterator.next());
            }
            throw Py.ImportError(((StringBuffer)serializable).toString());
        }
        return pyObjectArray2;
    }

    private static synchronized PyTuple getStarArg() {
        if (all == null) {
            all = new PyTuple(new PyString[]{Py.newString('*')});
        }
        return all;
    }

    public static void importAll(String string, PyFrame pyFrame) {
        PyObject pyObject;
        PyObject pyObject2 = __builtin__.__import__(string, pyFrame.f_globals, pyFrame.getf_locals(), imp.getStarArg());
        boolean bl = true;
        if (pyObject2 instanceof PyJavaPackage) {
            pyObject = ((PyJavaPackage)pyObject2).fillDir();
        } else {
            PyObject pyObject3 = pyObject2.__findattr__("__all__");
            if (pyObject3 != null) {
                pyObject = pyObject3;
                bl = false;
            } else {
                pyObject = pyObject2.__dir__();
            }
        }
        imp.loadNames(pyObject, pyObject2, pyFrame.getf_locals(), bl);
    }

    private static void loadNames(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, boolean bl) {
        PyObject pyObject4;
        PyObject pyObject5 = pyObject.__iter__();
        while ((pyObject4 = pyObject5.__iternext__()) != null) {
            String string = ((PyString)pyObject4).internedString();
            if (bl && string.startsWith("_")) continue;
            try {
                pyObject3.__setitem__(string, pyObject2.__getattr__(string));
            }
            catch (Exception exception) {}
        }
    }

    static PyObject reload(PyJavaClass pyJavaClass) {
        return pyJavaClass;
    }

    static PyObject reload(PyModule pyModule) {
        Object object;
        PyObject pyObject = Py.getSystemState().modules;
        String string = pyModule.__getattr__("__name__").toString().intern();
        PyModule pyModule2 = (PyModule)pyObject.__finditem__(string);
        if (pyModule2 == null || !pyModule2.__getattr__("__name__").toString().equals(string)) {
            throw Py.ImportError("reload(): module " + string + " not in sys.modules");
        }
        PyList pyList = Py.getSystemState().path;
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            object = string.substring(0, n).intern();
            PyObject pyObject2 = pyObject.__finditem__((String)object);
            if (pyObject2 == null) {
                throw Py.ImportError("reload(): parent not in sys.modules");
            }
            pyList = (PyList)pyObject2.__getattr__("__path__");
            string = string.substring(n + 1, string.length()).intern();
        }
        pyModule2.__setattr__("__name__", (PyObject)new PyString(string2));
        object = imp.find_module(string, string2, pyList);
        pyObject.__setitem__(string2, (PyObject)object);
        return object;
    }
}

