/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import com.squareup.javapoet.ClassName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import react4j.annotations.EventHandler;
import react4j.processor.EventHandlerDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ReactProcessorException;

final class ComponentDescriptor {
    @Nonnull
    private final String _name;
    @Nonnull
    private final PackageElement _packageElement;
    @Nonnull
    private final TypeElement _element;
    private boolean _arezComponent;
    @Nullable
    private TypeElement _propsType;
    @Nullable
    private TypeElement _stateType;
    @Nullable
    private List<MethodDescriptor> _lifecycleMethods;
    @Nullable
    private List<EventHandlerDescriptor> _eventHandlers;

    ComponentDescriptor(@Nonnull String name, @Nonnull PackageElement packageElement, @Nonnull TypeElement element) {
        this._name = Objects.requireNonNull(name);
        this._packageElement = Objects.requireNonNull(packageElement);
        this._element = Objects.requireNonNull(element);
        if (ElementKind.CLASS != element.getKind()) {
            throw new ReactProcessorException("@ReactComponent target must be a class", element);
        }
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@ReactComponent target must not be abstract", element);
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ReactProcessorException("@ReactComponent target must not be final", element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@ReactComponent target must not be a non-static nested class", element);
        }
        List constructors = element.getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.CONSTRUCTOR).map(m -> (ExecutableElement)m).collect(Collectors.toList());
        if (1 != constructors.size() || !((ExecutableElement)constructors.get(0)).getParameters().isEmpty() || ((ExecutableElement)constructors.get(0)).getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ReactProcessorException("@ReactComponent target must have a single non-private, no-argument constructor or the default constructor", element);
        }
    }

    @Nonnull
    String getPackageName() {
        return this._packageElement.getQualifiedName().toString();
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    DeclaredType getDeclaredType() {
        return (DeclaredType)this._element.asType();
    }

    @Nonnull
    String getConstructorFactoryName() {
        return this._element.getSimpleName() + "_";
    }

    @Nonnull
    String getNativeComponentName() {
        return "React_" + this._element.getSimpleName();
    }

    @Nonnull
    ClassName getNativeComponentClassName() {
        return ClassName.get((String)this.getPackageName(), (String)(this.getNestedClassPrefix() + this.getNativeComponentName()), (String[])new String[0]);
    }

    boolean isArezComponent() {
        return this._arezComponent;
    }

    void setArezComponent(boolean arezComponent) {
        this._arezComponent = arezComponent;
    }

    @Nonnull
    TypeElement getPropsType() {
        assert (null != this._propsType);
        return this._propsType;
    }

    void setPropsType(@Nonnull TypeElement propsType) {
        this._propsType = Objects.requireNonNull(propsType);
    }

    @Nonnull
    TypeElement getStateType() {
        assert (null != this._stateType);
        return this._stateType;
    }

    void setStateType(@Nonnull TypeElement stateType) {
        this._stateType = Objects.requireNonNull(stateType);
    }

    @Nonnull
    String getNestedClassPrefix() {
        StringBuilder name = new StringBuilder();
        TypeElement t = this.getElement();
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "$");
        }
        return name.toString();
    }

    @Nonnull
    List<MethodDescriptor> getLifecycleMethods() {
        assert (null != this._lifecycleMethods);
        return this._lifecycleMethods;
    }

    void setLifecycleMethods(@Nonnull List<MethodDescriptor> lifecycleMethods) {
        this._lifecycleMethods = Objects.requireNonNull(lifecycleMethods);
        for (MethodDescriptor method : this._lifecycleMethods) {
            ExecutableElement m = method.getMethod();
            if (null == m.getAnnotation(EventHandler.class)) continue;
            throw new ReactProcessorException("@EventHandler target must not be a lifecycle method", m);
        }
    }

    @Nonnull
    List<EventHandlerDescriptor> getEventHandlers() {
        assert (null != this._eventHandlers);
        return this._eventHandlers;
    }

    void setEventHandlers(@Nonnull List<EventHandlerDescriptor> eventHandlers) {
        this._eventHandlers = Objects.requireNonNull(eventHandlers);
    }
}

