/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Element;
import org.revapi.ElementFilter;

public class ConfigurableElementFilter
implements ElementFilter {
    private final List<Pattern> includes = new ArrayList<Pattern>();
    private final List<Pattern> excludes = new ArrayList<Pattern>();

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{"revapi.filter"};
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.filter".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/filter-schema.json"));
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode excludeNode;
        ModelNode root = analysisContext.getConfiguration().get(new String[]{"revapi", "filter"});
        if (!root.isDefined()) {
            return;
        }
        ModelNode includeNode = root.get("include");
        if (includeNode.isDefined()) {
            for (ModelNode inc : includeNode.asList()) {
                this.includes.add(Pattern.compile(inc.asString()));
            }
        }
        if ((excludeNode = root.get("exclude")).isDefined()) {
            for (ModelNode exc : excludeNode.asList()) {
                this.excludes.add(Pattern.compile(exc.asString()));
            }
        }
    }

    public boolean applies(@Nullable Element element) {
        String representation;
        boolean include = true;
        String string = representation = element == null ? "" : element.getFullHumanReadableString();
        if (!this.includes.isEmpty()) {
            include = false;
            for (Pattern p : this.includes) {
                if (!p.matcher(representation).matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            for (Pattern p : this.excludes) {
                if (!p.matcher(representation).matches()) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    public boolean shouldDescendInto(@Nullable Object element) {
        return true;
    }

    public void close() {
    }
}

