/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.fest.assertions.Fail;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.model.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Beta
public class JavaCheckVerifier
extends CheckVerifier {
    private static final String DEFAULT_TEST_JARS_DIRECTORY = "target/test-jars";
    private String testJarsDirectory = "target/test-jars";
    private boolean providedJavaVersion = false;
    private JavaVersion javaVersion = new JavaVersionImpl();

    private JavaCheckVerifier() {
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "// Noncompliant";
    }

    public static void verify(String filename, JavaFileScanner check) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier());
    }

    public static void verify(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verify(String filename, JavaFileScanner check, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier(), classpath);
    }

    public static void verify(String filename, JavaFileScanner check, String testJarsDirectory) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.testJarsDirectory = testJarsDirectory;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues();
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssueWithoutSemantic(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier(){

            @Override
            public String getExpectedIssueTrigger() {
                return "// NOSEMANTIC_ISSUE";
            }
        };
        javaCheckVerifier.expectNoIssues();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, Collections.emptyList(), false);
    }

    public static void verifyNoIssueWithoutSemantic(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier(){

            @Override
            public String getExpectedIssueTrigger() {
                return "// NOSEMANTIC_ISSUE";
            }
        };
        javaCheckVerifier.expectNoIssues();
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, Collections.emptyList(), false);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.setExpectedFileIssue(message);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier) {
        Collection classpath = Lists.newLinkedList();
        File testJars = new File(javaCheckVerifier.testJarsDirectory);
        if (testJars.exists()) {
            classpath = FileUtils.listFiles((File)testJars, (String[])new String[]{"jar", "zip"}, (boolean)true);
        } else if (!DEFAULT_TEST_JARS_DIRECTORY.equals(javaCheckVerifier.testJarsDirectory)) {
            Fail.fail((String)("The directory to be used to extend class path does not exists (" + testJars.getAbsolutePath() + ")."));
        }
        classpath.add(new File("target/test-classes"));
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, classpath);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, classpath, true);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath, boolean withSemantic) {
        ExpectedIssueCollector expectedIssueCollector = new ExpectedIssueCollector(javaCheckVerifier);
        VisitorsBridgeForTests visitorsBridge = withSemantic ? new VisitorsBridgeForTests((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, expectedIssueCollector}), (List)Lists.newArrayList(classpath), null) : new VisitorsBridgeForTests((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, expectedIssueCollector}));
        JavaConfiguration conf = new JavaConfiguration(Charset.forName("UTF-8"));
        conf.setJavaVersion(javaCheckVerifier.javaVersion);
        JavaAstScanner.scanSingleFileForTests((File)new File(filename), (VisitorsBridge)visitorsBridge, (JavaConfiguration)conf);
        VisitorsBridgeForTests.TestJavaFileScannerContext testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        if (testJavaFileScannerContext == null) {
            Fail.fail((String)"Semantic was required but it was not possible to create it. Please checks the logs to find out the reason.");
        }
        javaCheckVerifier.checkIssues(testJavaFileScannerContext.getIssues(), javaCheckVerifier.providedJavaVersion);
    }

    private static class ExpectedIssueCollector
    extends SubscriptionVisitor {
        private final JavaCheckVerifier verifier;

        public ExpectedIssueCollector(JavaCheckVerifier verifier) {
            this.verifier = verifier;
        }

        public List<Tree.Kind> nodesToVisit() {
            return ImmutableList.of((Object)Tree.Kind.TRIVIA);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.verifier.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.startLine());
        }
    }
}

