/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2111", name="\"BigDecimal(double)\" should not be used", priority=Priority.CRITICAL, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class BigDecimalDoubleConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree nct;
        if (this.hasSemantic() && (nct = (NewClassTree)tree).symbolType().is("java.math.BigDecimal") && BigDecimalDoubleConstructorCheck.isDoubleConstructor(nct)) {
            this.reportIssue(tree, "Use \"BigDecimal.valueOf\" instead.");
        }
    }

    private static boolean isDoubleConstructor(NewClassTree nct) {
        if (!nct.arguments().isEmpty() && nct.arguments().size() <= 2) {
            Type argumentType = ((ExpressionTree)nct.arguments().get(0)).symbolType();
            return argumentType.is("double") || argumentType.is("float");
        }
        return false;
    }
}

