/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3398", name="\"private\" methods called only by inner classes should be moved to those classes", priority=Priority.MAJOR, tags={"confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class CallOuterPrivateMethodCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol classSymbol = classTree.symbol();
        if (CallOuterPrivateMethodCheck.isInnerClass((Symbol)classSymbol)) {
            MethodInvocationVisitor methodInvocationVisitor = new MethodInvocationVisitor(classSymbol);
            classTree.accept((TreeVisitor)methodInvocationVisitor);
            methodInvocationVisitor.checkUsages();
        }
    }

    private static boolean isInnerClass(Symbol symbol) {
        return symbol.owner().isTypeSymbol();
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        private final Symbol.TypeSymbol classSymbol;
        private final Multiset<Symbol> usages = HashMultiset.create();

        public MethodInvocationVisitor(Symbol.TypeSymbol classSymbol) {
            this.classSymbol = classSymbol;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol = tree.symbol();
            if (this.isPrivateMethodOfOuterClass(symbol)) {
                this.usages.add((Object)symbol);
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isPrivateMethodOfOuterClass(Symbol symbol) {
            return symbol.isPrivate() && symbol.owner().equals(this.classSymbol.owner());
        }

        public void checkUsages() {
            for (Symbol methodUsed : this.usages.elementSet()) {
                MethodTree declaration;
                if (methodUsed.usages().size() != this.usages.count((Object)methodUsed) || (declaration = (MethodTree)methodUsed.declaration()) == null) continue;
                CallOuterPrivateMethodCheck.this.reportIssue((Tree)declaration.simpleName(), "Move this method into \"" + this.classSymbol.name() + "\".");
            }
        }
    }
}

