/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1696", name="\"NullPointerException\" should not be caught", priority=Priority.MAJOR, tags={"cert", "cwe", "error-handling"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class CatchNPECheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCatch(CatchTree tree) {
        super.visitCatch(tree);
        TypeTree typeTree = tree.parameter().type();
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            UnionTypeTree unionTypeTree = (UnionTypeTree)typeTree;
            for (Tree typeAlternativeTree : unionTypeTree.typeAlternatives()) {
                this.checkType(typeAlternativeTree);
            }
        } else {
            this.checkType((Tree)typeTree);
        }
    }

    private void checkType(Tree tree) {
        MemberSelectExpressionTree memberSelectTree2;
        ExpressionTree tree2;
        MemberSelectExpressionTree memberSelectTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)tree;
            if (CatchNPECheck.isNPE(identifier.name())) {
                this.addIssue(identifier);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && CatchNPECheck.isNPE((memberSelectTree = (MemberSelectExpressionTree)tree).identifier().name()) && (tree2 = memberSelectTree.expression()).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "lang".equals((memberSelectTree2 = (MemberSelectExpressionTree)tree2).identifier().name()) && memberSelectTree2.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "java".equals(((IdentifierTree)memberSelectTree2.expression()).name())) {
            this.addIssue(memberSelectTree.identifier());
        }
    }

    private static boolean isNPE(String name) {
        return "NullPointerException".equals(name);
    }

    private void addIssue(IdentifierTree tree) {
        this.context.reportIssue((JavaCheck)this, (Tree)tree, "Avoid catching NullPointerException.");
    }
}

