/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2638", name="Method overrides should not change contracts", priority=Priority.MAJOR, tags={"suspicious"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="15min")
@ActivatedByDefault
public class ChangeMethodContractCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        JavaSymbol.MethodJavaSymbol overridee = ((JavaSymbol.MethodJavaSymbol)methodSymbol).overriddenSymbol();
        if (overridee != null && overridee.isMethodSymbol()) {
            this.checkContractChange(methodTree, overridee);
        }
    }

    private void checkContractChange(MethodTreeImpl methodTree, JavaSymbol.MethodJavaSymbol overridee) {
        if (methodTree.isEqualsMethod() && ((VariableTree)methodTree.parameters().get(0)).symbol().metadata().isAnnotatedWith("javax.annotation.Nonnull")) {
            this.reportIssue((Tree)methodTree.parameters().get(0), "Equals method should accept null parameters and return false.");
            return;
        }
        for (int i = 0; i < methodTree.parameters().size(); ++i) {
            Symbol overrideeParamSymbol;
            Symbol paramSymbol = ((VariableTree)methodTree.parameters().get(i)).symbol();
            if (!ChangeMethodContractCheck.nonNullVsNull(paramSymbol, overrideeParamSymbol = (Symbol)overridee.getParameters().scopeSymbols().get(i)) && !ChangeMethodContractCheck.nonNullVsNull(overrideeParamSymbol, paramSymbol)) continue;
            this.reportIssue((Tree)methodTree.parameters().get(i), "The \"" + paramSymbol.name() + "\" parameter nullability is different in the superclass method, and that should not be changed.");
        }
        if (ChangeMethodContractCheck.nonNullVsNull((Symbol)methodTree.symbol(), (Symbol)overridee) || ChangeMethodContractCheck.nonNullVsNull((Symbol)overridee, (Symbol)methodTree.symbol())) {
            this.reportIssue((Tree)methodTree.returnType(), "The return value nullability of this method is different in the superclass, and that should not be changed.");
        }
    }

    private static boolean nonNullVsNull(Symbol sym1, Symbol sym2) {
        return sym1.metadata().isAnnotatedWith("javax.annotation.Nonnull") && (sym2.metadata().isAnnotatedWith("javax.annotation.Nullable") || sym2.metadata().isAnnotatedWith("javax.annotation.CheckForNull"));
    }
}

