/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2147", name="Catches should be combined", priority=Priority.MAJOR, tags={"clumsy"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class CombineCatchCheck
extends SubscriptionBaseVisitor
implements JavaVersionAwareVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.TRY_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
        for (CatchTree catchTree : ((TryStatementTree)tree).catches()) {
            for (CatchTree catchTreeToBeCompared : catches) {
                if (!SyntacticEquivalence.areEquivalent((Tree)catchTree.block(), (Tree)catchTreeToBeCompared.block())) continue;
                this.reportIssue(catchTree, catchTreeToBeCompared);
                break;
            }
            catches.add(catchTree);
        }
    }

    private void reportIssue(CatchTree catchTree, CatchTree catchTreeToBeCompared) {
        String message = "Combine this catch with the one at line " + catchTreeToBeCompared.catchKeyword().line() + ", which has the same body." + this.context.getJavaVersion().java7CompatibilityMessage();
        ArrayList flow = Lists.newArrayList((Object[])new JavaFileScannerContext.Location[]{new JavaFileScannerContext.Location("Combine with this catch", (Tree)catchTreeToBeCompared)});
        this.reportIssue((Tree)catchTree.parameter(), message, flow, null);
    }

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isNotSet() || version.asInt() >= 7;
    }
}

