/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.NoSqale;
import org.sonar.squidbridge.annotations.RuleTemplate;

@Rule(key="S2253", name="Disallowed methods should not be used", priority=Priority.MAJOR)
@RuleTemplate
@NoSqale
public class DisallowedMethodCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className", description="Name of the class whose method is forbidden")
    private String className = "";
    @RuleProperty(key="methodName", description="Name of the forbidden method")
    private String methodName = "";
    @RuleProperty(key="argumentTypes", description="Comma-delimited list of argument types, E.G. java.lang.String, int[], int")
    private String argumentTypes = "";

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        String[] args;
        if (StringUtils.isEmpty((String)this.methodName)) {
            return ImmutableList.of();
        }
        MethodMatcher invocationMatcher = MethodMatcher.create().name(this.methodName);
        if (StringUtils.isNotEmpty((String)this.className)) {
            invocationMatcher.typeDefinition(this.className);
        }
        for (String arg : args = StringUtils.split((String)this.argumentTypes, (String)",")) {
            invocationMatcher.addParameter(StringUtils.trim((String)arg));
        }
        return ImmutableList.of((Object)invocationMatcher);
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.reportIssue((Tree)MethodsHelper.methodName(mit), "Remove this forbidden call");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }
}

